/*
 * Decompiled with CFR 0.152.
 */
package djb;

import djb.Curve25519;

public class Bench {
    private static byte[] e1 = new byte[]{3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static byte[] e2 = new byte[]{5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static byte[] k = new byte[]{9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static byte[] e1k = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static byte[] e2k = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static byte[] e1e2k = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static byte[] e2e1k = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static byte[] e1s = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static byte[] e2s = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final int BENCH_NOP = 0;
    private static final int BENCH_AGREE = 1;
    private static final int BENCH_VERIFY = 2;
    private static final int BENCH_KEYGEN = 3;
    private static final int BENCH_SIGN = 4;
    private static final byte[] check1 = new byte[]{-1, -103, 2, 78, 126, -25, -110, -111, 26, -1, -54, -58, 120, -102, -17, -37, 81, 85, 90, -11, -56, 21, -44, -88, -44, -83, -56, -122, -63, -122, 40, 59};
    private static final byte[] check2 = new byte[]{4, 104, -92, -48, -47, -116, -105, 93, 72, -98, -34, 60, 125, -112, 106, -100, 92, -109, 23, -14, 55, -51, -79, 40, -9, -42, -78, -105, -4, 74, -106, 25};
    private static final byte[] check3 = new byte[]{102, 104, -107, 19, 117, -13, 84, 43, 51, -64, 17, 93, 58, 3, 64, -107, 11, -25, 126, 17, 36, -62, -119, -111, 86, -67, -21, 42, -109, 13, -54, 36};
    private static final byte[] check4 = new byte[]{9, -49, -27, 5, 75, 70, 10, 63, -34, 112, 123, 118, -108, 64, -22, 30, 4, -34, -83, 25, -64, 20, 77, 125, -123, -126, -12, 103, 99, -56, -83, 102};
    private static final byte[] check5 = new byte[]{71, 17, -2, -67, -73, -48, 95, 116, -71, 63, -93, 50, -126, 44, -25, -101, -106, 39, 72, -117, 42, -45, 82, 0, -7, -84, 10, -65, -109, 50, 100, 101};

    public static void main(String[] arguments) {
        double tk = 0.0;
        double tv = 0.0;
        System.out.println("\n--- Diffie Hellman (ECDH) ---\n");
        Bench.benchmark("Key agreement", 1, 4, 0.0);
        Bench.test_equal(k, check1);
        System.out.println(" Keypair generation : same\n");
        System.out.println("\n--- Digital Signatures (EC-KCDSA) ---\n");
        tv = Bench.benchmark("Verification", 2, 4, 0.0);
        Bench.test_equal(k, check2);
        tk = Bench.benchmark("Keypair generation", 3, 2, tv);
        Bench.test_equal(e1k, check3);
        Bench.test_equal(e2k, check4);
        Bench.benchmark("Signing", 4, 1, tk + tv);
        Bench.test_equal(k, check5);
        System.out.println("\nOK");
    }

    private static final void xor25519(byte[] d, byte[] s) {
        for (int i = 0; i < 32; ++i) {
            int n = i;
            d[n] = (byte)(d[n] ^ s[i]);
        }
    }

    private static final void test_equal(byte[] a, byte[] b) {
        for (int i = 0; i < 32; ++i) {
            if (a[i] == b[i]) continue;
            System.err.println("\n*** consistency check failed ***\n");
            System.exit(-1);
        }
    }

    private static final void state_update() {
        Bench.test_equal(e1e2k, e2e1k);
        Bench.xor25519(e1, e2k);
        Bench.xor25519(e2, e1k);
        Bench.xor25519(k, e1e2k);
    }

    private static final long time_bench(int bench, int count) {
        long start = System.nanoTime();
        while (count != 0) {
            switch (bench) {
                case 0: {
                    Bench.state_update();
                    break;
                }
                case 1: {
                    Curve25519.curve(e1k, e1, k);
                    Curve25519.curve(e2e1k, e2, e1k);
                    Curve25519.curve(e2k, e2, k);
                    Curve25519.curve(e1e2k, e1, e2k);
                    Bench.state_update();
                    break;
                }
                case 2: {
                    Curve25519.verify(e1k, e1, Curve25519.ZERO, k);
                    Curve25519.verify(e2e1k, e2, Curve25519.ZERO, e1k);
                    Curve25519.verify(e2k, e2, Curve25519.ZERO, k);
                    Curve25519.verify(e1e2k, e1, Curve25519.ZERO, e2k);
                    Bench.state_update();
                    break;
                }
                case 3: {
                    Curve25519.keygen(e1k, e1s, e1);
                    Curve25519.keygen(e2k, e2s, e2);
                    Curve25519.verify(e1e2k, e1s, k, e1k);
                    Curve25519.verify(e2e1k, e2s, k, e2k);
                    Bench.state_update();
                    break;
                }
                case 4: {
                    Curve25519.keygen(e1k, e1, e1);
                    Curve25519.keygen(e1e2k, null, e2);
                    Curve25519.sign(e2k, e1e2k, e2, e1);
                    Curve25519.verify(e2e1k, e2k, e1e2k, e1k);
                    Bench.state_update();
                }
            }
            --count;
        }
        return (System.nanoTime() - start) / 1000L;
    }

    static double benchmark(String what, int bench, int div, double offset) {
        int TRIES = 3;
        int COUNT = 2000;
        double leasttime = 1.0E10;
        System.out.printf(" %-18s : ", what);
        int i = 3;
        while (i-- != 0) {
            double time = Bench.time_bench(bench, 2000 / div);
            time -= (double)Bench.time_bench(0, 2000 / div);
            if ((time = time / 2000000.0 - offset) < leasttime) {
                leasttime = time;
            }
            System.out.printf("%.3f ", time);
        }
        System.out.println("ms");
        return leasttime;
    }
}

