/*
 * Decompiled with CFR 0.152.
 */
package org.zeromq.jms;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import org.zeromq.jms.ZmqConnection;
import org.zeromq.jms.ZmqException;
import org.zeromq.jms.ZmqURI;
import org.zeromq.jms.protocol.ZmqGatewayFactory;

public class ZmqConnectionFactory
implements QueueConnectionFactory,
TopicConnectionFactory {
    private static final Logger LOGGER = Logger.getLogger(ZmqConnectionFactory.class.getCanonicalName());
    private final Map<String, ZmqURI> destinationSchema = new HashMap<String, ZmqURI>();
    private String gatewayFactoryClassName = ZmqGatewayFactory.class.getCanonicalName();
    private String[] packageNameExtensions = null;

    public ZmqConnectionFactory() {
    }

    public ZmqConnectionFactory(String[] destinations) {
        if (destinations != null && destinations.length > 0) {
            this.setDestinations(destinations);
        }
    }

    public ZmqConnectionFactory(String gatewayFactoryClassName, String[] packageNameExtensions, String[] destinations) {
        this.gatewayFactoryClassName = gatewayFactoryClassName;
        this.packageNameExtensions = packageNameExtensions;
        if (destinations != null && destinations.length > 0) {
            this.setDestinations(destinations);
        }
    }

    public void setDestinations(String[] destinations) {
        for (int i = 0; i < destinations.length; ++i) {
            ZmqURI uri = ZmqURI.create(destinations[i]);
            this.destinationSchema.put(uri.getDestinationName(), uri);
        }
    }

    public Connection createConnection() throws JMSException {
        LOGGER.info("Create connection");
        return this.createQueueConnection();
    }

    public Connection createConnection(String userName, String password) throws JMSException {
        LOGGER.info("Create connection");
        return this.createQueueConnection(userName, password);
    }

    private ZmqGatewayFactory getFactoryGateway() throws ZmqException {
        try {
            Class<?> gatewayFactoryClass = Class.forName(this.gatewayFactoryClassName);
            Constructor<?> gatewayFactoryConstructor = gatewayFactoryClass.getConstructor(String[].class, Map.class);
            ZmqGatewayFactory gatewayFactory = (ZmqGatewayFactory)gatewayFactoryConstructor.newInstance(this.packageNameExtensions, this.destinationSchema);
            return gatewayFactory;
        }
        catch (ClassNotFoundException ex) {
            throw new ZmqException("Class could not be found.", ex);
        }
        catch (NoSuchMethodException | SecurityException ex) {
            throw new ZmqException("Unable to find required constructor for class: " + this.gatewayFactoryClassName, ex);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException ex) {
            throw new ZmqException("Unable to invoke constructor for class: " + this.gatewayFactoryClassName, ex);
        }
    }

    public QueueConnection createQueueConnection() throws JMSException {
        LOGGER.info("Create queue connection");
        ZmqGatewayFactory gatewayFactory = this.getFactoryGateway();
        ZmqConnection connection = new ZmqConnection(gatewayFactory, this.destinationSchema);
        return connection;
    }

    public QueueConnection createQueueConnection(String userName, String password) throws JMSException {
        throw new UnsupportedOperationException();
    }

    public TopicConnection createTopicConnection() throws JMSException {
        LOGGER.info("Create topic connection");
        ZmqGatewayFactory gatewayFactory = this.getFactoryGateway();
        ZmqConnection connection = new ZmqConnection(gatewayFactory, this.destinationSchema);
        return connection;
    }

    public TopicConnection createTopicConnection(String userName, String password) throws JMSException {
        throw new UnsupportedOperationException();
    }
}

