/*
 * Decompiled with CFR 0.152.
 */
package org.zeromq.jms;

import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ZmqURI
implements Serializable {
    private static final long serialVersionUID = -3213444642911276900L;
    private static final String TOKENISE_REGX = "(tcp://(\\*|((\\w+|\\.)+)):\\d+)|(inproc://\\w+)|(\\w|\\.)+|:|\\?|=|\\&";
    private final String str;
    private final String scheme;
    private final String destinationType;
    private final String destinationName;
    private final Map<String, List<String>> options;

    private ZmqURI(String str, String scheme, String destinationType, String destinationName, Map<String, List<String>> options) {
        this.str = str;
        this.scheme = scheme;
        this.destinationType = destinationType;
        this.destinationName = destinationName;
        this.options = options;
    }

    public static ZmqURI create(String str) throws IllegalArgumentException {
        try {
            ZmqURI uri = ZmqURI.parse(str);
            return uri;
        }
        catch (ParseException ex) {
            throw new IllegalArgumentException("URI string cannot be parse: " + str, ex);
        }
    }

    private static String parseValue(String regex, int index, List<Token> tokens) throws ParseException {
        int pos = 0;
        if (0 <= index - 1) {
            Token prevToken = tokens.get(index - 1);
            pos = prevToken.pos + prevToken.value.length();
        }
        if (index >= tokens.size()) {
            throw new ParseException("Missing expecting value:" + regex, pos);
        }
        String value = tokens.get(index).value;
        Pattern pattern = Pattern.compile(regex, 2);
        if (!pattern.matcher(value).matches()) {
            throw new ParseException("Invalid value [" + value + "] for pattern: " + regex, pos);
        }
        return value;
    }

    private static ZmqURI parse(String str) throws ParseException {
        Pattern pattern = Pattern.compile(TOKENISE_REGX, 2);
        Matcher matcher = pattern.matcher(str);
        ArrayList<Token> tokens = new ArrayList<Token>();
        int start = 0;
        while (matcher.find(start)) {
            String token = matcher.group();
            tokens.add(new Token(token, start));
            start = matcher.end();
        }
        int index = 0;
        String scheme = ZmqURI.parseValue("jms", index++, tokens);
        ZmqURI.parseValue(":", index++, tokens);
        String destinationType = ZmqURI.parseValue("(queue|topic)", index++, tokens);
        ZmqURI.parseValue(":", index++, tokens);
        String destinationName = ZmqURI.parseValue("\\w+", index++, tokens);
        HashMap<String, List<String>> options = new HashMap<String, List<String>>();
        if (tokens.size() > index) {
            ZmqURI.parseValue("\\?", index++, tokens);
            for (int i = index; i < tokens.size(); ++i) {
                String optionName = ZmqURI.parseValue("(\\w|\\.)+", i, tokens);
                String optionValue = null;
                ZmqURI.parseValue("=", ++i, tokens);
                if (tokens.size() > i + 1) {
                    if (!((Token)tokens.get(i + 1)).hasValue("\\&")) {
                        optionValue = ZmqURI.parseValue(".*", ++i, tokens);
                    }
                    if (tokens.size() > i + 1) {
                        ZmqURI.parseValue("\\&", ++i, tokens);
                    }
                }
                if (!options.containsKey(optionName)) {
                    options.put(optionName, new ArrayList());
                }
                List optionValues = (List)options.get(optionName);
                optionValues.add(optionValue);
            }
        }
        ZmqURI uri = new ZmqURI(str, scheme, destinationType, destinationName, options);
        return uri;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getDestinationType() {
        return this.destinationType;
    }

    public String getDestinationName() {
        return this.destinationName;
    }

    public boolean isOption(String paramName) {
        return this.options.containsKey(paramName);
    }

    public Map<String, List<String>> getOptions() {
        return this.options;
    }

    public String[] getOptionValues(String paramName) {
        List<String> values = this.options.get(paramName);
        if (values == null) {
            return null;
        }
        return values.toArray(new String[0]);
    }

    public String[] getOptionValues(String paramName, String[] defaultValues) {
        String[] values = this.getOptionValues(paramName);
        if (values == null) {
            return defaultValues;
        }
        return values;
    }

    public String getOptionValue(String paramName) {
        String[] values = this.getOptionValues(paramName);
        if (values == null || values.length == 0) {
            return null;
        }
        return values[0];
    }

    public String getOptionValue(String paramName, String defaultValue) {
        String[] values = this.getOptionValues(paramName);
        if (values == null || values.length == 0) {
            return defaultValue;
        }
        return values[0];
    }

    public boolean getOptionValue(String paramName, boolean defaultValue) {
        String[] values = this.getOptionValues(paramName);
        if (values == null || values.length == 0) {
            return defaultValue;
        }
        return Boolean.parseBoolean(values[0]);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.destinationName == null ? 0 : this.destinationName.hashCode());
        result = 31 * result + (this.str == null ? 0 : this.str.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ZmqURI other = (ZmqURI)obj;
        if (this.destinationName == null ? other.destinationName != null : !this.destinationName.equals(other.destinationName)) {
            return false;
        }
        return !(this.str == null ? other.str != null : !this.str.equals(other.str));
    }

    public String toString() {
        return "ZmqURI [str=" + this.str + "]";
    }

    private static final class Token {
        private final String value;
        private final int pos;

        private Token(String value, int pos) {
            this.value = value;
            this.pos = pos;
        }

        private boolean hasValue(String value) {
            return this.value.equals(value);
        }

        public String toString() {
            return "Token [value=" + this.value + ", pos=" + this.pos + "]";
        }
    }
}

