/*
 * Decompiled with CFR 0.152.
 */
package org.zeromq.jms.annotation;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.zeromq.jms.annotation.ZmqUriParameter;

public class ClassUtils {
    private static final Logger LOGGER = Logger.getLogger(ClassUtils.class.getCanonicalName());

    private ClassUtils() {
    }

    public static Class<?> getClass(List<Class<?>> possibleClasses, Class<? extends Annotation> annotation, String name, String value) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Class<?> clazz = null;
        for (Class<?> possibleClass : possibleClasses) {
            if (possibleClass.isAnnotationPresent(annotation)) {
                Annotation annotationClass = possibleClass.getAnnotation(annotation);
                Class<? extends Annotation> type = annotationClass.annotationType();
                for (Method method : type.getDeclaredMethods()) {
                    Object attributeValue;
                    if (!method.getName().equals(name) || method.getParameterTypes().length != 0 || (attributeValue = method.invoke((Object)annotationClass, new Object[0])) == null || !attributeValue.equals(value)) continue;
                    if (clazz != null) {
                        throw new IllegalStateException("Conflict with value (" + name + "=" + value + " ) between classes: " + clazz.getCanonicalName() + ", " + possibleClass.getCanonicalName());
                    }
                    clazz = possibleClass;
                }
            }
            if (!possibleClass.getSimpleName().equals(value)) continue;
            if (clazz != null) {
                throw new IllegalStateException("Conflict with value (" + name + "=" + value + " ) between classes: " + clazz.getCanonicalName() + ", " + possibleClass.getCanonicalName());
            }
            clazz = possibleClass;
        }
        if (clazz == null && value.contains(".")) {
            try {
                clazz = Class.forName(value);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return clazz;
    }

    public static Method getSetterMethod(Class<?> clazz, Class<? extends Annotation> annotation, String name, String value) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Method setterMethod = null;
        for (Method possibleMethod : clazz.getMethods()) {
            String methodName;
            if (possibleMethod.isAnnotationPresent(annotation)) {
                Annotation[] methodAnnotations;
                for (Annotation methodAnnotation : methodAnnotations = possibleMethod.getDeclaredAnnotations()) {
                    if (!annotation.isInstance(methodAnnotation)) continue;
                    Class<? extends Annotation> type = methodAnnotation.annotationType();
                    for (Method annotationMethod : type.getDeclaredMethods()) {
                        Object attributeValue;
                        if (!annotationMethod.getName().equals(name) || annotationMethod.getParameterTypes().length != 0 || (attributeValue = annotationMethod.invoke((Object)methodAnnotation, new Object[0])) == null || !attributeValue.equals(value)) continue;
                        if (setterMethod != null) {
                            throw new IllegalStateException("Conflict with value (" + name + "=" + value + " ) between methods: " + setterMethod.getName() + ", " + possibleMethod.getName());
                        }
                        setterMethod = possibleMethod;
                    }
                }
            }
            if (possibleMethod.getParameterTypes().length != 1 || !(methodName = possibleMethod.getName()).equalsIgnoreCase(value) && !methodName.equalsIgnoreCase("set" + value)) continue;
            if (setterMethod != null) {
                throw new IllegalStateException("Conflict with value (" + name + "=" + value + " ) between methods: " + setterMethod.getName() + ", " + possibleMethod.getName());
            }
            setterMethod = possibleMethod;
        }
        return setterMethod;
    }

    public static List<Method> getMethods(Class<?> clazz, Class<? extends Annotation> annotation) {
        LinkedList<Method> annotatedMethods = new LinkedList<Method>();
        for (Method method : clazz.getMethods()) {
            if (!method.isAnnotationPresent(annotation)) continue;
            annotatedMethods.add(method);
        }
        return annotatedMethods;
    }

    public static List<Class<?>> getClasses(String packageName, Class<? extends Annotation> annotation) throws ClassNotFoundException, IOException {
        List<Class<?>> classes = ClassUtils.getClasses(packageName);
        LinkedList annotatedClasses = new LinkedList();
        for (Class<?> clazz : classes) {
            if (!clazz.isAnnotationPresent(annotation)) continue;
            annotatedClasses.add(clazz);
        }
        return annotatedClasses;
    }

    public static boolean packageExists(String packageName) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        String path = packageName.replace('.', '/');
        try {
            Enumeration<URL> resources = classLoader.getResources(path);
            while (resources.hasMoreElements()) {
                URL resource = resources.nextElement();
                if (resource != null) continue;
                LOGGER.warning("Unable to retrieve resources from the package: " + packageName);
                return false;
            }
        }
        catch (IOException ex) {
            LOGGER.warning("Unable to locate package: " + packageName);
            return false;
        }
        return true;
    }

    public static List<Class<?>> getClasses(String packageName) throws ClassNotFoundException, IOException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        String path = packageName.replace('.', '/');
        Enumeration<URL> resources = classLoader.getResources(path);
        LinkedList<File> dirs = new LinkedList<File>();
        while (resources.hasMoreElements()) {
            URL resource = resources.nextElement();
            dirs.add(new File(resource.getFile()));
        }
        LinkedList classes = new LinkedList();
        for (File directory : dirs) {
            classes.addAll(ClassUtils.findClasses(directory, packageName));
        }
        return classes;
    }

    private static List<Class<?>> findClasses(File directory, String packageName) throws ClassNotFoundException {
        File[] files;
        LinkedList classes = new LinkedList();
        if (!directory.exists()) {
            return classes;
        }
        for (File file : files = directory.listFiles()) {
            if (file.isDirectory()) {
                classes.addAll(ClassUtils.findClasses(file, packageName + "." + file.getName()));
                continue;
            }
            if (!file.getName().endsWith(".class")) continue;
            classes.add(Class.forName(packageName + '.' + file.getName().substring(0, file.getName().length() - 6)));
        }
        return classes;
    }

    public static void setMethods(Map<String, List<String>> parameters, Object config) throws ReflectiveOperationException {
        List<Method> methods = ClassUtils.getMethods(config.getClass(), ZmqUriParameter.class);
        for (Method method : methods) {
            ZmqUriParameter attribute = method.getAnnotation(ZmqUriParameter.class);
            String paramName = attribute.value();
            List<String> paramValues = parameters.get(paramName);
            String paramValue = paramValues == null || paramValues.size() == 0 ? null : paramValues.get(0);
            if (paramValue == null) continue;
            Object value = null;
            Class<?>[] paramTypes = method.getParameterTypes();
            if (paramTypes != null && paramTypes.length == 1) {
                Class<Serializable> paramType = paramTypes[0];
                value = paramType == Integer.TYPE || paramType.isAssignableFrom(Integer.class) ? Integer.valueOf(Integer.parseInt(paramValue)) : (paramType == Short.TYPE || paramType.isAssignableFrom(Short.class) ? Short.decode(paramValue) : (paramType == Double.TYPE || paramType.isAssignableFrom(Double.class) ? Double.valueOf(Double.parseDouble(paramValue)) : (paramType == Float.TYPE || paramType.isAssignableFrom(Float.class) ? Float.valueOf(Float.parseFloat(paramValue)) : (paramType == Boolean.TYPE || paramType.isAssignableFrom(Boolean.class) ? Boolean.valueOf(Boolean.parseBoolean(paramValue)) : paramValue))));
            }
            if (value == null) continue;
            try {
                LOGGER.info("Setting configuration parameter " + paramName + "=" + paramValue + " on: " + config);
                method.invoke(config, value);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
                LOGGER.log(Level.SEVERE, "Unable to invoke setter method: " + method.getName() + "(" + value + ")", ex);
                throw ex;
            }
        }
    }
}

