/*
 * Decompiled with CFR 0.152.
 */
package org.zeromq.jms.protocol.event;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.zeromq.ZFrame;
import org.zeromq.ZMsg;
import org.zeromq.jms.ZmqException;
import org.zeromq.jms.ZmqMessage;
import org.zeromq.jms.annotation.ZmqComponent;
import org.zeromq.jms.annotation.ZmqUriParameter;
import org.zeromq.jms.protocol.ZmqAckEvent;
import org.zeromq.jms.protocol.ZmqEvent;
import org.zeromq.jms.protocol.ZmqHeartbeatEvent;
import org.zeromq.jms.protocol.ZmqSendEvent;
import org.zeromq.jms.protocol.ZmqSocketType;
import org.zeromq.jms.protocol.event.ZmqEventHandler;
import org.zeromq.jms.protocol.filter.ZmqFilterPolicy;

@ZmqComponent(value="serialize")
@ZmqUriParameter(value="event")
public class ZmqSerializeEventHandler
implements ZmqEventHandler {
    private static final Logger LOGGER = Logger.getLogger(ZmqSerializeEventHandler.class.getCanonicalName());

    @Override
    public ZmqSendEvent createSendEvent(ZmqMessage message) {
        SerializeEvent event = new SerializeEvent(message);
        return event;
    }

    @Override
    public ZmqAckEvent createAckEvent(ZmqEvent event) {
        throw new UnsupportedOperationException("This is not a supported operation.");
    }

    @Override
    public ZmqHeartbeatEvent createHeartbeatEvent() {
        throw new UnsupportedOperationException("This is not a supported operation.");
    }

    @Override
    public ZMsg createMsg(ZmqSocketType socketType, ZmqFilterPolicy filter, ZmqEvent event) throws ZmqException {
        if (event instanceof ZmqSendEvent) {
            ZmqSendEvent sendEvent = (ZmqSendEvent)event;
            ZmqMessage message = sendEvent.getMessage();
            String messageFilter = filter == null ? null : filter.resolve(message);
            byte[] key = messageFilter == null ? null : messageFilter.getBytes();
            ZMsg msg = new ZMsg();
            if (key != null) {
                msg.add(key);
            }
            ByteArrayOutputStream byteArrayOutput = new ByteArrayOutputStream();
            try {
                ObjectOutputStream objectOutput = new ObjectOutputStream(byteArrayOutput);
                objectOutput.writeObject(message);
                objectOutput.flush();
            }
            catch (IOException ex) {
                throw new ZmqException("Unable to convert message to and array of bytes: " + message, ex);
            }
            byte[] data = byteArrayOutput.toByteArray();
            msg.add(data);
            return msg;
        }
        throw new UnsupportedOperationException("This is not a supported operation.");
    }

    @Override
    public ZmqEvent createEvent(ZmqSocketType socketType, ZMsg msg) throws ZmqException {
        switch (socketType) {
            case SUB: 
            case ROUTER: 
            case REP: 
            case DEALER: {
                msg.unwrap();
                break;
            }
        }
        Iterator msgFrameEnum = msg.iterator();
        if (msgFrameEnum.hasNext()) {
            ZFrame msgFrame = (ZFrame)msgFrameEnum.next();
            byte[] msgFrameData = msgFrame.getData();
            ByteArrayInputStream byteArrayInput = new ByteArrayInputStream(msgFrameData);
            try {
                ObjectInputStream objectInput = new ObjectInputStream(byteArrayInput);
                ZmqMessage message = (ZmqMessage)objectInput.readObject();
                SerializeEvent sendEvent = new SerializeEvent(message);
                return sendEvent;
            }
            catch (IOException | ClassNotFoundException ex) {
                LOGGER.log(Level.SEVERE, "Unable to create event from ZMQ message?", ex);
                throw new ZmqException("Unable to create event from ZMQ message?", ex);
            }
        }
        throw new ZmqException("Unable to creae event fomr the ZMQ message");
    }

    private class SerializeEvent
    implements ZmqSendEvent {
        private final Object messageId = null;
        private final ZmqMessage message;

        SerializeEvent(ZmqMessage message) {
            this.message = message;
        }

        @Override
        public Object getMessageId() {
            return this.messageId;
        }

        @Override
        public ZmqMessage getMessage() {
            return this.message;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.messageId == null ? 0 : this.messageId.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SerializeEvent other = (SerializeEvent)obj;
            return !(this.messageId == null ? other.messageId != null : !this.messageId.equals(other.messageId));
        }

        public String toString() {
            return "SerialozeEvent [messageId=" + this.messageId + ", message=" + this.message + "]";
        }
    }
}

