/*
 * Decompiled with CFR 0.152.
 */
package org.zeromq.jms.protocol.event;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.text.Format;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.JMSException;
import org.zeromq.ZFrame;
import org.zeromq.ZMsg;
import org.zeromq.jms.ZmqException;
import org.zeromq.jms.ZmqMessage;
import org.zeromq.jms.ZmqTextMessage;
import org.zeromq.jms.annotation.ZmqComponent;
import org.zeromq.jms.annotation.ZmqUriParameter;
import org.zeromq.jms.protocol.ZmqAckEvent;
import org.zeromq.jms.protocol.ZmqEvent;
import org.zeromq.jms.protocol.ZmqHeartbeatEvent;
import org.zeromq.jms.protocol.ZmqSendEvent;
import org.zeromq.jms.protocol.ZmqSocketType;
import org.zeromq.jms.protocol.event.ZmqEventHandler;
import org.zeromq.jms.protocol.filter.ZmqFilterPolicy;
import org.zeromq.jms.stomp.StompException;
import org.zeromq.jms.stomp.StompMessage;

@ZmqComponent(value="stomp")
@ZmqUriParameter(value="event")
public class ZmqStompEventHandler
implements ZmqEventHandler {
    private static final Logger LOGGER = Logger.getLogger(ZmqStompEventHandler.class.getCanonicalName());
    private String charset = "UTF-8";
    private Map<String, Format> headerFormats = null;

    public void setHeaderFormats(Map<String, Format> headerFormats) {
        this.headerFormats = headerFormats;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StompMessage convert(String messageId, ZmqMessage message) throws ZmqException {
        if (message == null) {
            throw new ZmqException("Cannot convert NULL bodied JMS message to STOMP: " + message);
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        try {
            String body = ((ZmqTextMessage)message).getText();
            Enumeration<String> nameEnum = message.getPropertyNames();
            while (nameEnum.hasMoreElements()) {
                String name = nameEnum.nextElement();
                Object value = message.getObjectProperty(name);
                if (value == null) continue;
                if (value instanceof String) {
                    headers.put(name, value.toString());
                    continue;
                }
                if (this.headerFormats == null) continue;
                Map<String, Format> map = this.headerFormats;
                synchronized (map) {
                    Format format = this.headerFormats.get(name);
                    if (format != null) {
                        String valueAsStr = format.format(value);
                        headers.put(name, valueAsStr);
                    }
                }
            }
            if (!headers.containsKey(StompMessage.HeaderKey.HEADER_ID.getValue())) {
                headers.put(StompMessage.HeaderKey.HEADER_ID.getValue(), messageId);
            }
            StompMessage stompMessage = new StompMessage(StompMessage.FrameType.SEND, headers, body);
            return stompMessage;
        }
        catch (JMSException ex) {
            throw new ZmqException("Cannot convert JMS message to STOMP: " + message, (Exception)((Object)ex));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ZmqMessage convert(StompMessage messsage) throws ZmqException {
        ZmqTextMessage zmqMessage = new ZmqTextMessage();
        String text = messsage.getBody();
        Map<String, String> headers = messsage.getHeaders();
        try {
            zmqMessage.setText(text);
            for (String name : headers.keySet()) {
                String value = headers.get(name);
                if (value != null && this.headerFormats != null) {
                    Map<String, Format> map = this.headerFormats;
                    synchronized (map) {
                        String valueAsStr;
                        Format format = this.headerFormats.get(name);
                        Map<String, Format> map2 = this.headerFormats;
                        synchronized (map2) {
                            valueAsStr = format.format(value);
                        }
                        zmqMessage.setObjectProperty(name, valueAsStr);
                        continue;
                    }
                }
                zmqMessage.setObjectProperty(name, value);
            }
            return zmqMessage;
        }
        catch (JMSException ex) {
            throw new ZmqException("Cannot convert STOMP message to JMS: " + messsage, (Exception)((Object)ex));
        }
    }

    @Override
    public ZmqSendEvent createSendEvent(ZmqMessage message) throws ZmqException {
        String messageId = UUID.randomUUID().toString();
        StompSendEvent event = new StompSendEvent(null, messageId, message);
        return event;
    }

    @Override
    public ZmqAckEvent createAckEvent(ZmqEvent event) throws ZmqException {
        if (event instanceof AnstractStompEvent) {
            AnstractStompEvent sendEvent = (AnstractStompEvent)event;
            ZFrame address = sendEvent.getAddress();
            Object messageId = sendEvent.getMessageId();
            StompAckEvent ackEvent = new StompAckEvent(address, messageId);
            return ackEvent;
        }
        throw new UnsupportedOperationException("This is not a supported operation.");
    }

    @Override
    public ZmqHeartbeatEvent createHeartbeatEvent() {
        String messageId = UUID.randomUUID().toString();
        StompHeartbeatEvent event = new StompHeartbeatEvent(null, messageId);
        return event;
    }

    @Override
    public ZMsg createMsg(ZmqSocketType socketType, ZmqFilterPolicy filter, ZmqEvent event) throws ZmqException {
        ZMsg msg = new ZMsg();
        String messageId = event.getMessageId().toString();
        StompMessage stompMessage = null;
        if (event instanceof ZmqAckEvent) {
            StompAckEvent ackEvent = (StompAckEvent)event;
            ZFrame address = ackEvent.getAddress();
            if (address != null) {
                msg.add(address);
            }
            stompMessage = StompMessage.defineAckMessage(messageId);
        } else if (event instanceof ZmqSendEvent) {
            byte[] key;
            StompSendEvent sendEvent = (StompSendEvent)event;
            ZmqMessage message = sendEvent.getMessage();
            String messageFilter = filter == null ? null : filter.resolve(message);
            byte[] byArray = key = messageFilter == null ? null : messageFilter.getBytes();
            if (key != null) {
                msg.add(key);
            }
            stompMessage = this.convert(messageId, message);
        } else if (event instanceof ZmqHeartbeatEvent) {
            stompMessage = StompMessage.defineSendMessage(messageId, "", "");
        } else {
            throw new UnsupportedOperationException("This is not a supported operation.");
        }
        String rawMessage = StompMessage.encode(stompMessage);
        try {
            byte[] data = rawMessage.getBytes(this.charset);
            msg.add(data);
        }
        catch (IOException ex) {
            throw new ZmqException("Unable to convert message to and array of bytes: " + stompMessage, ex);
        }
        return msg;
    }

    @Override
    public ZmqEvent createEvent(ZmqSocketType socketType, ZMsg msg) throws ZmqException {
        ZFrame address = null;
        switch (socketType) {
            case SUB: {
                msg.unwrap();
                break;
            }
            case ROUTER: 
            case REP: {
                address = msg.unwrap();
                break;
            }
            case DEALER: {
                break;
            }
        }
        AnstractStompEvent event = null;
        for (ZFrame msgFrame : msg) {
            byte[] msgFrameData = msgFrame.getData();
            try {
                String rawMessage = new String(msgFrameData, this.charset);
                StompMessage stompMessage = StompMessage.decode(rawMessage);
                String messageId = stompMessage.getHeaderValue(StompMessage.HeaderKey.HEADER_ID.getValue());
                StompMessage.FrameType frameType = stompMessage.getFrame();
                switch (frameType) {
                    case SEND: {
                        String messageBody = stompMessage.getBody();
                        if (messageBody == null || messageBody.length() == 0) {
                            event = new StompHeartbeatEvent(address, messageId);
                            break;
                        }
                        ZmqMessage message = this.convert(stompMessage);
                        event = new StompSendEvent(address, messageId, message);
                        break;
                    }
                    case ACK: {
                        event = new StompAckEvent(address, messageId);
                        break;
                    }
                    default: {
                        LOGGER.log(Level.WARNING, "Received unknown message: " + (Object)((Object)frameType));
                        break;
                    }
                }
            }
            catch (UnsupportedEncodingException | ZmqException | StompException ex) {
                throw new ZmqException("Unable to pass ZMQ message", (Exception)ex);
            }
        }
        return event;
    }

    private class StompAckEvent
    extends AnstractStompEvent
    implements ZmqAckEvent {
        StompAckEvent(ZFrame address, Object messageId) {
            super(address, messageId);
        }

        public String toString() {
            return "StompAckEvent [address=" + ((AnstractStompEvent)this).address + ", messageId=" + ((AnstractStompEvent)this).messageId + "]";
        }
    }

    private class StompHeartbeatEvent
    extends AnstractStompEvent
    implements ZmqHeartbeatEvent {
        StompHeartbeatEvent(ZFrame address, Object messageId) {
            super(address, messageId);
        }

        public String toString() {
            return "StompHeartbeatEvent [address=" + ((AnstractStompEvent)this).address + ", messageId=" + ((AnstractStompEvent)this).messageId + "]";
        }
    }

    private class StompSendEvent
    extends AnstractStompEvent
    implements ZmqSendEvent {
        private final ZmqMessage message;

        StompSendEvent(ZFrame address, Object messageId, ZmqMessage message) {
            super(address, messageId);
            this.message = message;
        }

        @Override
        public ZmqMessage getMessage() {
            return this.message;
        }

        public String toString() {
            return "StompSendEvent [address=" + ((AnstractStompEvent)this).address + ", messageId=" + ((AnstractStompEvent)this).messageId + ", message=" + this.message + "]";
        }
    }

    private abstract class AnstractStompEvent
    implements ZmqEvent {
        private final ZFrame address;
        private final Object messageId;

        AnstractStompEvent(ZFrame address, Object messageId) {
            this.address = address;
            this.messageId = messageId;
        }

        protected ZFrame getAddress() {
            return this.address;
        }

        @Override
        public Object getMessageId() {
            return this.messageId;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.messageId == null ? 0 : this.messageId.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AnstractStompEvent other = (AnstractStompEvent)obj;
            return !(this.messageId == null ? other.messageId != null : !this.messageId.equals(other.messageId));
        }
    }
}

