/*
 * Decompiled with CFR 0.152.
 */
package org.zeromq.jms.selector;

import java.text.DecimalFormat;
import java.text.Format;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.zeromq.jms.selector.ZmqMessageSelector;

public class ZmqSimpleMessageSelector
implements ZmqMessageSelector {
    private static final String TOKENISE_REGX = "=|!=|<=|>=|\\|\\||\\&\\&|\\d+\\.\\d+|\\d+|'(.*?)'|IS NULL|IS NOT NULL|,|\\w+|[()+\\-*/<>]";
    private final ExpressionTerm expressionTerm;

    public ZmqSimpleMessageSelector(ExpressionTerm expressionTerm) {
        this.expressionTerm = expressionTerm;
    }

    public static ZmqMessageSelector parse(String expression) throws ParseException {
        Pattern pattern = Pattern.compile(TOKENISE_REGX, 2);
        Matcher matcher = pattern.matcher(expression);
        LinkedList<Token> tokens = new LinkedList<Token>();
        tokens.add(new Token("(", -1));
        int start = 0;
        while (matcher.find(start)) {
            String token = matcher.group();
            tokens.add(new Token(token, matcher.end() - token.length()));
            start = matcher.end();
        }
        tokens.add(new Token(")", -1));
        LinkedList<Token> postfixExpr = new LinkedList<Token>();
        LinkedList<Token> precedenceStack = new LinkedList<Token>();
        int index = 0;
        while (!tokens.isEmpty() && index < tokens.size()) {
            Token token = (Token)tokens.pop();
            if (token.hasValue("(")) {
                precedenceStack.push(token);
                continue;
            }
            Operator operator = Operator.getOperator(token.value);
            if (operator != null) {
                while (operator.precedence(((Token)precedenceStack.peek()).value)) {
                    postfixExpr.add((Token)precedenceStack.pop());
                }
                precedenceStack.push(token);
                continue;
            }
            if (token.hasValue(")")) {
                while (!((Token)precedenceStack.peek()).hasValue("(")) {
                    Token stackElement = (Token)precedenceStack.pop();
                    if (Operator.getOperator(stackElement.value) == null) continue;
                    postfixExpr.add(stackElement);
                }
                precedenceStack.pop();
                continue;
            }
            postfixExpr.add(token);
        }
        if (!precedenceStack.isEmpty()) {
            throw new IllegalArgumentException("Could not parse expression!");
        }
        ExpressionTerm expressionTerm = ZmqSimpleMessageSelector.parsePostFixExpr(postfixExpr);
        ZmqSimpleMessageSelector selector = new ZmqSimpleMessageSelector(expressionTerm);
        return selector;
    }

    private static ExpressionTerm parsePostFixExpr(List<Token> postfixExpr) throws ParseException {
        LinkedList<ExpressionTerm> termStack = new LinkedList<ExpressionTerm>();
        for (Token token : postfixExpr) {
            ExpressionTerm listTerms;
            ExpressionTerm term;
            ExpressionTerm leftTerm;
            ExpressionTerm term2;
            ExpressionTerm term3;
            Operator operator = Operator.getOperator(token.value);
            if (operator == null) {
                term3 = ZmqSimpleMessageSelector.buildTerm(token);
                termStack.push(term3);
                continue;
            }
            if (operator == Operator.LIST) {
                ExpressionTerm term1 = (ExpressionTerm)termStack.pop();
                ExpressionTerm term22 = (ExpressionTerm)termStack.pop();
                ListTerm listTerm = term1 instanceof ListTerm ? (ListTerm)term1 : new ListTerm(term1);
                listTerm.terms.add(term22);
                termStack.push(listTerm);
                continue;
            }
            if (operator == Operator.BETWEEN) {
                ExpressionTerm andTerm = (ExpressionTerm)termStack.pop();
                if (!(andTerm instanceof CompoundTerm) || ((CompoundTerm)andTerm).operator != Operator.AND) {
                    throw new ParseException("Missing 'and' for BETWEEN clause.", token.pos);
                }
                term2 = (ExpressionTerm)termStack.pop();
                ExpressionTerm fromTerm = ((CompoundTerm)andTerm).leftTerm;
                ExpressionTerm toTerm = ((CompoundTerm)andTerm).rightTerm;
                FunctionTerm betweenTerm = new FunctionTerm(operator, term2, fromTerm, toTerm);
                termStack.push(betweenTerm);
                continue;
            }
            if (operator == Operator.LIKE) {
                ExpressionTerm patternTerm = (ExpressionTerm)termStack.pop();
                leftTerm = (ExpressionTerm)termStack.pop();
                term = new FunctionTerm(operator, leftTerm, patternTerm);
                termStack.push(term);
                continue;
            }
            if (operator == Operator.IS_NULL || operator == Operator.IS_NOT_NULL) {
                ExpressionTerm leftTerm2 = (ExpressionTerm)termStack.pop();
                term2 = new FunctionTerm(operator, leftTerm2);
                termStack.push(term2);
                continue;
            }
            if (operator == Operator.IN) {
                listTerms = (ExpressionTerm)termStack.pop();
                ExpressionTerm inTerm = (ExpressionTerm)termStack.pop();
                term = new FunctionTerm(operator, inTerm, listTerms);
                termStack.push(term);
                continue;
            }
            if (operator == Operator.ROUND || operator == Operator.LEN || operator == Operator.FORMAT || operator == Operator.LCASE || operator == Operator.UCASE || operator == Operator.MID) {
                listTerms = (ExpressionTerm)termStack.pop();
                term2 = new FunctionTerm(operator, listTerms);
                termStack.push(term2);
                continue;
            }
            if (operator == Operator.NOW) {
                term3 = new FunctionTerm(operator, new ExpressionTerm[0]);
                termStack.push(term3);
                continue;
            }
            ExpressionTerm rightTerm = (ExpressionTerm)termStack.pop();
            leftTerm = (ExpressionTerm)termStack.pop();
            term = new CompoundTerm(operator, leftTerm, rightTerm);
            termStack.push(term);
        }
        return (ExpressionTerm)termStack.pop();
    }

    private static ExpressionTerm buildTerm(Token token) {
        if (Pattern.matches("[-+]?\\d*\\.?\\d*", token.value)) {
            return new LiteralTerm(Double.parseDouble(token.value));
        }
        if (Pattern.matches("true|false", token.value)) {
            return new LiteralTerm(Boolean.parseBoolean(token.value));
        }
        if (token.value.startsWith("'")) {
            int endOfLiteral = token.value.endsWith("'") ? token.value.length() - 1 : token.value.length();
            return new LiteralTerm(token.value.substring(1, endOfLiteral));
        }
        return new VariableTerm(token.value);
    }

    @Override
    public boolean evaluate(Map<String, Object> variables) {
        Object result = this.evaluate(variables, this.expressionTerm);
        if (result instanceof Boolean) {
            return (Boolean)result;
        }
        throw new ArithmeticException("Expression does not evaulate to a boolean.");
    }

    private Object evaluate(Object leftValue, Operator operator, Object rightValue) {
        switch (operator) {
            case EQUAL: 
            case GREATER: 
            case GREATER_EQUAL: 
            case LESS: 
            case LESS_EQUAL: 
            case NOT_EQUAL: {
                Comparable value = (Comparable)leftValue;
                int result = value.compareTo(rightValue);
                switch (operator) {
                    case EQUAL: {
                        return result == 0;
                    }
                    case GREATER: {
                        return result > 0;
                    }
                    case GREATER_EQUAL: {
                        return result >= 0;
                    }
                    case LESS: {
                        return result < 0;
                    }
                    case LESS_EQUAL: {
                        return result <= 0;
                    }
                    case NOT_EQUAL: {
                        return result != 0;
                    }
                }
                throw new ArithmeticException("Unsupported compound operator: " + (Object)((Object)operator));
            }
            case ADDITION: {
                if (leftValue instanceof String || rightValue instanceof String) {
                    return leftValue.toString() + rightValue.toString();
                }
                double addition1 = ((Number)leftValue).doubleValue();
                double addition2 = ((Number)rightValue).doubleValue();
                return addition1 + addition2;
            }
            case SUBSTRACT: 
            case MULTIPLY: 
            case DIVISION: 
            case POW: {
                double value1 = ((Number)leftValue).doubleValue();
                double value2 = ((Number)rightValue).doubleValue();
                switch (operator) {
                    case SUBSTRACT: {
                        return value1 - value2;
                    }
                    case MULTIPLY: {
                        return value1 * value2;
                    }
                    case DIVISION: {
                        return value1 / value2;
                    }
                    case POW: {
                        return Math.pow(value1, value2);
                    }
                }
                throw new ArithmeticException("Unsupported compound operator: " + (Object)((Object)operator));
            }
            case AND: {
                return (Boolean)leftValue != false && (Boolean)rightValue != false;
            }
            case OR: {
                return (Boolean)leftValue != false || (Boolean)rightValue != false;
            }
        }
        throw new ArithmeticException("Unsupported compound operator: " + (Object)((Object)operator));
    }

    private Object evaluate(Map<String, Object> variables, ExpressionTerm term) {
        if (term instanceof LiteralTerm) {
            return ((LiteralTerm)term).literal;
        }
        if (term instanceof VariableTerm) {
            String name = ((VariableTerm)term).name;
            Object value = variables.get(name);
            return value;
        }
        if (term instanceof ListTerm) {
            ListTerm listTerms = (ListTerm)term;
            Object[] results = new Object[listTerms.terms.size()];
            for (int i = 0; i < listTerms.terms.size(); ++i) {
                results[i] = this.evaluate(variables, (ExpressionTerm)listTerms.terms.get(i));
            }
            return results;
        }
        if (term instanceof FunctionTerm) {
            FunctionTerm function = (FunctionTerm)term;
            Object[] results = null;
            if (function.parameters != null) {
                results = new Object[function.parameters.length];
                for (int i = 0; i < function.parameters.length; ++i) {
                    results[i] = this.evaluate(variables, function.parameters[i]);
                }
            }
            switch (function.operator) {
                case BETWEEN: {
                    return (Boolean)this.evaluate(results[0], Operator.GREATER_EQUAL, results[1]) != false && (Boolean)this.evaluate(results[0], Operator.LESS, results[2]) != false;
                }
                case LIKE: {
                    String pattern = ((String)results[1]).replaceAll("_", ".").replaceAll("%", ".*");
                    return Pattern.matches(pattern, (String)results[0]);
                }
                case IS_NULL: {
                    return results[0] == null;
                }
                case IS_NOT_NULL: {
                    return results[0] != null;
                }
                case IN: {
                    if (results[1] instanceof Object[]) {
                        for (Object result : (Object[])results[1]) {
                            if (!((Boolean)this.evaluate(results[0], Operator.EQUAL, result)).booleanValue()) continue;
                            return true;
                        }
                        return false;
                    }
                    return (Boolean)this.evaluate(results[0], Operator.EQUAL, results[1]);
                }
                case NOW: {
                    return new Date();
                }
                case ROUND: {
                    double roundValue = ((Number)results[0]).doubleValue();
                    return new Double(Math.round(roundValue));
                }
                case LEN: {
                    String lenValue = (String)results[0];
                    return new Double(lenValue.length());
                }
                case FORMAT: {
                    Format format;
                    Object[] formatParams = (Object[])results[0];
                    String formatPattern = (String)formatParams[0];
                    Object formatValue = formatParams[1];
                    if (formatValue instanceof Date) {
                        format = new SimpleDateFormat(formatPattern);
                    } else if (formatValue instanceof Number) {
                        format = new DecimalFormat(formatPattern);
                    } else {
                        throw new ArithmeticException("Unsupported function: " + term);
                    }
                    return format.format(formatValue);
                }
                case LCASE: {
                    String lcaseValue = (String)results[0];
                    return lcaseValue.toLowerCase();
                }
                case UCASE: {
                    String ucaseValue = (String)results[0];
                    return ucaseValue.toUpperCase();
                }
                case MID: {
                    Object[] midParams = (Object[])results[0];
                    if (midParams.length < 3) {
                        String midValue = (String)midParams[1];
                        int midStart = (int)((Double)midParams[0]).longValue() - 1;
                        return midValue.substring(midStart);
                    }
                    String midValue = (String)midParams[2];
                    int midStart = (int)((Double)midParams[1]).longValue() - 1;
                    int midLen = (int)((Double)midParams[0]).longValue();
                    return midValue.substring(midStart, midStart + midLen);
                }
            }
            throw new ArithmeticException("Unsupported function operator: " + term);
        }
        if (term instanceof CompoundTerm) {
            CompoundTerm function = (CompoundTerm)term;
            Object leftResult = this.evaluate(variables, function.leftTerm);
            Object rightResult = this.evaluate(variables, function.rightTerm);
            try {
                return this.evaluate(leftResult, function.operator, rightResult);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        throw new ArithmeticException("Unable to evaulate ExpressionTerm: " + term);
    }

    public void dump() {
        System.out.println("Expression: " + this.expressionTerm);
    }

    public String toString() {
        return "ZmqSimpleMessageSelector [expressionTerm=" + this.expressionTerm + "]";
    }

    private static class CompoundTerm
    implements ExpressionTerm {
        private final Operator operator;
        private final ExpressionTerm leftTerm;
        private final ExpressionTerm rightTerm;

        CompoundTerm(Operator operator, ExpressionTerm leftTerm, ExpressionTerm rightTerm) {
            this.operator = operator;
            this.leftTerm = leftTerm;
            this.rightTerm = rightTerm;
        }

        public String toString() {
            return "CompoundTerm [operator=" + (Object)((Object)this.operator) + ", leftTerm=" + this.leftTerm + ", rightTerm=" + this.rightTerm + "]";
        }
    }

    private static class FunctionTerm
    implements ExpressionTerm {
        private final Operator operator;
        private final ExpressionTerm[] parameters;

        FunctionTerm(Operator operator, ExpressionTerm ... parameter) {
            this.operator = operator;
            this.parameters = parameter;
        }

        public String toString() {
            return "FunctionTerm [operator=" + (Object)((Object)this.operator) + ", parameters=" + Arrays.toString(this.parameters) + "]";
        }
    }

    private static class ListTerm
    implements ExpressionTerm {
        private final List<ExpressionTerm> terms = new ArrayList<ExpressionTerm>();

        ListTerm(ExpressionTerm term) {
            this.terms.add(term);
        }

        public String toString() {
            return "ListTerm [terms=" + this.terms + "]";
        }
    }

    private static class VariableTerm
    implements ExpressionTerm {
        private final String name;

        VariableTerm(String name) {
            this.name = name;
        }

        public String toString() {
            return "VariableTerm [name=" + this.name + "]";
        }
    }

    private static class LiteralTerm
    implements ExpressionTerm {
        private final Object literal;

        LiteralTerm(Object literal) {
            this.literal = literal;
        }

        public String toString() {
            return "LiteralTerm [literal=" + this.literal + "]";
        }
    }

    private static interface ExpressionTerm {
    }

    private static class Token {
        private final String value;
        private final int pos;

        Token(String value, int pos) {
            this.value = value;
            this.pos = pos;
        }

        private boolean hasValue(String value) {
            return this.value.equals(value);
        }

        public String toString() {
            return "Token [value=" + this.value + ", pos=" + this.pos + "]";
        }
    }

    static enum Operator {
        LIST(",", 1),
        OR("OR", 1),
        IS_NULL("IS NULL", 1),
        IS_NOT_NULL("IS NOT NULL", 1),
        BETWEEN("BETWEEN", 1),
        AND("AND", 2),
        ROUND("ROUND", 7),
        LEN("LEN", 7),
        NOW("NOW", 7),
        FORMAT("FORMAT", 7),
        LCASE("LCASE", 7),
        UCASE("UCASE", 7),
        MID("MID", 7),
        NOT("NOT", 3),
        EQUAL("=", 4),
        GREATER(">", 4),
        GREATER_EQUAL(">=", 4),
        LESS("<", 4),
        LESS_EQUAL("<=", 4),
        NOT_EQUAL("<>", 4),
        ADDITION("+", 5),
        SUBSTRACT("-", 5),
        MULTIPLY("*", 6),
        DIVISION("//", 6),
        POW("^", 7),
        IN("IN", 8),
        LIKE("LIKE", 8);

        private static Map<String, Operator> operators;
        private final String symbol;
        private final int priority;

        private Operator(String symbol, int priority) {
            this.symbol = symbol;
            this.priority = priority;
            this.mapOperator(symbol);
        }

        private synchronized void mapOperator(String symbol) {
            if (operators == null) {
                operators = new HashMap<String, Operator>();
            }
            operators.put(symbol.toUpperCase(), this);
        }

        public String getSymbol() {
            return this.symbol;
        }

        public int getPriority() {
            return this.priority;
        }

        boolean precedence(String symbol) {
            Operator other = Operator.getOperator(symbol.toUpperCase());
            if (other == null) {
                return false;
            }
            return this.priority < other.priority;
        }

        public static Operator getOperator(String symbol) {
            return operators.get(symbol.toUpperCase());
        }

        public String toString() {
            return this.symbol;
        }
    }
}

