/*
 * Decompiled with CFR 0.152.
 */
package org.zeromq.jms.jmx;

import java.io.Serializable;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import org.zeromq.jms.jmx.ZmqSocketStatisticsMBean;
import org.zeromq.jms.protocol.ZmqSocketMetrics;

public class ZmqSocketStatistics
implements ZmqSocketStatisticsMBean,
Serializable {
    private static final long serialVersionUID = -2774442255180410402L;
    private final String name;
    private final String addr;
    private final boolean isBound;
    private final String type;
    private final ZmqSocketMetrics socketMetrics;

    public ZmqSocketStatistics(String name, String addr, String type, boolean isBound, ZmqSocketMetrics socketMetrics) {
        this.name = name;
        this.addr = addr;
        this.type = type;
        this.isBound = isBound;
        this.socketMetrics = socketMetrics;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isActive() {
        return this.socketMetrics.isActive();
    }

    @Override
    public String getAddr() {
        return this.addr;
    }

    @Override
    public boolean isBound() {
        return this.isBound;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public long getSendCount() {
        return this.socketMetrics.getSendCount();
    }

    @Override
    public Date getLastSendTime() {
        if (this.socketMetrics.getLastSendTime() == 0L) {
            return null;
        }
        return new Date(this.socketMetrics.getLastSendTime());
    }

    @Override
    public long getReceiveCount() {
        return this.socketMetrics.getReceiveCount();
    }

    @Override
    public Date getLastReceiveTime() {
        if (this.socketMetrics.getLastReceiveTime() == 0L) {
            return null;
        }
        return new Date(this.socketMetrics.getLastReceiveTime());
    }

    protected Map<String, Double> calculateMetrics(int bucketInterval, long[] bucketCounts) {
        LinkedHashMap<String, Double> metrics = new LinkedHashMap<String, Double>();
        if (bucketCounts == null) {
            return metrics;
        }
        double countSum = 0.0;
        int intervalSum = 0;
        double countPerSecond = 0.0;
        int countPerSecondIndex = 0;
        for (int i = 0; i < bucketCounts.length; ++i) {
            double maxRate;
            double rate = (countSum += (double)bucketCounts[i]) / (double)(intervalSum += bucketInterval);
            double ratePerSecond = (countPerSecond += (double)bucketCounts[i]) * (1000.0 / (((double)(i - countPerSecondIndex) + 1.0) * (double)bucketInterval));
            if (i * bucketInterval > 10000) {
                countPerSecond -= (double)bucketCounts[countPerSecondIndex];
                ++countPerSecondIndex;
            }
            if (!metrics.containsKey("Rate (min)") && intervalSum >= 60000) {
                metrics.put("Rate (min)", rate);
            } else if (!metrics.containsKey("Rate (s)") && intervalSum > 10000) {
                metrics.put("Rate (s)", ratePerSecond);
                metrics.put("Max Rate (s)", ratePerSecond);
            } else if (metrics.containsKey("Max Rate (s)") && ratePerSecond > (maxRate = ((Double)metrics.get("Max Rate (s)")).doubleValue())) {
                metrics.put("Max Rate (s)", ratePerSecond);
            }
            if (!metrics.containsKey("Count (30s)") && intervalSum >= 30000) {
                metrics.put("Count (30s)", countSum);
                continue;
            }
            if (!metrics.containsKey("Count (60s)") && intervalSum >= 60000) {
                metrics.put("Count (60s)", countSum);
                continue;
            }
            if (!metrics.containsKey("Count (90s)") && intervalSum >= 90000) {
                metrics.put("Count (90s)", countSum);
                continue;
            }
            if (!metrics.containsKey("Count (2min") && intervalSum >= 120000) {
                metrics.put("Count (2min", countSum);
                continue;
            }
            if (!metrics.containsKey("Count (5min)") && intervalSum >= 300000) {
                metrics.put("Count (5min)", countSum);
                continue;
            }
            if (!metrics.containsKey("Count (10min)") && intervalSum >= 600000) {
                metrics.put("Count (10min)", countSum);
                continue;
            }
            if (!metrics.containsKey("Count (30min)") && intervalSum >= 1800000) {
                metrics.put("Count (30min)", countSum);
                continue;
            }
            if (!metrics.containsKey("Count (1h)") && intervalSum >= 3600000) {
                metrics.put("Count (1h)", countSum);
                continue;
            }
            if (!metrics.containsKey("Count (6h)") && intervalSum >= 21600000) {
                metrics.put("Count (6h)", countSum);
                continue;
            }
            if (!metrics.containsKey("Count (12h)") && intervalSum >= 43200000) {
                metrics.put("Count (12h)", countSum);
                continue;
            }
            if (metrics.containsKey("Count (24h)") || intervalSum < 86400000) continue;
            metrics.put("Count (24h)", countSum);
        }
        return metrics;
    }

    @Override
    public Map<String, Double> getSendMetrics() {
        int bucketInterval = this.socketMetrics.getBucketInternval();
        long[] bucketCounts = this.socketMetrics.getSendBucketCounts();
        return this.calculateMetrics(bucketInterval, bucketCounts);
    }

    @Override
    public Map<String, Double> getReceiveMetrics() {
        int bucketInterval = this.socketMetrics.getBucketInternval();
        long[] bucketCounts = this.socketMetrics.getReceiveBucketCounts();
        return this.calculateMetrics(bucketInterval, bucketCounts);
    }
}

