/*
 * Decompiled with CFR 0.152.
 */
package org.zeromq.jms.protocol.redelivery;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.logging.Logger;
import org.zeromq.jms.annotation.ZmqComponent;
import org.zeromq.jms.annotation.ZmqUriParameter;
import org.zeromq.jms.protocol.ZmqSendEvent;
import org.zeromq.jms.protocol.redelivery.ZmqRedeliveryPolicy;

@ZmqComponent(value="retry")
@ZmqUriParameter(value="redelivery")
public class ZmqRetryRedeliveryPolicy
implements ZmqRedeliveryPolicy {
    private static final Logger LOGGER = Logger.getLogger(ZmqRetryRedeliveryPolicy.class.getCanonicalName());
    private final Queue<ZmqSendEvent> redeliverQueue = new LinkedList<ZmqSendEvent>();
    private final Map<ZmqSendEvent, Integer> redeliveryMap = new HashMap<ZmqSendEvent, Integer>();
    private int retryCount;

    public ZmqRetryRedeliveryPolicy(int retryCount) {
        this.retryCount = retryCount;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    @ZmqUriParameter(value="redelivery.retry")
    public void setRetryCount(int retryCount) {
        this.retryCount = retryCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void redeliver(Collection<ZmqSendEvent> events) {
        ArrayList<ZmqSendEvent> failedRedeliveryMessages = new ArrayList<ZmqSendEvent>();
        Map<ZmqSendEvent, Integer> map = this.redeliveryMap;
        synchronized (map) {
            for (ZmqSendEvent event : events) {
                if (this.redeliveryMap.containsKey(event)) {
                    int messageRetryCount = this.redeliveryMap.get(event) - 1;
                    if (messageRetryCount > 0) {
                        this.redeliveryMap.put(event, messageRetryCount);
                        this.redeliverQueue.add(event);
                        continue;
                    }
                    this.redeliveryMap.remove(event);
                    failedRedeliveryMessages.add(event);
                    continue;
                }
                this.redeliveryMap.put(event, this.retryCount);
                this.redeliverQueue.add(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delivered(Collection<ZmqSendEvent> events) {
        Map<ZmqSendEvent, Integer> map = this.redeliveryMap;
        synchronized (map) {
            for (ZmqSendEvent event : events) {
                this.redeliveryMap.remove(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ZmqSendEvent getNextRedeliver() {
        Map<ZmqSendEvent, Integer> map = this.redeliveryMap;
        synchronized (map) {
            if (this.redeliverQueue.isEmpty()) {
                return null;
            }
            return this.redeliverQueue.poll();
        }
    }

    @Override
    public void onBackout(ZmqSendEvent event) {
        LOGGER.warning("Event backed-out: " + event);
    }
}

