/*
 * Decompiled with CFR 0.152.
 */
package org.zeromq.jms.protocol.store;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.management.ManagementFactory;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TransferQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.zeromq.jms.ZmqException;
import org.zeromq.jms.ZmqMessage;
import org.zeromq.jms.annotation.ZmqComponent;
import org.zeromq.jms.annotation.ZmqUriParameter;
import org.zeromq.jms.protocol.store.ZmqJournalEntry;
import org.zeromq.jms.protocol.store.ZmqJournalStore;
import org.zeromq.jms.util.ByteBufferBackedInputStream;

@ZmqComponent(value="file")
@ZmqUriParameter(value="journal")
public class ZmqFileJounralStore
implements ZmqJournalStore {
    private static final Logger LOGGER = Logger.getLogger(ZmqFileJounralStore.class.getCanonicalName());
    public static final long JOUNRAL_SWEEP_PERIOD_MILLISECONDS = 3000L;
    public static final long JOUNRAL_PURGE_PERIOD_MILLISECONDS = 10000L;
    public static final long JOUNRAL_MESSAGE_REPUBLISH_MILLSECONDS = 6000L;
    private static final String JOURNAL_FILE_DATE_PATTERN = "yyyyMMddHH";
    private static final String JOURNAL_ENTRY_DATE_PATTERN = "yyMMddHHmmssS";
    private static final char EOLN = "\n".charAt(0);
    private static final byte[] OFFSET_SEGMENT = new byte[4];
    private static final byte[] OFFSET_MESSAGE = new byte[4];
    private static final int PEEK_SIZE = 8;
    private static final TimeZone GMT = TimeZone.getTimeZone("GMT");
    private static final String JOURNAL_FILE_PREFIX = "journal_";
    private static final String JOURNAL_FILE_SUFFIX = ".jnl";
    private static final String JOURNAL_ARCHIVE_DIR = "archive";
    private DateFormat entryDateFormat;
    private DateFormat fileDateFormat;
    private Path location;
    private String groupId;
    private String uniqueId;
    private ScheduledExecutorService sweepScheduler = null;
    private long republishAfterMsec = 6000L;
    private long archiveAfterMsec = 10000L;
    private long sweepPeriod = 3000L;
    private final Map<String, Path> pathCache = new HashMap<String, Path>();
    private final Map<Object, MessageLocation> messageLocationMap = new ConcurrentHashMap<Object, MessageLocation>();
    private final TransferQueue<ZmqJournalEntry> messageQueue = new LinkedTransferQueue<ZmqJournalEntry>();

    private static DateFormat getDateFormat(String pattern, TimeZone timeZone) {
        SimpleDateFormat format = new SimpleDateFormat(pattern);
        format.setTimeZone(timeZone);
        return format;
    }

    public ZmqFileJounralStore() {
        this.entryDateFormat = ZmqFileJounralStore.getDateFormat(JOURNAL_ENTRY_DATE_PATTERN, GMT);
        this.fileDateFormat = ZmqFileJounralStore.getDateFormat(JOURNAL_FILE_DATE_PATTERN, GMT);
    }

    public ZmqFileJounralStore(Path location, String groupId, String uniqueId) {
        this.location = location;
        this.groupId = groupId;
        this.uniqueId = uniqueId;
        this.entryDateFormat = ZmqFileJounralStore.getDateFormat(JOURNAL_ENTRY_DATE_PATTERN, GMT);
        this.fileDateFormat = ZmqFileJounralStore.getDateFormat(JOURNAL_FILE_DATE_PATTERN, GMT);
    }

    public ZmqFileJounralStore(Path location, String groupId, String uniqueId, String journalFileDatePattern, String timeZoneID) {
        this.location = location;
        this.groupId = groupId;
        this.uniqueId = uniqueId;
        TimeZone timeZone = TimeZone.getTimeZone(timeZoneID);
        this.entryDateFormat = ZmqFileJounralStore.getDateFormat(JOURNAL_ENTRY_DATE_PATTERN, timeZone);
        this.fileDateFormat = ZmqFileJounralStore.getDateFormat(journalFileDatePattern, timeZone);
    }

    @ZmqUriParameter(value="journal.location")
    public void setLocation(String location) {
        this.location = Paths.get(URI.create(location));
    }

    @ZmqUriParameter(value="journal.uniqueId")
    public void setUniqueId(String uniqueId) {
        this.uniqueId = uniqueId;
    }

    @ZmqUriParameter(value="journal.groupId")
    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    @ZmqUriParameter(value="journal.locationURI")
    public void setLocationURI(String location) {
        this.location = Paths.get(URI.create(location));
    }

    @ZmqUriParameter(value="journal.sweepPeriod")
    public void setSweepPeriod(long period) {
        this.sweepPeriod = period;
    }

    @ZmqUriParameter(value="journal.republishAfter")
    public void setPublishAfter(long time) {
        this.republishAfterMsec = time;
    }

    @ZmqUriParameter(value="journal.archiveAfter")
    public void setArchiveAfter(long time) {
        this.archiveAfterMsec = time;
    }

    @ZmqUriParameter(value="journal.entryDatePattern")
    public void setEntryDateFormat(String pattern) {
        this.entryDateFormat = ZmqFileJounralStore.getDateFormat(pattern, GMT);
    }

    @ZmqUriParameter(value="journal.fileDatePattern")
    public void setFileDateFormat(String pattern) {
        this.fileDateFormat = ZmqFileJounralStore.getDateFormat(pattern, GMT);
    }

    @ZmqUriParameter(value="journal.timeZoneID")
    public void setTimeZone(String timeZoneID) {
        TimeZone timeZone = TimeZone.getTimeZone(timeZoneID);
        this.entryDateFormat.setTimeZone(timeZone);
        this.fileDateFormat.setTimeZone(timeZone);
    }

    public String getCurrentJournalFileName(String uniqueId) {
        String journalDateLabel = this.fileDateFormat.format(new Date());
        String fileName = JOURNAL_FILE_PREFIX + uniqueId + "_" + journalDateLabel + JOURNAL_FILE_SUFFIX;
        return fileName;
    }

    public String getUniqueId(Path journalFile) {
        String filename = journalFile.getFileName().toString();
        String journalDateLabel = this.fileDateFormat.format(new Date());
        int startPos = JOURNAL_FILE_PREFIX.length();
        int endPos = ("_" + journalDateLabel + JOURNAL_FILE_SUFFIX).length();
        return filename.substring(startPos, endPos);
    }

    public Path getCurrentJournalFle(String uniqueId) {
        String fileName = this.getCurrentJournalFileName(uniqueId);
        if (!this.pathCache.containsKey(fileName)) {
            Path journalDir = this.location.resolve(this.groupId);
            Path file = journalDir.resolve(fileName);
            this.pathCache.put(fileName, file);
        }
        Path file = this.pathCache.get(fileName);
        return file;
    }

    protected String generateUniqueId() {
        String name = ManagementFactory.getRuntimeMXBean().getName();
        return name.replaceAll("\\W+", "-");
    }

    public Path getJournalDir() {
        Path journalDir = this.location.resolve(this.groupId);
        return journalDir;
    }

    public Path getAchiveJournalDir() {
        Path archiveDir = this.location.resolve(this.groupId).resolve(JOURNAL_ARCHIVE_DIR);
        return archiveDir;
    }

    @Override
    public void open() throws ZmqException {
        if (this.location == null) {
            String tempDir = System.getProperty("java.io.tmpdir");
            LOGGER.warning("No location path specified, defaulting to temp: " + tempDir);
            this.location = Paths.get(tempDir, new String[0]);
        }
        if (this.groupId == null) {
            throw new ZmqException("Missing groupId to open store, i.e. 'queue_1-incoming'");
        }
        if (this.uniqueId == null) {
            this.uniqueId = this.generateUniqueId();
            LOGGER.info("Defaulting to process identifier: " + this.uniqueId);
        }
        Path journalDir = this.getJournalDir();
        try {
            Files.createDirectories(journalDir, new FileAttribute[0]);
        }
        catch (IOException ex) {
            throw new ZmqException("Unable to open store (dir=" + journalDir + "): " + this, ex);
        }
        if (this.sweepPeriod > 0L) {
            this.sweepScheduler = Executors.newScheduledThreadPool(1);
            if (this.sweepScheduler != null) {
                Runnable sweepCommand = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ZmqFileJounralStore.this.sweepFiles(ZmqFileJounralStore.this.republishAfterMsec);
                            if (ZmqFileJounralStore.this.archiveAfterMsec >= 0L) {
                                ZmqFileJounralStore.this.purgeArchives(ZmqFileJounralStore.this.archiveAfterMsec);
                            }
                        }
                        catch (ZmqException ex) {
                            LOGGER.log(Level.SEVERE, "Sweep process failure: " + this, (Throwable)((Object)ex));
                        }
                    }
                };
                this.sweepScheduler.scheduleAtFixedRate(sweepCommand, this.sweepPeriod, this.sweepPeriod, TimeUnit.MILLISECONDS);
            }
        }
        LOGGER.info("Sucessfully openned: " + this);
    }

    @Override
    public void close() throws ZmqException {
        if (this.sweepScheduler != null) {
            try {
                this.sweepScheduler.shutdown();
                boolean success = this.sweepScheduler.awaitTermination(3L, TimeUnit.SECONDS);
                if (!success) {
                    LOGGER.severe("Sweep scheduler failed to stop: " + this);
                } else {
                    LOGGER.info("Sucessfully closed: " + this);
                }
            }
            catch (InterruptedException ex) {
                LOGGER.log(Level.SEVERE, "Sweep scheduler failed to stop: " + this, ex);
            }
        }
    }

    @Override
    public void reset() throws ZmqException {
        Path journalDir = this.getJournalDir();
        if (Files.exists(journalDir, new LinkOption[0])) {
            try {
                Files.walkFileTree(journalDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        Files.delete(file);
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                        Files.delete(dir);
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (IOException ex) {
                throw new ZmqException("Unable to reset store (dir=" + journalDir + "): " + this, ex);
            }
        }
    }

    @Override
    public void delete(Object messageId) throws ZmqException {
        MessageLocation location = this.messageLocationMap.get(messageId);
        if (location != null) {
            assert (messageId.equals(location.getMessageId()));
            try {
                Path journalFile = location.getJournalFile();
                long position = location.getPosition();
                SeekableByteChannel channel = Files.newByteChannel(journalFile, StandardOpenOption.READ, StandardOpenOption.WRITE);
                channel.position(position);
                ByteBuffer peekBuffer = ByteBuffer.allocateDirect(8);
                channel.read(peekBuffer);
                long entryPosition = channel.position();
                peekBuffer.rewind();
                int messageOffset = peekBuffer.getInt();
                ByteBuffer entryBuffer = ByteBuffer.allocateDirect(messageOffset - 8);
                channel.read(entryBuffer);
                entryBuffer.rewind();
                try (ObjectInputStream inEntry = new ObjectInputStream(new ByteBufferBackedInputStream(entryBuffer));){
                    String entryDate = (String)inEntry.readObject();
                    boolean deleteFlag = inEntry.readBoolean();
                    Object actualMessageId = inEntry.readObject();
                    assert (messageId.equals(actualMessageId));
                    if (!deleteFlag) {
                        ByteArrayOutputStream byteArrayOutput = new ByteArrayOutputStream();
                        ObjectOutputStream out = new ObjectOutputStream(byteArrayOutput);
                        out.writeObject(entryDate);
                        out.writeBoolean(true);
                        out.writeObject(messageId);
                        channel.position(entryPosition);
                        channel.write(ByteBuffer.wrap(byteArrayOutput.toByteArray()));
                        this.messageLocationMap.remove(messageId);
                        return;
                    }
                }
                catch (ClassNotFoundException ex) {
                    LOGGER.log(Level.SEVERE, "Unable to read message (pos=" + position + ", file=" + journalFile + "): " + this, ex);
                }
            }
            catch (IOException ex) {
                throw new ZmqException("Cannot delete message (messageId=" + messageId + ", file=" + location.getJournalFile() + "): " + this, ex);
            }
        }
        LOGGER.warning("Unknown event marked for deletion with reference (messageId=" + messageId + "): " + this);
    }

    @Override
    public void create(Object messageId, ZmqMessage message) throws ZmqException {
        ByteArrayOutputStream byteArrayOutput = new ByteArrayOutputStream();
        int messageOffset = 0;
        try {
            byteArrayOutput.write(OFFSET_SEGMENT);
            byteArrayOutput.write(OFFSET_MESSAGE);
            ObjectOutputStream out = new ObjectOutputStream(byteArrayOutput);
            String entryDate = this.entryDateFormat.format(new Date());
            out.writeObject(entryDate);
            out.writeBoolean(false);
            out.writeObject(messageId);
            out.flush();
            messageOffset = byteArrayOutput.size();
            ObjectOutputStream out2 = new ObjectOutputStream(byteArrayOutput);
            out2.writeObject(message);
            out2.flush();
        }
        catch (IOException ex) {
            throw new ZmqException("Cannot convert message to and array of bytes (message=" + message + "): " + this, ex);
        }
        byteArrayOutput.write(EOLN);
        int segmentOffset = byteArrayOutput.size();
        byte[] bytes = byteArrayOutput.toByteArray();
        assert (segmentOffset == bytes.length);
        System.arraycopy(ByteBuffer.allocate(4).putInt(segmentOffset).array(), 0, bytes, 0, 4);
        System.arraycopy(ByteBuffer.allocate(4).putInt(messageOffset).array(), 0, bytes, 4, 4);
        Path currentJournalFile = this.getCurrentJournalFle(this.uniqueId);
        try {
            Files.write(currentJournalFile, bytes, StandardOpenOption.CREATE, StandardOpenOption.APPEND);
            long size = Files.size(currentJournalFile);
            long position = size - (long)bytes.length;
            MessageLocation location = new MessageLocation(messageId, currentJournalFile, position);
            this.messageLocationMap.put(messageId, location);
        }
        catch (IOException ex) {
            throw new ZmqException("Cannot create message (" + messageId + ") : " + this, ex);
        }
    }

    public void purgeArchives(long archiveAfterMsec) throws ZmqException {
        Path archiveDir = this.getAchiveJournalDir();
        Date currentTime = new Date();
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(archiveDir, "*.jnl");){
            for (Path journalFile : directoryStream) {
                FileTime journalFileLastModified = Files.getLastModifiedTime(journalFile, LinkOption.NOFOLLOW_LINKS);
                if (journalFileLastModified.toMillis() >= currentTime.getTime() - this.republishAfterMsec) continue;
                Files.deleteIfExists(journalFile);
            }
        }
        catch (IOException ex) {
            throw new ZmqException("Unable to purge archieve file(s).", ex);
        }
    }

    public void sweepFiles(long republishAfterMsec) throws ZmqException {
        List defaultJournalFiles;
        TreeMap journalMap = new TreeMap();
        TreeMap<String, FileTime> journalLastModifiedMap = new TreeMap<String, FileTime>();
        FileTime currentTime = FileTime.fromMillis(System.currentTimeMillis());
        Path journalDir = this.getJournalDir();
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(journalDir, "*.jnl");){
            for (Path journalFile : directoryStream) {
                String jounalFileUniqueId = this.getUniqueId(journalFile);
                FileTime journalFileLastModified = Files.getLastModifiedTime(journalFile, LinkOption.NOFOLLOW_LINKS);
                if (!journalMap.containsKey(jounalFileUniqueId)) {
                    journalMap.put(jounalFileUniqueId, new LinkedList());
                    journalLastModifiedMap.put(jounalFileUniqueId, journalFileLastModified);
                }
                List journalFiles = (List)journalMap.get(jounalFileUniqueId);
                journalFiles.add(journalFile);
                FileTime prevLastModified = (FileTime)journalLastModifiedMap.get(jounalFileUniqueId);
                if (prevLastModified.compareTo(journalFileLastModified) < 0) {
                    journalLastModifiedMap.put(jounalFileUniqueId, journalFileLastModified);
                }
                if (!this.uniqueId.equals(jounalFileUniqueId)) continue;
                Files.setLastModifiedTime(journalFile, currentTime);
            }
        }
        catch (IOException ex) {
            throw new ZmqException("Unable to sweep for archieve file(s).", ex);
        }
        if (journalMap.size() == 0) {
            return;
        }
        String[] journalFileUniqueIds = new String[journalMap.size()];
        int index = 0;
        int uniqueIdIndex = -1;
        Iterator i$ = journalMap.keySet().iterator();
        while (i$.hasNext()) {
            String journalFileUniqueId;
            journalFileUniqueIds[index] = journalFileUniqueId = (String)i$.next();
            if (this.uniqueId.equals(journalFileUniqueId)) {
                uniqueIdIndex = index;
            }
            ++index;
        }
        assert (uniqueIdIndex >= 0);
        int candidateIndex = (uniqueIdIndex + 1) % journalFileUniqueIds.length;
        FileTime candidateLastModified = (FileTime)journalLastModifiedMap.get(journalFileUniqueIds[candidateIndex]);
        if (candidateLastModified.toMillis() < currentTime.toMillis() - republishAfterMsec) {
            List journalFiles = (List)journalMap.get(journalFileUniqueIds[candidateIndex]);
            this.sweepOldestJournalFile(journalFiles, republishAfterMsec);
        }
        if ((defaultJournalFiles = (List)journalMap.get(this.uniqueId)).size() > 1) {
            this.sweepOldestJournalFile(defaultJournalFiles, republishAfterMsec);
        }
    }

    public void sweepOldestJournalFile(List<Path> journalFiles, long republishAfterMsec) throws ZmqException {
        Collections.sort(journalFiles);
        Path candidateFile = journalFiles.get(0);
        this.sweepJournalFile(candidateFile, republishAfterMsec);
    }

    public void sweepJournalFile(Path journalFile, long republishAfterMsec) throws ZmqException {
        Path currentJounralFile;
        int count = this.republishLostMessages(journalFile, republishAfterMsec);
        if (count == 0 && !journalFile.equals(currentJounralFile = this.getCurrentJournalFle(this.uniqueId))) {
            Path archiveDir = this.getAchiveJournalDir();
            Path archiveFile = archiveDir.resolve(journalFile.getFileName());
            try {
                Files.createDirectories(archiveDir, new FileAttribute[0]);
                Files.move(journalFile, archiveFile, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
                this.pathCache.remove(journalFile.getFileName());
            }
            catch (IOException ex) {
                throw new ZmqException("Cannot archieve journal (file=" + journalFile + "): " + this, ex);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int republishLostMessages(Path journalFile, long republishAfterMsec) throws ZmqException {
        if (republishAfterMsec < 0L) {
            return 0;
        }
        try (SeekableByteChannel channel = Files.newByteChannel(journalFile, StandardOpenOption.READ);){
            ByteBuffer peekBuffer = ByteBuffer.allocateDirect(8);
            Date republishAfterDate = new Date(System.currentTimeMillis() + republishAfterMsec);
            long position = channel.position();
            int peekSize = channel.read(peekBuffer);
            int count = 0;
            LinkedList<ZmqJournalEntry> lostMessages = new LinkedList<ZmqJournalEntry>();
            while (peekSize > 0) {
                int segmentOffset;
                block45: {
                    peekBuffer.rewind();
                    segmentOffset = peekBuffer.getInt();
                    int messageOffset = peekBuffer.getInt();
                    ByteBuffer entryBuffer = ByteBuffer.allocateDirect(messageOffset - 8);
                    int entrySize = channel.read(entryBuffer);
                    entryBuffer.rewind();
                    try (ObjectInputStream inEntry = new ObjectInputStream(new ByteBufferBackedInputStream(entryBuffer));){
                        Date entryDate = this.entryDateFormat.parse((String)inEntry.readObject());
                        boolean deleteFlag = inEntry.readBoolean();
                        Object messageId = inEntry.readObject();
                        if (deleteFlag && this.messageLocationMap.containsKey(messageId)) {
                            this.messageLocationMap.remove(messageId);
                        }
                        if (deleteFlag || !republishAfterDate.after(entryDate)) break block45;
                        ++count;
                        ByteBuffer messageBuffer = ByteBuffer.allocateDirect(segmentOffset - messageOffset);
                        int messageSize = channel.read(messageBuffer);
                        assert (segmentOffset == entrySize + messageSize + 8);
                        messageBuffer.position(0);
                        ByteBufferBackedInputStream inputStream = new ByteBufferBackedInputStream(messageBuffer);
                        try (ObjectInputStream inMessage = new ObjectInputStream(inputStream);){
                            ZmqMessage message = (ZmqMessage)inMessage.readObject();
                            ZmqJournalEntry entry = new ZmqJournalEntry(messageId, entryDate, deleteFlag, message);
                            lostMessages.add(entry);
                            MessageLocation location = new MessageLocation(messageId, journalFile, position);
                            this.messageLocationMap.put(messageId, location);
                        }
                    }
                    catch (ClassNotFoundException ex) {
                        LOGGER.log(Level.SEVERE, "Unable to read message (pos=" + position + ", file=" + journalFile + "): " + this, ex);
                    }
                    catch (ParseException ex) {
                        LOGGER.log(Level.SEVERE, "Unable to parse date (pos=" + position + ", file=" + journalFile + "): " + this, ex);
                    }
                }
                channel.position(position += (long)segmentOffset);
                peekBuffer.rewind();
                peekSize = channel.read(peekBuffer);
            }
            this.messageQueue.addAll(lostMessages);
            int n = count;
            return n;
        }
        catch (IOException ex) {
            throw new ZmqException("Store (" + this + ") unable to publish lost messages: " + journalFile, ex);
        }
    }

    @Override
    public ZmqJournalEntry read() throws ZmqException {
        return (ZmqJournalEntry)this.messageQueue.poll();
    }

    public String toString() {
        return "ZmqFileMessageStore [location=" + this.location + ", groupId=" + this.groupId + ", uniqueId=" + this.uniqueId + "]";
    }

    private class MessageLocation {
        private final Object messageId;
        private final Path journalFile;
        private final long position;

        private MessageLocation(Object messageId, Path journalFile, long position) {
            this.messageId = messageId;
            this.journalFile = journalFile;
            this.position = position;
        }

        public Object getMessageId() {
            return this.messageId;
        }

        public Path getJournalFile() {
            return this.journalFile;
        }

        public long getPosition() {
            return this.position;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.messageId == null ? 0 : this.messageId.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MessageLocation other = (MessageLocation)obj;
            return !(this.messageId == null ? other.messageId != null : !this.messageId.equals(other.messageId));
        }

        public String toString() {
            return "MessageLocation [messageId=" + this.messageId + ", journalFile=" + this.journalFile + ", position=" + this.position + "]";
        }
    }
}

