/*
 * Decompiled with CFR 0.152.
 */
package org.zeromq.jms.stomp;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.zeromq.jms.stomp.StompException;

public class StompMessage
implements Externalizable {
    public static final String LINE_SPERATOR = System.getProperties().getProperty("line.separator");
    public static final String NULL_OCTET = new String(new byte[]{0});
    private FrameType frame;
    private Map<String, String> headers;
    private String body;

    public StompMessage() {
    }

    public StompMessage(FrameType frame, Map<String, String> headers, String body) {
        this.frame = frame;
        this.headers = headers;
        this.body = body;
    }

    public FrameType getFrame() {
        return this.frame;
    }

    public String getDestination() {
        return this.headers.get(HeaderKey.HEADER_DESTINATION.getValue());
    }

    public String getContentType() {
        return this.headers.get(HeaderKey.HEADER_CONTENT_TYPE.getValue());
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public String getHeaderValue(String key) {
        return this.headers.get(key);
    }

    public String getHeaderValue(HeaderKey key) {
        return this.headers.get(key.getValue());
    }

    public Integer getHeaderValueAsInteger(HeaderKey key) {
        String value = this.headers.get(key.getValue());
        if (value == null || value.length() == 0) {
            return null;
        }
        int valueAsInt = Integer.parseInt(value);
        return valueAsInt;
    }

    public String getHeaderValue(HeaderKey key, String defaultValue) {
        String value = this.headers.get(key.getValue());
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public String getBody() {
        return this.body;
    }

    public String encode() {
        return StompMessage.encode(this);
    }

    public static String encode(StompMessage message) {
        StringBuilder messageBuffer = new StringBuilder();
        messageBuffer.append((Object)message.getFrame()).append(LINE_SPERATOR);
        Map<String, String> headers = message.getHeaders();
        for (String key : headers.keySet()) {
            String value = headers.get(key);
            messageBuffer.append(key).append(":").append(value).append(LINE_SPERATOR);
        }
        if (message.getBody() != null) {
            messageBuffer.append(LINE_SPERATOR);
            messageBuffer.append(message.getBody());
        }
        messageBuffer.append(NULL_OCTET).append(LINE_SPERATOR);
        return messageBuffer.toString();
    }

    public static StompMessage decode(String message) throws StompException {
        int index = message.indexOf(10);
        if (index == -1) {
            throw new StompException("Malformed message: " + message);
        }
        int beginIndex = 0;
        int endIndex = index > 0 && message.charAt(index - 1) == '\r' ? index - 1 : index;
        String messageFrame = message.substring(beginIndex, endIndex);
        FrameType frame = FrameType.valueOf(messageFrame);
        beginIndex = index + 1;
        LinkedHashMap<String, String> headers = new LinkedHashMap<String, String>();
        boolean hasBody = false;
        while (index >= 0) {
            index = message.indexOf(10, beginIndex);
            if (index == -1) {
                throw new StompException("Malformed message.");
            }
            endIndex = index > 0 && message.charAt(index - 1) == '\r' ? index - 1 : index;
            String header = message.substring(beginIndex, endIndex);
            if (header.length() == 0) {
                hasBody = true;
                beginIndex = index + 1;
                break;
            }
            if (header.startsWith(NULL_OCTET)) break;
            int seperatorIndex = header.indexOf(":");
            String headerKey = header.substring(0, seperatorIndex);
            String headerValue = header.substring(seperatorIndex + 1);
            headers.put(headerKey, headerValue);
            beginIndex = index + 1;
            if (beginIndex > message.length()) {
                throw new StompException("Malformed message: missing NULL octlet.");
            }
            if (message.charAt(beginIndex) != NULL_OCTET.charAt(0)) continue;
            break;
        }
        String body = null;
        if (hasBody) {
            endIndex = message.indexOf(NULL_OCTET, beginIndex);
            body = message.substring(beginIndex, endIndex);
        }
        return new StompMessage(frame, headers, body);
    }

    public static StompMessage defineConnectMessage(String acceptedVersion, String host) {
        LinkedHashMap<String, String> headers = new LinkedHashMap<String, String>();
        headers.put(HeaderKey.HEADER_ACCEPT_VERSION.getValue(), acceptedVersion);
        headers.put(HeaderKey.HEADER_HOST.getValue(), host);
        StompMessage stompMessage = new StompMessage(FrameType.CONNECT, headers, null);
        return stompMessage;
    }

    public static StompMessage defineConnectedMessage(String version) {
        LinkedHashMap<String, String> headers = new LinkedHashMap<String, String>();
        headers.put(HeaderKey.HEADER_VERSION.getValue(), version);
        StompMessage stompMessage = new StompMessage(FrameType.CONNECTED, headers, null);
        return stompMessage;
    }

    public static StompMessage defineDisconnectMessage(String receipt) {
        LinkedHashMap<String, String> headers = new LinkedHashMap<String, String>();
        headers.put(HeaderKey.HEADER_RECEIPT.getValue(), receipt);
        StompMessage stompMessage = new StompMessage(FrameType.DISCONNECT, headers, null);
        return stompMessage;
    }

    public static StompMessage defineAckMessage(String receiptId) {
        LinkedHashMap<String, String> headers = new LinkedHashMap<String, String>();
        headers.put(HeaderKey.HEADER_ID.getValue(), receiptId);
        StompMessage stompMessage = new StompMessage(FrameType.ACK, headers, null);
        return stompMessage;
    }

    public static StompMessage defineSubscribeMessage(String id, String destination, String ack) {
        LinkedHashMap<String, String> headers = new LinkedHashMap<String, String>();
        headers.put(HeaderKey.HEADER_ID.getValue(), id);
        headers.put(HeaderKey.HEADER_DESTINATION.getValue(), destination);
        if (ack != null) {
            headers.put(HeaderKey.HEADER_ACK.getValue(), ack);
        }
        StompMessage stompMessage = new StompMessage(FrameType.SUBSCRIBE, headers, null);
        return stompMessage;
    }

    public static StompMessage defineUnsubscribeMessage(String id) {
        LinkedHashMap<String, String> headers = new LinkedHashMap<String, String>();
        headers.put(HeaderKey.HEADER_ID.getValue(), id);
        StompMessage stompMessage = new StompMessage(FrameType.UNSUBSCRIBE, headers, null);
        return stompMessage;
    }

    public static StompMessage defineSendMessage(String id, String destination, String body) {
        LinkedHashMap<String, String> headers = new LinkedHashMap<String, String>();
        headers.put(HeaderKey.HEADER_DESTINATION.getValue(), destination);
        if (id != null) {
            headers.put(HeaderKey.HEADER_ID.getValue(), id);
        }
        StompMessage stompMessage = new StompMessage(FrameType.SEND, headers, body);
        return stompMessage;
    }

    public static StompMessage defineErrorMessage(String receiptId, String errorHeading, String errorDescription, String relatedRequest) {
        LinkedHashMap<String, String> headers = new LinkedHashMap<String, String>();
        headers.put(HeaderKey.HEADER_RECEIPT_ID.getValue(), receiptId);
        headers.put(HeaderKey.HEADER_MESSAGE.getValue(), errorHeading);
        String body = null;
        if (relatedRequest != null || errorDescription != null) {
            StringBuilder builder = new StringBuilder();
            if (relatedRequest != null) {
                builder.append("The message:").append(LINE_SPERATOR).append("-----").append(LINE_SPERATOR).append(relatedRequest).append(LINE_SPERATOR).append("-----").append(LINE_SPERATOR);
            }
            if (errorDescription != null) {
                builder.append(errorDescription).append(LINE_SPERATOR);
            }
            body = builder.toString();
        }
        StompMessage stompMessage = new StompMessage(FrameType.ERROR, headers, body);
        return stompMessage;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.body == null ? 0 : this.body.hashCode());
        result = 31 * result + (this.frame == null ? 0 : this.frame.hashCode());
        result = 31 * result + (this.headers == null ? 0 : this.headers.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StompMessage other = (StompMessage)obj;
        if (this.body == null ? other.body != null : !this.body.equals(other.body)) {
            return false;
        }
        if (this.frame != other.frame) {
            return false;
        }
        return !(this.headers == null ? other.headers != null : !this.headers.equals(other.headers));
    }

    public String toString() {
        String truncatedBody = this.body == null || this.body.length() < 80 ? this.body : this.body.substring(0, 80) + "...";
        return "StompMessage [frame=" + (Object)((Object)this.frame) + ", headers=" + this.headers + ", body=" + truncatedBody + "]";
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject((Object)this.frame);
        out.write(this.headers.size());
        for (String name : this.headers.keySet()) {
            String value = this.headers.get(name);
            out.writeObject(name);
            out.writeObject(value);
        }
        out.writeObject(this.body);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.frame = (FrameType)((Object)in.readObject());
        this.headers = new HashMap<String, String>();
        int count = in.readInt();
        for (int i = 0; i < count; ++i) {
            String name = (String)in.readObject();
            String value = (String)in.readObject();
            this.headers.put(name, value);
        }
        this.body = (String)in.readObject();
    }

    public static enum HeaderKey {
        HEADER_ACCEPT_VERSION("accept-version"),
        HEADER_VERSION("version"),
        HEADER_HOST("host"),
        HEADER_DESTINATION("destination"),
        HEADER_ACK("ack"),
        HEADER_HEADER_BEAT("heart-beat"),
        HEADER_SERVER("server"),
        HEADER_CONTENT_TYPE("content-type"),
        HEADER_CONTENT_LENGTH("content-length"),
        HEADER_ID("id"),
        HEADER_MESSAGE_ID("message-id"),
        HEADER_RECEIPT_ID("receipt-id"),
        HEADER_RECEIPT("receipt"),
        HEADER_MESSAGE("messsage");

        private String value;
        private static final Map<String, HeaderKey> VALUE_MAP;

        private HeaderKey(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static HeaderKey getEnum(String value) {
            if (!VALUE_MAP.containsKey(value)) {
                throw new IllegalArgumentException("Unknown value: " + value);
            }
            return VALUE_MAP.get(value);
        }

        static {
            HashMap<String, HeaderKey> valueMap = new HashMap<String, HeaderKey>();
            for (HeaderKey en : HeaderKey.values()) {
                valueMap.put(en.value, en);
            }
            VALUE_MAP = Collections.unmodifiableMap(valueMap);
        }
    }

    public static enum FrameType {
        SEND,
        SUBSCRIBE,
        UNSUBSCRIBE,
        BEGIN,
        COMMIT,
        ABORT,
        ACK,
        NACK,
        DISCONNECT,
        CONNECT,
        CONNECTED,
        MESSAGE,
        RECEIPT,
        ERROR;

    }
}

