/*
 * Decompiled with CFR 0.152.
 */
package org.zeromq.jms.jndi;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.naming.ConfigurationException;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;
import org.zeromq.jms.ZmqConnectionFactory;
import org.zeromq.jms.ZmqQueue;
import org.zeromq.jms.ZmqTopic;

public class ZmqObjectFactory
implements ObjectFactory {
    private static final Logger LOGGER = Logger.getLogger(ZmqObjectFactory.class.getCanonicalName());

    private String getPropertyValue(Properties properties, String name) {
        return properties.getProperty(name);
    }

    private String[] getPropertyValues(Properties properties, String nameRegex) {
        Pattern pattern = Pattern.compile(nameRegex, 2);
        Enumeration<?> propertyNameEnum = properties.propertyNames();
        ArrayList<String> valueList = new ArrayList<String>();
        while (propertyNameEnum.hasMoreElements()) {
            String value;
            String name = (String)propertyNameEnum.nextElement();
            if (pattern.matcher(name).matches() || (value = properties.getProperty(name)) == null) continue;
            valueList.add(value);
        }
        String[] values = new String[valueList.size()];
        valueList.toArray(values);
        return values;
    }

    @Override
    public Object getObjectInstance(Object object, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        if (object instanceof Reference) {
            String physicalName;
            Reference reference = (Reference)object;
            String className = reference.getClassName();
            LOGGER.info("Getting instance of " + className);
            Properties properties = new Properties();
            Enumeration<RefAddr> iter = reference.getAll();
            while (iter.hasMoreElements()) {
                StringRefAddr addr = (StringRefAddr)iter.nextElement();
                properties.put(addr.getType(), addr.getContent() == null ? "" : addr.getContent());
            }
            if (className.equals(ZmqConnectionFactory.class.getName())) {
                String gatewayFactory = properties.getProperty("gatewayFactory", null);
                String[] gatewayExtensions = this.getPropertyValues(properties, "^gatewayExtension//..*");
                String[] destinationValues = this.getPropertyValues(properties, "^destinationURL//..*");
                return new ZmqConnectionFactory(gatewayFactory, destinationValues, gatewayExtensions);
            }
            if (className.equals(ZmqQueue.class.getName())) {
                physicalName = this.getPropertyValue(properties, "physicalName");
                if (physicalName == null) {
                    throw new ConfigurationException("Missing attribute 'physicalName' to build class: " + className);
                }
                return new ZmqQueue(physicalName);
            }
            if (className.equals(ZmqTopic.class.getName())) {
                physicalName = this.getPropertyValue(properties, "physicalName");
                if (physicalName == null) {
                    throw new ConfigurationException("Missing attribute 'physicalName' to build class: " + className);
                }
                return new ZmqTopic(physicalName);
            }
            throw new ConfigurationException("Unable to instanciate class: " + className);
        }
        LOGGER.severe("Object " + object + " is not a reference - cannot load");
        throw new RuntimeException("Object " + object + " is not a reference");
    }
}

