/*
 * Decompiled with CFR 0.152.
 */
package org.zeromq.jms.protocol;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Constructor;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.Queue;
import org.zeromq.ZMQ;
import org.zeromq.jms.AbstractZmqDestination;
import org.zeromq.jms.ZmqException;
import org.zeromq.jms.ZmqSession;
import org.zeromq.jms.ZmqURI;
import org.zeromq.jms.annotation.ClassUtils;
import org.zeromq.jms.annotation.ZmqComponent;
import org.zeromq.jms.protocol.ZmqFireAndForgetGateway;
import org.zeromq.jms.protocol.ZmqGateway;
import org.zeromq.jms.protocol.ZmqGatewayListener;
import org.zeromq.jms.protocol.ZmqSocketType;
import org.zeromq.jms.protocol.event.ZmqEventHandler;
import org.zeromq.jms.protocol.event.ZmqStompEventHandler;
import org.zeromq.jms.protocol.filter.ZmqFilterPolicy;
import org.zeromq.jms.protocol.filter.ZmqFixedFilterPolicy;
import org.zeromq.jms.protocol.redelivery.ZmqRedeliveryPolicy;
import org.zeromq.jms.protocol.redelivery.ZmqRetryRedeliveryPolicy;
import org.zeromq.jms.protocol.store.ZmqJournalStore;
import org.zeromq.jms.selector.ZmqMessageSelector;
import org.zeromq.jms.selector.ZmqMessageSelectorFactory;

public class ZmqGatewayFactory {
    private static final Logger LOGGER = Logger.getLogger(ZmqSession.class.getCanonicalName());
    private final Class<?> defaultGateway = ZmqFireAndForgetGateway.class;
    private final ZmqMessageSelectorFactory defaultSelectorFactory = new ZmqMessageSelectorFactory();
    private final ZmqEventHandler defaultEventHandler = new ZmqStompEventHandler();
    private final ZmqFilterPolicy defaultFilterPolicy = new ZmqFixedFilterPolicy();
    private final ZmqRedeliveryPolicy defaultRedeliveryPolicy = new ZmqRetryRedeliveryPolicy(3);
    private final Map<String, ZmqURI> destinationSchema;
    private final List<Class<?>> gatewayClasses;
    private final List<Class<?>> eventHandlerClasses;
    private final List<Class<?>> filterPolicyClasses;
    private final List<Class<?>> redeliveryPolicyClasses;
    private final List<Class<?>> journalStoreClasses;

    public ZmqGatewayFactory(String[] extensionPackageNames, Map<String, ZmqURI> destinationSchema) {
        this.destinationSchema = destinationSchema;
        this.gatewayClasses = ZmqGatewayFactory.getClasses(extensionPackageNames, ZmqGateway.class);
        this.eventHandlerClasses = ZmqGatewayFactory.getClasses(extensionPackageNames, ZmqEventHandler.class);
        this.filterPolicyClasses = ZmqGatewayFactory.getClasses(extensionPackageNames, ZmqFilterPolicy.class);
        this.redeliveryPolicyClasses = ZmqGatewayFactory.getClasses(extensionPackageNames, ZmqRedeliveryPolicy.class);
        this.journalStoreClasses = ZmqGatewayFactory.getClasses(extensionPackageNames, ZmqJournalStore.class);
    }

    public static List<Class<?>> getClasses(String[] packageNames, Class<?> componentInterface) {
        LinkedList annotatedClasses = new LinkedList();
        try {
            List<Class<?>> mainClasses = ClassUtils.getClasses("org.zeromq.jms");
            for (Class<?> clazz : mainClasses) {
                if (!clazz.isAnnotationPresent(ZmqComponent.class) || !componentInterface.isAssignableFrom(clazz)) continue;
                annotatedClasses.add(clazz);
            }
            if (packageNames != null) {
                for (String packageName : packageNames) {
                    if (packageName.startsWith("org.zeromq.jms")) continue;
                    List<Class<?>> extensionClasses = ClassUtils.getClasses(packageName);
                    for (Class<?> clazz : extensionClasses) {
                        if (!clazz.isAnnotationPresent(ZmqComponent.class) || !componentInterface.isAssignableFrom(clazz)) continue;
                        annotatedClasses.add(clazz);
                    }
                }
            }
        }
        catch (IOException | ClassNotFoundException ex) {
            LOGGER.log(Level.SEVERE, "Unable to scan classes for ZMQ annotations.", ex);
        }
        return annotatedClasses;
    }

    public ZmqGateway newConsumerGateway(String namePrefix, AbstractZmqDestination destination, ZMQ.Context context, ZmqSocketType type, boolean isBound, String messageSelector, boolean transacted) throws ZmqException {
        String destinationName = destination.getName();
        ZmqURI destinationUri = destination.getURI();
        boolean flags = false;
        ZmqMessageSelector selector = this.getZmqMessageSelector(destination, messageSelector);
        Object redelivery = null;
        ZmqEventHandler eventHandler = this.getZmqEventHandler(destination);
        ZmqFilterPolicy filter = this.getZmqFilterPolicy(destination);
        ZmqJournalStore store = this.getZmqJournalStore(destination, ZmqGateway.Direction.INCOMING);
        try {
            ZmqURI uri;
            ZmqURI zmqURI = uri = destinationUri == null ? this.destinationSchema.get(destinationName) : destinationUri;
            if (uri == null) {
                throw new ZmqException("Missing URI to construct gateway consumer: " + destination);
            }
            String value = uri.getOptionValue("gateway", null);
            Class<?> gatewayClass = this.defaultGateway;
            if (value != null && (gatewayClass = ClassUtils.getClass(this.gatewayClasses, ZmqComponent.class, "value", value)) == null) {
                throw new ZmqException("Unable to find specified gateway: " + value);
            }
            if (gatewayClass != null) {
                LOGGER.info("Using gateway consumer  (" + gatewayClass.getClass().getCanonicalName() + ") for destination: " + destination);
            }
            Constructor<?> consumerConstructor = gatewayClass.getConstructor(String.class, ZMQ.Context.class, ZmqSocketType.class, Boolean.TYPE, String.class, Integer.TYPE, ZmqFilterPolicy.class, ZmqEventHandler.class, ZmqGatewayListener.class, ZmqJournalStore.class, ZmqMessageSelector.class, ZmqRedeliveryPolicy.class, Boolean.TYPE, ZmqGateway.Direction.class);
            boolean socketBound = uri.getOptionValue("gateway.bind", isBound);
            ZmqSocketType socketType = ZmqSocketType.valueOf(uri.getOptionValue("gateway.type", type.toString()));
            String socketAddr = uri.getOptionValue("gateway.addr");
            if (socketAddr == null) {
                throw new ZmqException("Missing UTI 'gateway.addr' construct gateway consumer: " + uri);
            }
            String name = namePrefix + "@" + socketAddr;
            ZmqGateway protocol = (ZmqGateway)consumerConstructor.newInstance(new Object[]{name, context, socketType, socketBound, socketAddr, 0, filter, eventHandler, null, store, selector, redelivery, transacted, ZmqGateway.Direction.INCOMING});
            if (uri != null) {
                Map<String, List<String>> parameters = uri.getOptions();
                ClassUtils.setMethods(parameters, protocol);
            }
            return protocol;
        }
        catch (IllegalArgumentException | ReflectiveOperationException ex) {
            LOGGER.log(Level.SEVERE, "Unable to construct consumer based on URI: " + destinationUri, ex);
            throw new ZmqException("Unable to construct consumer based on URI: " + destinationUri, ex);
        }
    }

    public ZmqGateway newProducerGateway(String namePrefix, AbstractZmqDestination destination, ZMQ.Context context, ZmqSocketType type, boolean isBound, boolean transacted) throws ZmqException {
        String destinationName = destination.getName();
        ZmqURI destinationUri = destination.getURI();
        boolean flags = false;
        Object selector = null;
        Object redelivery = null;
        ZmqEventHandler handler = this.getZmqEventHandler(destination);
        ZmqFilterPolicy filter = this.getZmqFilterPolicy(destination);
        Object listener = null;
        ZmqJournalStore store = this.getZmqJournalStore(destination, ZmqGateway.Direction.OUTGOING);
        try {
            ZmqURI uri;
            ZmqURI zmqURI = uri = destinationUri == null ? this.destinationSchema.get(destinationName) : destinationUri;
            if (uri == null) {
                throw new ZmqException("Missing URI to construct gateway consumer: " + destination);
            }
            String value = uri.getOptionValue("gateway");
            Class<?> gatewayClass = this.defaultGateway;
            if (value != null) {
                gatewayClass = ClassUtils.getClass(this.gatewayClasses, ZmqComponent.class, "value", value);
            }
            if (gatewayClass != null) {
                LOGGER.info("Using gateway produce  (" + gatewayClass.getClass().getCanonicalName() + ") for destination: " + destination);
            }
            Constructor<?> producerConstructor = gatewayClass.getConstructor(String.class, ZMQ.Context.class, ZmqSocketType.class, Boolean.TYPE, String.class, Integer.TYPE, ZmqFilterPolicy.class, ZmqEventHandler.class, ZmqGatewayListener.class, ZmqJournalStore.class, ZmqMessageSelector.class, ZmqRedeliveryPolicy.class, Boolean.TYPE, ZmqGateway.Direction.class);
            boolean socketBound = uri.getOptionValue("gateway.bind", isBound);
            ZmqSocketType socketType = ZmqSocketType.valueOf(uri.getOptionValue("gateway.type", type.toString()));
            String socketAddr = uri.getOptionValue("gateway.addr");
            if (socketAddr == null) {
                throw new ZmqException("Missing UTI 'gateway.addr' construct gateway consumer: " + uri);
            }
            String name = namePrefix + "@" + socketAddr;
            ZmqGateway protocol = (ZmqGateway)producerConstructor.newInstance(new Object[]{name, context, socketType, socketBound, socketAddr, 0, filter, handler, listener, store, selector, redelivery, transacted, ZmqGateway.Direction.OUTGOING});
            if (uri != null) {
                Map<String, List<String>> parameters = uri.getOptions();
                ClassUtils.setMethods(parameters, protocol);
            }
            return protocol;
        }
        catch (IllegalArgumentException | ReflectiveOperationException ex) {
            LOGGER.log(Level.SEVERE, "Unable to construct producer based on URI: " + destinationUri, ex);
            throw new ZmqException("Unable to construct produce based on URI: " + destinationUri, ex);
        }
    }

    protected ZmqMessageSelector getZmqMessageSelector(AbstractZmqDestination destination, String expression) throws ZmqException {
        if (expression == null || expression.trim().length() == 0) {
            return null;
        }
        String name = destination.getName();
        try {
            Class<?> selectorFactoryClass;
            ZmqURI uri;
            String value;
            ZmqMessageSelector selector = null;
            if (this.destinationSchema.containsKey(name) && (value = (uri = this.destinationSchema.get(name)).getOptionValue("selector", null)) != null && (selectorFactoryClass = ClassUtils.getClass(this.eventHandlerClasses, ZmqComponent.class, "value", value)) != null) {
                ZmqMessageSelectorFactory selectorFactory = (ZmqMessageSelectorFactory)selectorFactoryClass.newInstance();
                LOGGER.info("Using selector factory (" + selectorFactory.getClass().getCanonicalName() + ") for destination: " + destination);
                selector = selectorFactory.parse(expression);
            }
            if (selector == null) {
                selector = this.defaultSelectorFactory.parse(expression);
                LOGGER.info("Using default selector factory (" + this.defaultSelectorFactory.getClass().getCanonicalName() + ") for destination: " + destination);
            }
            if (this.destinationSchema.containsKey(name) && selector != null) {
                uri = this.destinationSchema.get(name);
                Map<String, List<String>> parameters = uri.getOptions();
                ClassUtils.setMethods(parameters, selector);
            }
            return selector;
        }
        catch (Exception ex) {
            throw new ZmqException("Unable resolve the message selector for destination: " + name, ex);
        }
    }

    protected ZmqEventHandler getZmqEventHandler(AbstractZmqDestination destination) throws ZmqException {
        String name = destination.getName();
        try {
            ZmqURI uri;
            String value;
            ZmqEventHandler eventHandler = null;
            if (this.destinationSchema.containsKey(name) && (value = (uri = this.destinationSchema.get(name)).getOptionValue("event")) != null) {
                Class<?> eventHandlerClass = ClassUtils.getClass(this.eventHandlerClasses, ZmqComponent.class, "value", value);
                if (eventHandlerClass == null) {
                    throw new ZmqException("Unable to find specified event handler: " + value);
                }
                eventHandler = (ZmqEventHandler)eventHandlerClass.newInstance();
                LOGGER.info("Using event handler  (" + eventHandler.getClass().getCanonicalName() + ") for destination: " + destination);
            }
            if (eventHandler == null) {
                eventHandler = this.defaultEventHandler;
                LOGGER.info("Using default event handler (" + eventHandler.getClass().getCanonicalName() + ") for destination: " + destination);
            }
            if (this.destinationSchema.containsKey(name) && eventHandler != null) {
                uri = this.destinationSchema.get(name);
                Map<String, List<String>> parameters = uri.getOptions();
                ClassUtils.setMethods(parameters, eventHandler);
            }
            return eventHandler;
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, "Unable resolve the event handler for destination " + name, ex);
            throw new ZmqException("Unable resolve the event handler for destination: " + name, ex);
        }
    }

    protected ZmqFilterPolicy getZmqFilterPolicy(AbstractZmqDestination destination) throws ZmqException {
        if (destination instanceof Queue) {
            return null;
        }
        String name = destination.getName();
        try {
            ZmqURI uri;
            String value;
            ZmqFilterPolicy filter = null;
            if (this.destinationSchema.containsKey(name) && (value = (uri = this.destinationSchema.get(name)).getOptionValue("filter")) != null) {
                Class<?> filterPolicyClass = ClassUtils.getClass(this.filterPolicyClasses, ZmqComponent.class, "value", value);
                if (filterPolicyClass == null) {
                    throw new ZmqException("Unable to find specified filter policy: " + value);
                }
                filter = (ZmqFilterPolicy)filterPolicyClass.newInstance();
                LOGGER.info("Using filter policy  (" + filter.getClass().getCanonicalName() + ") for destination: " + destination);
                Object[] filters = uri.getOptionValues("filter.value", null);
                if (filters != null && filters.length > 0) {
                    filter.setFilters(null);
                    LOGGER.info("Using filters  (" + Arrays.toString(filters) + ") for destination: " + destination);
                }
            }
            if (filter == null) {
                filter = this.defaultFilterPolicy;
                if (filter == null) {
                    LOGGER.info("NULL default filter policy for destination: " + destination);
                } else {
                    LOGGER.info("Using default filter policy (" + this.defaultFilterPolicy.getClass().getCanonicalName() + ") for destination: " + destination);
                }
            }
            if (this.destinationSchema.containsKey(name) && filter != null) {
                uri = this.destinationSchema.get(name);
                Map<String, List<String>> parameters = uri.getOptions();
                ClassUtils.setMethods(parameters, filter);
            }
            return filter;
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, "Unable resolve the message filter policy for destination " + name, ex);
            throw new ZmqException("Unable resolve the message filter policy for destination: " + name, ex);
        }
    }

    protected ZmqJournalStore getZmqJournalStore(AbstractZmqDestination destination, ZmqGateway.Direction direction) throws ZmqException {
        String name = destination.getName();
        try {
            ZmqURI uri;
            String value;
            ZmqJournalStore store = null;
            if (this.destinationSchema.containsKey(name) && (value = (uri = this.destinationSchema.get(name)).getOptionValue("journal")) != null) {
                Class<?> journalStoreClass = ClassUtils.getClass(this.journalStoreClasses, ZmqComponent.class, "value", value);
                if (journalStoreClass == null) {
                    throw new ZmqException("Unable to find specified journal store: " + value);
                }
                Constructor<?> storeConstructor = journalStoreClass.getConstructor(Path.class, String.class, String.class);
                String groupId = name + "-" + direction.name().toLowerCase();
                String uniqueId = ManagementFactory.getRuntimeMXBean().getName().replaceAll("\\W+", "-").toLowerCase();
                store = (ZmqJournalStore)storeConstructor.newInstance(null, groupId, uniqueId);
                LOGGER.info("Using journal store  (" + store.getClass().getCanonicalName() + ") for destination: " + destination);
            }
            if (store == null) {
                LOGGER.info("Using NO jounral store for destination: " + destination);
            }
            if (this.destinationSchema.containsKey(name) && store != null) {
                uri = this.destinationSchema.get(name);
                Map<String, List<String>> parameters = uri.getOptions();
                ClassUtils.setMethods(parameters, store);
            }
            return store;
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, "Unable resolve the message journal store for destination " + name, ex);
            throw new ZmqException("Unable resolve the message journal store for destination: " + name, ex);
        }
    }

    protected ZmqRedeliveryPolicy getRedeliveryPolicy(AbstractZmqDestination destination) throws ZmqException {
        String name = destination.getName();
        try {
            ZmqURI uri;
            String value;
            ZmqRedeliveryPolicy redeliveryPolicy = null;
            if (this.destinationSchema.containsKey(name) && (value = (uri = this.destinationSchema.get(name)).getOptionValue("redelivery")) != null) {
                Class<?> redeliveryPolicyClass = ClassUtils.getClass(this.redeliveryPolicyClasses, ZmqComponent.class, "value", value);
                if (redeliveryPolicyClass == null) {
                    throw new ZmqException("Unable to find specified re-delivery policy: " + value);
                }
                redeliveryPolicy = (ZmqRedeliveryPolicy)redeliveryPolicyClass.newInstance();
                LOGGER.info("Using re-delivery policy  (" + redeliveryPolicy.getClass().getCanonicalName() + ") for destination: " + destination);
            }
            if (redeliveryPolicy == null) {
                redeliveryPolicy = this.defaultRedeliveryPolicy;
                LOGGER.info("Using default re-delivery policy (" + redeliveryPolicy.getClass().getCanonicalName() + ") for destination: " + destination);
            }
            if (this.destinationSchema.containsKey(name) && redeliveryPolicy != null) {
                uri = this.destinationSchema.get(name);
                Map<String, List<String>> parameters = uri.getOptions();
                ClassUtils.setMethods(parameters, redeliveryPolicy);
            }
            return redeliveryPolicy;
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, "Unable resolve the re-delivery policy for destination " + name, ex);
            throw new ZmqException("Unable resolve the re-delivery policy for destination: " + name, ex);
        }
    }
}

