/*
 * Decompiled with CFR 0.152.
 */
package org.zeromq.jms;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import org.zeromq.ZMQException;
import org.zeromq.jms.ZmqException;
import org.zeromq.jms.ZmqMessage;
import org.zeromq.jms.protocol.ZmqGateway;
import org.zeromq.jms.protocol.ZmqGatewayListener;

abstract class AbstractZmqMessageConsumer
implements MessageConsumer {
    private static final Logger LOGGER = Logger.getLogger(AbstractZmqMessageConsumer.class.getCanonicalName());
    private final ZmqGateway protocol;
    private final Destination destination;
    private final String messageSelector;
    private final ExceptionListener exceptionHandler;
    private MessageListener listener;

    AbstractZmqMessageConsumer(ZmqGateway protocol, Destination destination, String messageSelector, ExceptionListener exceptionHandler) {
        this.protocol = protocol;
        this.destination = destination;
        this.messageSelector = messageSelector;
        this.exceptionHandler = exceptionHandler;
    }

    protected ZmqGateway getProtocol() {
        return this.protocol;
    }

    protected Destination getDestination() {
        return this.destination;
    }

    public void close() throws JMSException {
        this.protocol.close(-1);
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "Message commumer closed: " + this, new Exception("Closing stack"));
        } else {
            LOGGER.info("Message commumer closed: " + this);
        }
    }

    public MessageListener getMessageListener() throws JMSException {
        return this.listener;
    }

    public String getMessageSelector() throws JMSException {
        return this.messageSelector;
    }

    public Message receive() throws JMSException {
        try {
            return this.protocol.receive();
        }
        catch (ZMQException | ZmqException ex) {
            throw new JMSException(((Throwable)ex).getMessage());
        }
    }

    public Message receive(long timeout) throws JMSException {
        try {
            return this.protocol.receive((int)timeout);
        }
        catch (ZmqException ex) {
            throw new JMSException(ex.getMessage());
        }
    }

    public Message receiveNoWait() throws JMSException {
        try {
            return this.protocol.receive(0);
        }
        catch (ZMQException | ZmqException ex) {
            throw new JMSException(((Throwable)ex).getMessage());
        }
    }

    public void setMessageListener(final MessageListener listener) throws JMSException {
        this.listener = listener;
        ZmqGatewayListener protcolListener = new ZmqGatewayListener(){

            @Override
            public void onMessage(ZmqMessage message) {
                listener.onMessage((Message)message);
            }

            @Override
            public void onException(ZmqException ex) {
                JMSException exception = new JMSException(ex.getMessage());
                AbstractZmqMessageConsumer.this.exceptionHandler.onException(exception);
            }
        };
        this.protocol.setListener(protcolListener);
    }

    public String toString() {
        return "AbstractZmqMessageConsumer [protocol=" + this.protocol + ", destination=" + this.destination + ", messageSelector=" + this.messageSelector + "]";
    }
}

