/*
 * Decompiled with CFR 0.152.
 */
package org.zeromq.jms;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.CompletionListener;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import org.zeromq.ZMQException;
import org.zeromq.jms.AbstractZmqMessageConsumer;
import org.zeromq.jms.ZmqException;
import org.zeromq.jms.ZmqMessage;
import org.zeromq.jms.protocol.ZmqGateway;

abstract class AbstractZmqMessageProducer
implements MessageProducer {
    private static final Logger LOGGER = Logger.getLogger(AbstractZmqMessageConsumer.class.getCanonicalName());
    private ZmqGateway protocol;
    private int deliveryMode;
    private Destination destination;
    private boolean disableMessageID;
    private boolean disableMessageTimestamp;
    private int priority;
    private long timeToLive;

    AbstractZmqMessageProducer(ZmqGateway protocol, Destination destination) {
        this.protocol = protocol;
        this.destination = destination;
    }

    protected ZmqGateway getProtocol() {
        return this.protocol;
    }

    public void close() throws JMSException {
        this.protocol.close(-1);
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "Message producer closed: " + this, new Exception("Closing stack"));
        } else {
            LOGGER.info("Message producer closed: " + this);
        }
    }

    public int getDeliveryMode() throws JMSException {
        return this.deliveryMode;
    }

    public Destination getDestination() throws JMSException {
        return this.destination;
    }

    public boolean getDisableMessageID() throws JMSException {
        return this.disableMessageID;
    }

    public boolean getDisableMessageTimestamp() throws JMSException {
        return this.disableMessageTimestamp;
    }

    public int getPriority() throws JMSException {
        return this.priority;
    }

    public long getTimeToLive() throws JMSException {
        return this.timeToLive;
    }

    public void send(Message message) throws JMSException {
        this.send(this.destination, message);
    }

    public void send(Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.send(this.destination, message, deliveryMode, priority, timeToLive);
    }

    public void send(Destination destination, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        message.setJMSDeliveryMode(deliveryMode);
        message.setJMSPriority(priority);
        message.setJMSExpiration(timeToLive);
        this.send(destination, message);
    }

    public void send(Destination destination, Message message) throws JMSException {
        try {
            this.protocol.send((ZmqMessage)message);
        }
        catch (ZMQException | ZmqException ex) {
            throw new JMSException(((Throwable)ex).getMessage());
        }
    }

    public void setDeliveryMode(int deliveryMode) throws JMSException {
        this.deliveryMode = deliveryMode;
    }

    public void setDisableMessageID(boolean disableMessageID) throws JMSException {
        this.disableMessageID = disableMessageID;
    }

    public void setDisableMessageTimestamp(boolean disableMessageTimestamp) throws JMSException {
        this.disableMessageTimestamp = disableMessageTimestamp;
    }

    public void setPriority(int priority) throws JMSException {
        this.priority = priority;
    }

    public void setTimeToLive(long timeToLive) throws JMSException {
        this.timeToLive = timeToLive;
    }

    public long getDeliveryDelay() throws JMSException {
        throw new UnsupportedOperationException();
    }

    public void send(Message message, CompletionListener completionListener) throws JMSException {
        throw new UnsupportedOperationException();
    }

    public void send(Destination destination, Message message, CompletionListener completionListener) throws JMSException {
        throw new UnsupportedOperationException();
    }

    public void send(Message message, int deliveryMode, int priority, long timeToLive, CompletionListener completionListener) throws JMSException {
        throw new UnsupportedOperationException();
    }

    public void send(Destination destination, Message message, int deliveryMode, int priority, long timeToLive, CompletionListener completionListener) throws JMSException {
        throw new UnsupportedOperationException();
    }

    public void setDeliveryDelay(long deliveryDelay) throws JMSException {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return "AbstractZmqMessageProducer [protocol=" + this.protocol + ", deliveryMode=" + this.deliveryMode + ", destination=" + this.destination + ", disableMessageID=" + this.disableMessageID + ", disableMessageTimestamp=" + this.disableMessageTimestamp + ", priority=" + this.priority + ", timeToLive=" + this.timeToLive + "]";
    }
}

