/*
 * Decompiled with CFR 0.152.
 */
package org.zeromq.jms;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import org.zeromq.jms.ZmqMessage;

public class ZmpMapMessage
extends ZmqMessage
implements MapMessage {
    private Map<String, Object> map = new HashMap<String, Object>();

    @Override
    public <T> T getBody(Class<T> c) throws JMSException {
        return (T)this.map;
    }

    @Override
    public boolean isBodyAssignableTo(Class c) throws JMSException {
        return c.isAssignableFrom(Map.class);
    }

    public boolean getBoolean(String name) throws JMSException {
        return (Boolean)this.map.get(name);
    }

    public byte getByte(String name) throws JMSException {
        return (Byte)this.map.get(name);
    }

    public byte[] getBytes(String name) throws JMSException {
        return (byte[])this.map.get(name);
    }

    public char getChar(String name) throws JMSException {
        return ((Character)this.map.get(name)).charValue();
    }

    public double getDouble(String name) throws JMSException {
        return (Double)this.map.get(name);
    }

    public float getFloat(String name) throws JMSException {
        return ((Float)this.map.get(name)).floatValue();
    }

    public int getInt(String name) throws JMSException {
        return (Integer)this.map.get(name);
    }

    public long getLong(String name) throws JMSException {
        return (Long)this.map.get(name);
    }

    public Enumeration<String> getMapNames() throws JMSException {
        Vector<String> names = new Vector<String>(this.map.keySet());
        return names.elements();
    }

    public Object getObject(String name) throws JMSException {
        return this.map.get(name);
    }

    public short getShort(String name) throws JMSException {
        return (Short)this.map.get(name);
    }

    public String getString(String name) throws JMSException {
        return (String)this.map.get(name);
    }

    public boolean itemExists(String name) throws JMSException {
        return this.map.containsKey(name);
    }

    public void setBoolean(String name, boolean value) throws JMSException {
        this.map.put(name, value);
    }

    public void setByte(String name, byte value) throws JMSException {
        this.map.put(name, value);
    }

    public void setBytes(String name, byte[] values) throws JMSException {
        this.map.put(name, values);
    }

    public void setBytes(String name, byte[] values, int startPos, int endPos) throws JMSException {
        int size = endPos - startPos + 1;
        byte[] subValues = new byte[size];
        System.arraycopy(values, startPos, subValues, 0, size);
        this.map.put(name, subValues);
    }

    public void setChar(String name, char value) throws JMSException {
        this.map.put(name, Character.valueOf(value));
    }

    public void setDouble(String name, double value) throws JMSException {
        this.map.put(name, value);
    }

    public void setFloat(String name, float value) throws JMSException {
        this.map.put(name, Float.valueOf(value));
    }

    public void setInt(String name, int value) throws JMSException {
        this.map.put(name, value);
    }

    public void setLong(String name, long value) throws JMSException {
        this.map.put(name, value);
    }

    public void setObject(String name, Object value) throws JMSException {
        this.map.put(name, value);
    }

    public void setShort(String name, short value) throws JMSException {
        this.map.put(name, value);
    }

    public void setString(String name, String value) throws JMSException {
        this.map.put(name, value);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeInt(this.map.size());
        for (String name : this.map.keySet()) {
            Object value = this.map.get(name);
            out.writeObject(value);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.map = new HashMap<String, Object>();
        int mapCount = in.readInt();
        int i = 0;
        while (i < mapCount) {
            String name = (String)in.readObject();
            Object value = in.readObject();
            this.map.put(name, value);
            ++i;
        }
    }
}

