/*
 * Decompiled with CFR 0.152.
 */
package org.zeromq.jms;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.MessageFormatException;
import javax.jms.MessageNotReadableException;
import javax.jms.MessageNotWriteableException;
import org.zeromq.jms.ZmqException;
import org.zeromq.jms.ZmqMessage;

public class ZmqByteMessage
extends ZmqMessage
implements BytesMessage {
    private byte[] content = null;
    private ByteArrayInputStream inByteArray = null;
    private ByteArrayOutputStream outByteArray = new ByteArrayOutputStream();
    private DataInputStream inData = null;
    private DataOutputStream outData = new DataOutputStream(this.outByteArray);

    @Override
    public void clearBody() throws JMSException {
        if (this.inData != null) {
            try {
                this.inData.close();
            }
            catch (IOException ex) {
                throw new ZmqException("Unable to reset the message mode.", ex);
            }
            this.inByteArray = null;
            this.inData = null;
        }
        if (this.outData != null) {
            try {
                this.outData.close();
            }
            catch (IOException ex) {
                throw new ZmqException("Unable to reset the message mode.", ex);
            }
        }
        this.outByteArray = new ByteArrayOutputStream();
        this.outData = new DataOutputStream(this.outByteArray);
        this.content = null;
    }

    public void reset() throws JMSException {
        if (this.outData != null) {
            this.content = this.outByteArray.toByteArray();
            try {
                this.outData.close();
            }
            catch (IOException ex) {
                throw new ZmqException("Unable to reset the message mode.", ex);
            }
            this.outByteArray = null;
            this.outData = null;
        }
        if (this.inData != null) {
            try {
                this.inData.close();
            }
            catch (IOException ex) {
                throw new ZmqException("Unable to reset the message mode.", ex);
            }
        }
        if (this.content == null) {
            throw new ZmqException("Unable to reset the message mode, due to missing content.");
        }
        this.inByteArray = new ByteArrayInputStream(this.content);
        this.inData = new DataInputStream(this.inByteArray);
    }

    private void checkReadMode() throws MessageNotReadableException {
        if (this.outData == null) {
            throw new MessageNotReadableException("Message no in read mode.");
        }
        if (this.inData != null) {
            throw new MessageNotReadableException("Message no in read mode.");
        }
    }

    private void checkWriteMode() throws MessageNotWriteableException {
        if (this.inData == null) {
            throw new MessageNotWriteableException("Message no in read mode.");
        }
    }

    @Override
    public <T> T getBody(Class<T> c) throws JMSException {
        return (T)this.content;
    }

    @Override
    public boolean isBodyAssignableTo(Class c) throws JMSException {
        return c.isAssignableFrom(Byte[].class);
    }

    public long getBodyLength() throws JMSException {
        return this.content == null ? 0 : this.content.length;
    }

    public boolean readBoolean() throws JMSException {
        this.checkReadMode();
        try {
            return this.inData.readBoolean();
        }
        catch (IOException ex) {
            throw new ZmqException("Unable to read from stream.", ex);
        }
    }

    public byte readByte() throws JMSException {
        this.checkReadMode();
        try {
            return this.inData.readByte();
        }
        catch (IOException ex) {
            throw new ZmqException("Unable to read from stream.", ex);
        }
    }

    public int readBytes(byte[] value) throws JMSException {
        this.checkReadMode();
        try {
            return this.inData.read(value);
        }
        catch (IOException ex) {
            throw new ZmqException("Unable to read from stream.", ex);
        }
    }

    public int readBytes(byte[] value, int length) throws JMSException {
        this.checkReadMode();
        try {
            return this.inData.read(value, 0, length);
        }
        catch (IOException ex) {
            throw new ZmqException("Unable to read from stream.", ex);
        }
    }

    public char readChar() throws JMSException {
        this.checkReadMode();
        try {
            return this.inData.readChar();
        }
        catch (IOException ex) {
            throw new ZmqException("Unable to read from stream.", ex);
        }
    }

    public double readDouble() throws JMSException {
        this.checkReadMode();
        try {
            return this.inData.readDouble();
        }
        catch (IOException ex) {
            throw new ZmqException("Unable to read from stream.", ex);
        }
    }

    public float readFloat() throws JMSException {
        this.checkReadMode();
        try {
            return this.inData.readFloat();
        }
        catch (IOException ex) {
            throw new ZmqException("Unable to read from stream.", ex);
        }
    }

    public int readInt() throws JMSException {
        this.checkReadMode();
        try {
            return this.inData.readInt();
        }
        catch (IOException ex) {
            throw new ZmqException("Unable to read from stream.", ex);
        }
    }

    public long readLong() throws JMSException {
        this.checkReadMode();
        try {
            return this.inData.readLong();
        }
        catch (IOException ex) {
            throw new ZmqException("Unable to read from stream.", ex);
        }
    }

    public short readShort() throws JMSException {
        this.checkReadMode();
        try {
            return this.inData.readShort();
        }
        catch (IOException ex) {
            throw new ZmqException("Unable to read from stream.", ex);
        }
    }

    public String readUTF() throws JMSException {
        this.checkReadMode();
        try {
            return this.inData.readUTF();
        }
        catch (IOException ex) {
            throw new ZmqException("Unable to read from stream.", ex);
        }
    }

    public int readUnsignedByte() throws JMSException {
        this.checkReadMode();
        try {
            return this.inData.readUnsignedByte();
        }
        catch (IOException ex) {
            throw new ZmqException("Unable to read from stream.", ex);
        }
    }

    public int readUnsignedShort() throws JMSException {
        this.checkReadMode();
        try {
            return this.inData.readUnsignedShort();
        }
        catch (IOException ex) {
            throw new ZmqException("Unable to read from stream.", ex);
        }
    }

    public void writeBoolean(boolean value) throws JMSException {
        this.checkWriteMode();
        try {
            this.outData.writeBoolean(value);
        }
        catch (IOException ex) {
            throw new ZmqException("Unable to write into message.", ex);
        }
    }

    public void writeByte(byte value) throws JMSException {
        this.checkWriteMode();
        try {
            this.outData.writeByte(value);
        }
        catch (IOException ex) {
            throw new ZmqException("Unable to write into message.", ex);
        }
    }

    public void writeBytes(byte[] value) throws JMSException {
        this.checkWriteMode();
        try {
            this.outData.write(value);
        }
        catch (IOException ex) {
            throw new ZmqException("Unable to write into message.", ex);
        }
    }

    public void writeBytes(byte[] value, int offset, int length) throws JMSException {
        this.checkWriteMode();
        try {
            this.outData.write(value, offset, length);
        }
        catch (IOException ex) {
            throw new ZmqException("Unable to write into message.", ex);
        }
    }

    public void writeChar(char value) throws JMSException {
        this.checkWriteMode();
        try {
            this.outData.writeChar(value);
        }
        catch (IOException ex) {
            throw new ZmqException("Unable to write into message.", ex);
        }
    }

    public void writeDouble(double value) throws JMSException {
        this.checkWriteMode();
        try {
            this.outData.writeDouble(value);
        }
        catch (IOException ex) {
            throw new ZmqException("Unable to write into message.", ex);
        }
    }

    public void writeFloat(float value) throws JMSException {
        this.checkWriteMode();
        try {
            this.outData.writeFloat(value);
        }
        catch (IOException ex) {
            throw new ZmqException("Unable to write into message.", ex);
        }
    }

    public void writeInt(int value) throws JMSException {
        this.checkWriteMode();
        try {
            this.outData.writeInt(value);
        }
        catch (IOException ex) {
            throw new ZmqException("Unable to write into message.", ex);
        }
    }

    public void writeLong(long value) throws JMSException {
        this.checkWriteMode();
        try {
            this.outData.writeLong(value);
        }
        catch (IOException ex) {
            throw new ZmqException("Unable to write into message.", ex);
        }
    }

    public void writeObject(Object value) throws JMSException {
        this.checkWriteMode();
        if (value == null) {
            throw new NullPointerException();
        }
        if (value instanceof Boolean) {
            this.writeBoolean((Boolean)value);
        } else if (value instanceof Character) {
            this.writeChar(((Character)value).charValue());
        } else if (value instanceof Byte) {
            this.writeByte((Byte)value);
        } else if (value instanceof Short) {
            this.writeShort((Short)value);
        } else if (value instanceof Integer) {
            this.writeInt((Integer)value);
        } else if (value instanceof Long) {
            this.writeLong((Long)value);
        } else if (value instanceof Float) {
            this.writeFloat(((Float)value).floatValue());
        } else if (value instanceof Double) {
            this.writeDouble((Double)value);
        } else if (value instanceof String) {
            this.writeUTF(value.toString());
        } else if (value instanceof byte[]) {
            this.writeBytes((byte[])value);
        } else {
            throw new MessageFormatException("Cannot write non-primitive type:" + value.getClass());
        }
    }

    public void writeShort(short value) throws JMSException {
        this.checkWriteMode();
        try {
            this.outData.writeShort(value);
        }
        catch (IOException ex) {
            throw new ZmqException("Unable to write into message.", ex);
        }
    }

    public void writeUTF(String value) throws JMSException {
        this.checkWriteMode();
        try {
            this.outData.writeUTF(value);
        }
        catch (IOException ex) {
            throw new ZmqException("Unable to write into message.", ex);
        }
    }
}

