/*
 * Decompiled with CFR 0.152.
 */
package org.zeromq.jms;

import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.ConnectionConsumer;
import javax.jms.ConnectionMetaData;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueSession;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicSession;
import org.zeromq.jms.ZmqSession;
import org.zeromq.jms.ZmqURI;
import org.zeromq.jms.protocol.ZmqGatewayFactory;

public class ZmqConnection
implements QueueConnection,
TopicConnection {
    private static final Logger LOGGER = Logger.getLogger(ZmqConnection.class.getCanonicalName());
    private ZmqGatewayFactory gatewayFactory;
    private Map<String, ZmqURI> destinationSchema;
    private ZmqExceptionHandler exceptionHandler = new ZmqExceptionHandler();

    public ZmqConnection(ZmqGatewayFactory gatewayFactory, Map<String, ZmqURI> destinationSchema) {
        this.gatewayFactory = gatewayFactory;
        this.destinationSchema = destinationSchema;
    }

    public void close() throws JMSException {
        throw new UnsupportedOperationException();
    }

    public ConnectionConsumer createConnectionConsumer(Destination destination, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        throw new UnsupportedOperationException();
    }

    public ConnectionConsumer createDurableConnectionConsumer(Topic topic, String subscriptionName, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        throw new UnsupportedOperationException();
    }

    public Session createSession(boolean transacted, int acknowledgeMode) throws JMSException {
        ZmqSession session = new ZmqSession(this.gatewayFactory, this.destinationSchema, transacted, acknowledgeMode, this.exceptionHandler);
        return session;
    }

    public String getClientID() throws JMSException {
        throw new UnsupportedOperationException();
    }

    public ExceptionListener getExceptionListener() throws JMSException {
        return this.exceptionHandler.listener;
    }

    public ConnectionMetaData getMetaData() throws JMSException {
        throw new UnsupportedOperationException();
    }

    public void setClientID(String clientID) throws JMSException {
        throw new UnsupportedOperationException();
    }

    public void setExceptionListener(ExceptionListener listener) throws JMSException {
        this.exceptionHandler.listener = listener;
    }

    public void start() throws JMSException {
        throw new UnsupportedOperationException();
    }

    public void stop() throws JMSException {
        throw new UnsupportedOperationException();
    }

    public ConnectionConsumer createConnectionConsumer(Queue queue, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        throw new UnsupportedOperationException();
    }

    public QueueSession createQueueSession(boolean transacted, int acknowledgeMode) throws JMSException {
        ZmqSession session = new ZmqSession(this.gatewayFactory, this.destinationSchema, transacted, acknowledgeMode, this.exceptionHandler);
        return session;
    }

    public ConnectionConsumer createConnectionConsumer(Topic topic, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        throw new UnsupportedOperationException();
    }

    public TopicSession createTopicSession(boolean transacted, int acknowledgeMode) throws JMSException {
        ZmqSession session = new ZmqSession(this.gatewayFactory, this.destinationSchema, transacted, acknowledgeMode, this.exceptionHandler);
        return session;
    }

    public Session createSession() throws JMSException {
        Session session = this.createSession(1);
        return session;
    }

    public Session createSession(int sessionMode) throws JMSException {
        ZmqSession session = new ZmqSession(this.gatewayFactory, this.destinationSchema, false, sessionMode, this.exceptionHandler);
        return session;
    }

    public ConnectionConsumer createSharedConnectionConsumer(Topic topic, String subscriptionName, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        throw new UnsupportedOperationException();
    }

    public ConnectionConsumer createSharedDurableConnectionConsumer(Topic topic, String subscriptionName, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        throw new UnsupportedOperationException();
    }

    private class ZmqExceptionHandler
    implements ExceptionListener {
        private volatile ExceptionListener listener = null;

        private ZmqExceptionHandler() {
        }

        public void onException(JMSException exception) {
            ExceptionListener listener = this.listener;
            try {
                if (listener != null) {
                    listener.onException(exception);
                }
            }
            catch (Exception ex) {
                LOGGER.log(Level.SEVERE, "Unable notify exception listener.", ex);
            }
        }
    }
}

