/*
 * Decompiled with CFR 0.152.
 */
package org.zeromq.jms;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.zeromq.jms.ZmqURI;

public class ZmqExtendedURI
extends ZmqURI {
    private final List<ZmqURI> extendURIs;

    public ZmqExtendedURI(ZmqURI uri, Map<String, ZmqURI> destinationSchema) {
        super(uri.getStr(), uri.getScheme(), uri.getDestinationType(), uri.getDestinationName(), uri.getOptions());
        this.extendURIs = new ArrayList<ZmqURI>(this.getExtends(uri, destinationSchema));
        Collections.reverse(this.extendURIs);
    }

    private Set<ZmqURI> getExtends(ZmqURI uri, Map<String, ZmqURI> destinationSchema) {
        LinkedHashSet<ZmqURI> newExtendURIs = new LinkedHashSet<ZmqURI>();
        if (uri.isOption("extends")) {
            String[] names = uri.getOptionValues("extends");
            Collections.reverse(Arrays.asList(names));
            String[] stringArray = names;
            int n = names.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                ZmqURI extendURI = destinationSchema.get(name);
                Set<ZmqURI> extendURIs = this.getExtends(extendURI, destinationSchema);
                newExtendURIs.addAll(extendURIs);
                ++n2;
            }
        }
        newExtendURIs.add(uri);
        return newExtendURIs;
    }

    @Override
    public boolean isOption(String paramName) {
        for (ZmqURI uri : this.extendURIs) {
            if (!uri.isOption(paramName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Map<String, List<String>> getOptions() {
        HashMap<String, List<String>> options = new HashMap<String, List<String>>();
        for (ZmqURI uri : this.extendURIs) {
            options.putAll(uri.getOptions());
        }
        return options;
    }

    @Override
    public Map<String, List<String>> getOptions(String prefix) {
        HashMap<String, List<String>> selectedOptions = new HashMap<String, List<String>>();
        for (ZmqURI uri : this.extendURIs) {
            Map<String, List<String>> options = uri.getOptions();
            for (String name : options.keySet()) {
                if (!name.startsWith(prefix)) continue;
                List<String> value = options.get(name);
                selectedOptions.put(name, value);
            }
        }
        return selectedOptions;
    }

    @Override
    public String[] getOptionValues(String paramName) {
        for (ZmqURI uri : this.extendURIs) {
            Map<String, List<String>> options = uri.getOptions();
            List<String> values = options.get(paramName);
            if (values == null) continue;
            return values.toArray(new String[0]);
        }
        return null;
    }
}

