/*
 * Decompiled with CFR 0.152.
 */
package org.zeromq.jms;

import javax.jms.JMSConsumer;
import javax.jms.JMSException;
import javax.jms.JMSRuntimeException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import org.zeromq.jms.ZmqJMSContext;

public class ZmqJMSConsumer
implements JMSConsumer {
    private final ZmqJMSContext context;
    private final MessageConsumer consumer;

    public ZmqJMSConsumer(ZmqJMSContext context, MessageConsumer consumer) {
        this.context = context;
        this.consumer = consumer;
    }

    public void close() {
        try {
            this.consumer.close();
        }
        catch (JMSException ex) {
            throw new JMSRuntimeException(ex.getMessage(), ex.getErrorCode(), (Throwable)ex);
        }
    }

    public MessageListener getMessageListener() throws JMSRuntimeException {
        try {
            return this.consumer.getMessageListener();
        }
        catch (JMSException ex) {
            throw new JMSRuntimeException(ex.getMessage(), ex.getErrorCode(), (Throwable)ex);
        }
    }

    public String getMessageSelector() {
        try {
            return this.consumer.getMessageSelector();
        }
        catch (JMSException ex) {
            throw new JMSRuntimeException(ex.getMessage(), ex.getErrorCode(), (Throwable)ex);
        }
    }

    public Message receive() {
        try {
            Message message = this.consumer.receive();
            return message;
        }
        catch (JMSException ex) {
            throw new JMSRuntimeException(ex.getMessage(), ex.getErrorCode(), (Throwable)ex);
        }
    }

    public Message receive(long timeout) {
        try {
            Message message = this.consumer.receive(timeout);
            return message;
        }
        catch (JMSException ex) {
            throw new JMSRuntimeException(ex.getMessage(), ex.getErrorCode(), (Throwable)ex);
        }
    }

    public <T> T receiveBody(Class<T> c) {
        try {
            Message message = this.consumer.receive();
            return (T)(message == null ? null : message.getBody(c));
        }
        catch (JMSException ex) {
            throw new JMSRuntimeException(ex.getMessage(), ex.getErrorCode(), (Throwable)ex);
        }
    }

    public <T> T receiveBody(Class<T> c, long timeout) {
        try {
            Message message = this.consumer.receive(timeout);
            return (T)(message == null ? null : message.getBody(c));
        }
        catch (JMSException ex) {
            throw new JMSRuntimeException(ex.getMessage(), ex.getErrorCode(), (Throwable)ex);
        }
    }

    public <T> T receiveBodyNoWait(Class<T> c) {
        try {
            Message message = this.consumer.receiveNoWait();
            return (T)(message == null ? null : message.getBody(c));
        }
        catch (JMSException ex) {
            throw new JMSRuntimeException(ex.getMessage(), ex.getErrorCode(), (Throwable)ex);
        }
    }

    public Message receiveNoWait() {
        try {
            Message message = this.consumer.receiveNoWait();
            return message;
        }
        catch (JMSException ex) {
            throw new JMSRuntimeException(ex.getMessage(), ex.getErrorCode(), (Throwable)ex);
        }
    }

    public void setMessageListener(MessageListener listener) throws JMSRuntimeException {
        try {
            this.consumer.setMessageListener(listener);
        }
        catch (JMSException ex) {
            throw new JMSRuntimeException(ex.getMessage(), ex.getErrorCode(), (Throwable)ex);
        }
    }
}

