/*
 * Decompiled with CFR 0.152.
 */
package org.zeromq.jms;

import java.io.Serializable;
import javax.jms.BytesMessage;
import javax.jms.ConnectionMetaData;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.IllegalStateRuntimeException;
import javax.jms.JMSConsumer;
import javax.jms.JMSContext;
import javax.jms.JMSException;
import javax.jms.JMSProducer;
import javax.jms.JMSRuntimeException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.StreamMessage;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;
import org.zeromq.jms.ZmqByteMessage;
import org.zeromq.jms.ZmqConnection;
import org.zeromq.jms.ZmqJMSConsumer;
import org.zeromq.jms.ZmqJMSProducer;
import org.zeromq.jms.ZmqSession;

public class ZmqJMSContext
implements JMSContext {
    private final ZmqConnection connection;
    private final int sessionMode;
    private final ZmqSession session;
    private boolean closed;
    private boolean autoStart;

    public ZmqJMSContext(ZmqConnection connection, int sessionMode) {
        this.connection = connection;
        this.sessionMode = sessionMode;
        try {
            this.session = (ZmqSession)connection.createSession(sessionMode);
        }
        catch (JMSException ex) {
            throw new JMSRuntimeException(ex.getMessage(), ex.getErrorCode(), (Throwable)ex);
        }
        this.closed = false;
        this.autoStart = false;
    }

    protected void checkAutoStart() {
        if (this.closed) {
            throw new IllegalStateRuntimeException("Context is closed");
        }
        if (this.autoStart) {
            try {
                this.connection.start();
            }
            catch (JMSException ex) {
                throw new JMSRuntimeException(ex.getMessage(), ex.getErrorCode(), (Throwable)ex);
            }
        }
    }

    protected void checkSession() {
        if (this.closed) {
            throw new IllegalStateRuntimeException("Context is closed");
        }
    }

    public void acknowledge() {
        throw new UnsupportedOperationException();
    }

    public synchronized void close() {
        this.closed = false;
        try {
            this.session.close();
        }
        catch (JMSException ex) {
            throw new JMSRuntimeException(ex.getMessage(), ex.getErrorCode(), (Throwable)ex);
        }
    }

    public synchronized void commit() {
        try {
            this.session.commit();
        }
        catch (JMSException ex) {
            throw new JMSRuntimeException(ex.getMessage(), ex.getErrorCode(), (Throwable)ex);
        }
    }

    public QueueBrowser createBrowser(Queue queue) {
        throw new UnsupportedOperationException();
    }

    public QueueBrowser createBrowser(Queue queue, String messageSelector) {
        throw new UnsupportedOperationException();
    }

    public BytesMessage createBytesMessage() {
        return new ZmqByteMessage();
    }

    public JMSConsumer createConsumer(Destination destination) {
        this.checkSession();
        try {
            MessageConsumer messageConsumer = this.session.createConsumer(destination);
            ZmqJMSConsumer jmsConsumer = new ZmqJMSConsumer(this, messageConsumer);
            this.checkAutoStart();
            return jmsConsumer;
        }
        catch (JMSException ex) {
            throw new JMSRuntimeException(ex.getMessage(), ex.getErrorCode(), (Throwable)ex);
        }
    }

    public JMSConsumer createConsumer(Destination destination, String messageSelector) {
        this.checkSession();
        try {
            MessageConsumer messageConsumer = this.session.createConsumer(destination, messageSelector);
            ZmqJMSConsumer jmsConsumer = new ZmqJMSConsumer(this, messageConsumer);
            this.checkAutoStart();
            return jmsConsumer;
        }
        catch (JMSException ex) {
            throw new JMSRuntimeException(ex.getMessage(), ex.getErrorCode(), (Throwable)ex);
        }
    }

    public JMSConsumer createConsumer(Destination destination, String messageSelector, boolean noLocal) {
        this.checkSession();
        try {
            MessageConsumer messageConsumer = this.session.createConsumer(destination, messageSelector, noLocal);
            ZmqJMSConsumer jmsConsumer = new ZmqJMSConsumer(this, messageConsumer);
            this.checkAutoStart();
            return jmsConsumer;
        }
        catch (JMSException ex) {
            throw new JMSRuntimeException(ex.getMessage(), ex.getErrorCode(), (Throwable)ex);
        }
    }

    public JMSContext createContext(int sessionMode) {
        ZmqJMSContext context = new ZmqJMSContext(this.connection, sessionMode);
        return context;
    }

    public JMSConsumer createDurableConsumer(Topic topic, String name) {
        this.checkSession();
        try {
            MessageConsumer messageConsumer = this.session.createDurableConsumer(topic, name);
            ZmqJMSConsumer jmsConsumer = new ZmqJMSConsumer(this, messageConsumer);
            this.checkAutoStart();
            return jmsConsumer;
        }
        catch (JMSException ex) {
            throw new JMSRuntimeException(ex.getMessage(), ex.getErrorCode(), (Throwable)ex);
        }
    }

    public JMSConsumer createDurableConsumer(Topic topic, String name, String messageSelector, boolean noLocal) {
        this.checkSession();
        try {
            MessageConsumer messageConsumer = this.session.createDurableConsumer(topic, name, messageSelector, noLocal);
            ZmqJMSConsumer jmsConsumer = new ZmqJMSConsumer(this, messageConsumer);
            this.checkAutoStart();
            return jmsConsumer;
        }
        catch (JMSException ex) {
            throw new JMSRuntimeException(ex.getMessage(), ex.getErrorCode(), (Throwable)ex);
        }
    }

    public MapMessage createMapMessage() {
        this.checkSession();
        try {
            return this.session.createMapMessage();
        }
        catch (JMSException ex) {
            throw new JMSRuntimeException(ex.getMessage(), ex.getErrorCode(), (Throwable)ex);
        }
    }

    public Message createMessage() {
        this.checkSession();
        try {
            return this.session.createMessage();
        }
        catch (JMSException ex) {
            throw new JMSRuntimeException(ex.getMessage(), ex.getErrorCode(), (Throwable)ex);
        }
    }

    public ObjectMessage createObjectMessage() {
        this.checkSession();
        try {
            return this.session.createObjectMessage();
        }
        catch (JMSException ex) {
            throw new JMSRuntimeException(ex.getMessage(), ex.getErrorCode(), (Throwable)ex);
        }
    }

    public ObjectMessage createObjectMessage(Serializable object) {
        this.checkSession();
        try {
            return this.session.createObjectMessage(object);
        }
        catch (JMSException ex) {
            throw new JMSRuntimeException(ex.getMessage(), ex.getErrorCode(), (Throwable)ex);
        }
    }

    public JMSProducer createProducer() {
        this.checkSession();
        ZmqJMSProducer producer = new ZmqJMSProducer(this, this.session);
        return producer;
    }

    public Queue createQueue(String queue) {
        this.checkSession();
        try {
            return this.session.createQueue(queue);
        }
        catch (JMSException ex) {
            throw new JMSRuntimeException(ex.getMessage(), ex.getErrorCode(), (Throwable)ex);
        }
    }

    public JMSConsumer createSharedConsumer(Topic topic, String name) {
        this.checkSession();
        try {
            MessageConsumer messageConsumer = this.session.createSharedConsumer(topic, name);
            ZmqJMSConsumer jmsConsumer = new ZmqJMSConsumer(this, messageConsumer);
            this.checkAutoStart();
            return jmsConsumer;
        }
        catch (JMSException ex) {
            throw new JMSRuntimeException(ex.getMessage(), ex.getErrorCode(), (Throwable)ex);
        }
    }

    public JMSConsumer createSharedConsumer(Topic topic, String name, String messageSelector) {
        this.checkSession();
        try {
            MessageConsumer messageConsumer = this.session.createSharedConsumer(topic, name, messageSelector);
            ZmqJMSConsumer jmsConsumer = new ZmqJMSConsumer(this, messageConsumer);
            this.checkAutoStart();
            return jmsConsumer;
        }
        catch (JMSException ex) {
            throw new JMSRuntimeException(ex.getMessage(), ex.getErrorCode(), (Throwable)ex);
        }
    }

    public JMSConsumer createSharedDurableConsumer(Topic topic, String sharedSubscriptionName) {
        this.checkSession();
        try {
            MessageConsumer messageConsumer = this.session.createSharedDurableConsumer(topic, sharedSubscriptionName);
            ZmqJMSConsumer jmsConsumer = new ZmqJMSConsumer(this, messageConsumer);
            this.checkAutoStart();
            return jmsConsumer;
        }
        catch (JMSException ex) {
            throw new JMSRuntimeException(ex.getMessage(), ex.getErrorCode(), (Throwable)ex);
        }
    }

    public JMSConsumer createSharedDurableConsumer(Topic topic, String sharedSubscriptionName, String messageSelector) {
        this.checkSession();
        try {
            MessageConsumer messageConsumer = this.session.createSharedDurableConsumer(topic, sharedSubscriptionName, messageSelector);
            ZmqJMSConsumer jmsConsumer = new ZmqJMSConsumer(this, messageConsumer);
            this.checkAutoStart();
            return jmsConsumer;
        }
        catch (JMSException ex) {
            throw new JMSRuntimeException(ex.getMessage(), ex.getErrorCode(), (Throwable)ex);
        }
    }

    public StreamMessage createStreamMessage() {
        this.checkSession();
        try {
            return this.session.createStreamMessage();
        }
        catch (JMSException ex) {
            throw new JMSRuntimeException(ex.getMessage(), ex.getErrorCode(), (Throwable)ex);
        }
    }

    public TemporaryQueue createTemporaryQueue() {
        this.checkSession();
        try {
            return this.session.createTemporaryQueue();
        }
        catch (JMSException ex) {
            throw new JMSRuntimeException(ex.getMessage(), ex.getErrorCode(), (Throwable)ex);
        }
    }

    public TemporaryTopic createTemporaryTopic() {
        this.checkSession();
        try {
            return this.session.createTemporaryTopic();
        }
        catch (JMSException ex) {
            throw new JMSRuntimeException(ex.getMessage(), ex.getErrorCode(), (Throwable)ex);
        }
    }

    public TextMessage createTextMessage() {
        this.checkSession();
        try {
            return this.session.createTextMessage();
        }
        catch (JMSException ex) {
            throw new JMSRuntimeException(ex.getMessage(), ex.getErrorCode(), (Throwable)ex);
        }
    }

    public TextMessage createTextMessage(String text) {
        this.checkSession();
        try {
            return this.session.createTextMessage(text);
        }
        catch (JMSException ex) {
            throw new JMSRuntimeException(ex.getMessage(), ex.getErrorCode(), (Throwable)ex);
        }
    }

    public Topic createTopic(String topicName) {
        this.checkSession();
        try {
            return this.session.createTopic(topicName);
        }
        catch (JMSException ex) {
            throw new JMSRuntimeException(ex.getMessage(), ex.getErrorCode(), (Throwable)ex);
        }
    }

    public boolean getAutoStart() {
        return this.autoStart;
    }

    public String getClientID() {
        try {
            return this.connection.getClientID();
        }
        catch (JMSException ex) {
            throw new JMSRuntimeException(ex.getMessage(), ex.getErrorCode(), (Throwable)ex);
        }
    }

    public ExceptionListener getExceptionListener() {
        try {
            return this.connection.getExceptionListener();
        }
        catch (JMSException ex) {
            throw new JMSRuntimeException(ex.getMessage(), ex.getErrorCode(), (Throwable)ex);
        }
    }

    public ConnectionMetaData getMetaData() {
        try {
            return this.connection.getMetaData();
        }
        catch (JMSException ex) {
            throw new JMSRuntimeException(ex.getMessage(), ex.getErrorCode(), (Throwable)ex);
        }
    }

    public int getSessionMode() {
        return this.sessionMode;
    }

    public boolean getTransacted() {
        this.checkSession();
        try {
            return this.session.getTransacted();
        }
        catch (JMSException ex) {
            throw new JMSRuntimeException(ex.getMessage(), ex.getErrorCode(), (Throwable)ex);
        }
    }

    public void recover() {
        this.checkSession();
        try {
            this.session.recover();
        }
        catch (JMSException ex) {
            throw new JMSRuntimeException(ex.getMessage(), ex.getErrorCode(), (Throwable)ex);
        }
    }

    public void rollback() {
        try {
            this.session.rollback();
        }
        catch (JMSException ex) {
            throw new JMSRuntimeException(ex.getMessage(), ex.getErrorCode(), (Throwable)ex);
        }
    }

    public void setAutoStart(boolean autoStart) {
        this.autoStart = autoStart;
    }

    public void setClientID(String clientID) {
        try {
            this.connection.setClientID(clientID);
        }
        catch (JMSException ex) {
            throw new JMSRuntimeException(ex.getMessage(), ex.getErrorCode(), (Throwable)ex);
        }
    }

    public void setExceptionListener(ExceptionListener listener) {
        try {
            this.connection.setExceptionListener(listener);
        }
        catch (JMSException ex) {
            throw new JMSRuntimeException(ex.getMessage(), ex.getErrorCode(), (Throwable)ex);
        }
    }

    public void start() {
        try {
            this.connection.start();
        }
        catch (JMSException ex) {
            throw new JMSRuntimeException(ex.getMessage(), ex.getErrorCode(), (Throwable)ex);
        }
    }

    public void stop() {
        try {
            this.connection.stop();
        }
        catch (JMSException ex) {
            throw new JMSRuntimeException(ex.getMessage(), ex.getErrorCode(), (Throwable)ex);
        }
    }

    public void unsubscribe(String name) {
        try {
            this.session.unsubscribe(name);
        }
        catch (JMSException ex) {
            throw new JMSRuntimeException(ex.getMessage(), ex.getErrorCode(), (Throwable)ex);
        }
    }

    public String toString() {
        return "ZmqContext [connection=" + this.connection + ", sessionMode=" + this.sessionMode + ", session=" + this.session + ", closed=" + this.closed + "]";
    }
}

