/*
 * Decompiled with CFR 0.152.
 */
package org.zeromq.jms;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.jms.BytesMessage;
import javax.jms.CompletionListener;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.JMSProducer;
import javax.jms.JMSRuntimeException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageFormatRuntimeException;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.TextMessage;
import org.zeromq.jms.ZmqJMSContext;
import org.zeromq.jms.ZmqSession;

public class ZmqJMSProducer
implements JMSProducer {
    private final ZmqJMSContext context;
    private final ZmqSession session;
    private final Map<Destination, MessageProducer> messageProducers = new HashMap<Destination, MessageProducer>();
    private final Map<String, Object> properties = new HashMap<String, Object>();
    private String jmsType;
    private String jmsCorrelationID;
    private Destination jmsReplyTo;
    private Long deliverDelay;
    private Integer deliveryMode;
    private Boolean disableMessageID;
    private Boolean disableMessageTimestamp;
    private Integer priority;
    private Long timeToLive;
    private CompletionListener completionListener;

    public ZmqJMSProducer(ZmqJMSContext context, ZmqSession session) {
        this.context = context;
        this.session = session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MessageProducer getMessageProducer(Destination destination) {
        try {
            Map<Destination, MessageProducer> map = this.messageProducers;
            synchronized (map) {
                MessageProducer messageProducer = this.messageProducers.get(destination);
                if (messageProducer == null) {
                    messageProducer = this.session.createProducer(destination);
                    this.messageProducers.put(destination, messageProducer);
                }
                return messageProducer;
            }
        }
        catch (JMSException ex) {
            throw new JMSRuntimeException(ex.getMessage(), ex.getErrorCode(), (Throwable)ex);
        }
    }

    private void checkPropertyName(String name) {
        if (name == null || name.length() == 0) {
            throw new JMSRuntimeException("Invalid property name: " + name);
        }
    }

    public JMSProducer clearProperties() {
        this.properties.clear();
        return this;
    }

    public CompletionListener getAsync() {
        return this.completionListener;
    }

    public boolean getBooleanProperty(String name) {
        this.checkPropertyName(name);
        return (Boolean)this.properties.get(name);
    }

    public byte getByteProperty(String name) {
        this.checkPropertyName(name);
        return (Byte)this.properties.get(name);
    }

    public long getDeliveryDelay() {
        return this.deliverDelay;
    }

    public int getDeliveryMode() {
        return this.deliveryMode;
    }

    public boolean getDisableMessageID() {
        return this.disableMessageID;
    }

    public boolean getDisableMessageTimestamp() {
        return this.disableMessageTimestamp;
    }

    public double getDoubleProperty(String name) {
        this.checkPropertyName(name);
        return (Double)this.properties.get(name);
    }

    public float getFloatProperty(String name) {
        this.checkPropertyName(name);
        return ((Float)this.properties.get(name)).floatValue();
    }

    public int getIntProperty(String name) {
        this.checkPropertyName(name);
        return (Integer)this.properties.get(name);
    }

    public String getJMSCorrelationID() {
        return this.jmsCorrelationID;
    }

    public byte[] getJMSCorrelationIDAsBytes() {
        return this.jmsCorrelationID.getBytes();
    }

    public Destination getJMSReplyTo() {
        return this.jmsReplyTo;
    }

    public String getJMSType() {
        return this.jmsType;
    }

    public long getLongProperty(String name) {
        this.checkPropertyName(name);
        return (Long)this.properties.get(name);
    }

    public Object getObjectProperty(String name) {
        this.checkPropertyName(name);
        return this.properties.get(name);
    }

    public int getPriority() {
        return this.priority;
    }

    public Set<String> getPropertyNames() {
        return this.properties.keySet();
    }

    public short getShortProperty(String name) {
        this.checkPropertyName(name);
        return (Short)this.properties.get(name);
    }

    public String getStringProperty(String name) {
        this.checkPropertyName(name);
        return (String)this.properties.get(name);
    }

    public long getTimeToLive() {
        return this.timeToLive;
    }

    public boolean propertyExists(String name) {
        this.checkPropertyName(name);
        return this.properties.containsKey(name);
    }

    public JMSProducer send(Destination destination, Message message) {
        if (message == null) {
            throw new MessageFormatRuntimeException("Cannot send null messages.");
        }
        try {
            if (this.jmsCorrelationID != null) {
                message.setJMSCorrelationID(this.jmsCorrelationID);
            }
            if (this.jmsCorrelationID != null && this.jmsCorrelationID.length() > 0) {
                message.setJMSCorrelationID(this.jmsCorrelationID);
            }
            if (this.jmsReplyTo != null) {
                message.setJMSReplyTo(this.jmsReplyTo);
            }
            if (this.jmsType != null) {
                message.setJMSType(this.jmsType);
            }
            MessageProducer messageProducer = this.getMessageProducer(destination);
            if (this.deliverDelay != null) {
                messageProducer.setDeliveryDelay(this.deliverDelay.longValue());
            }
            if (this.deliveryMode != null) {
                messageProducer.setDeliveryMode(this.deliveryMode.intValue());
            }
            if (this.disableMessageID != null) {
                messageProducer.setDisableMessageID(this.disableMessageID.booleanValue());
            }
            if (this.disableMessageTimestamp != null) {
                messageProducer.setDisableMessageTimestamp(this.disableMessageTimestamp.booleanValue());
            }
            if (this.priority != null) {
                messageProducer.setPriority(this.priority.intValue());
            }
            if (this.timeToLive != null) {
                messageProducer.setTimeToLive(this.timeToLive.longValue());
            }
            for (String name : this.properties.keySet()) {
                message.setObjectProperty(name, this.properties.get(name));
            }
            if (this.completionListener != null) {
                messageProducer.send(destination, message, this.completionListener);
            } else {
                messageProducer.send(destination, message);
            }
        }
        catch (JMSException ex) {
            throw new JMSRuntimeException(ex.getMessage(), ex.getErrorCode(), (Throwable)ex);
        }
        return this;
    }

    public JMSProducer send(Destination destination, String body) {
        TextMessage message = this.context.createTextMessage(body);
        this.send(destination, (Message)message);
        return this;
    }

    public JMSProducer send(Destination destination, Map<String, Object> body) {
        MapMessage message = this.context.createMapMessage();
        try {
            if (body != null) {
                for (String name : body.keySet()) {
                    message.setObjectProperty(name, body.get(name));
                }
            }
            this.send(destination, (Message)message);
            return this;
        }
        catch (JMSException ex) {
            throw new JMSRuntimeException(ex.getMessage(), ex.getErrorCode(), (Throwable)ex);
        }
    }

    public JMSProducer send(Destination destination, byte[] body) {
        BytesMessage message = this.context.createBytesMessage();
        try {
            if (body != null) {
                message.writeBytes(body);
            }
            this.send(destination, (Message)message);
            return this;
        }
        catch (JMSException ex) {
            throw new JMSRuntimeException(ex.getMessage(), ex.getErrorCode(), (Throwable)ex);
        }
    }

    public JMSProducer send(Destination destination, Serializable body) {
        ObjectMessage message = this.context.createObjectMessage();
        try {
            if (body != null) {
                message.setObject(body);
            }
            this.send(destination, (Message)message);
            return this;
        }
        catch (JMSException ex) {
            throw new JMSRuntimeException(ex.getMessage(), ex.getErrorCode(), (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JMSProducer setAsync(CompletionListener completionListener) {
        ZmqJMSProducer zmqJMSProducer = this;
        synchronized (zmqJMSProducer) {
            this.completionListener = completionListener;
        }
        return this;
    }

    public JMSProducer setDeliveryDelay(long deliveryDelay) {
        this.deliverDelay = deliveryDelay;
        return this;
    }

    public JMSProducer setDeliveryMode(int deliveryMode) {
        this.deliveryMode = deliveryMode;
        return this;
    }

    public JMSProducer setDisableMessageID(boolean value) {
        this.disableMessageID = value;
        return this;
    }

    public JMSProducer setDisableMessageTimestamp(boolean value) {
        this.disableMessageTimestamp = value;
        return this;
    }

    public JMSProducer setJMSCorrelationID(String jmsCorrectionId) {
        this.jmsCorrelationID = jmsCorrectionId;
        return this;
    }

    public JMSProducer setJMSCorrelationIDAsBytes(byte[] jmsCorrectionId) {
        this.jmsCorrelationID = new String(jmsCorrectionId);
        return this;
    }

    public JMSProducer setJMSReplyTo(Destination jmsReplyTo) {
        this.jmsReplyTo = jmsReplyTo;
        return this;
    }

    public JMSProducer setJMSType(String jmsType) {
        this.jmsType = jmsType;
        return this;
    }

    public JMSProducer setPriority(int priority) {
        this.priority = priority;
        return this;
    }

    public JMSProducer setProperty(String name, boolean value) {
        this.properties.put(name, value);
        return this;
    }

    public JMSProducer setProperty(String name, byte value) {
        this.properties.put(name, value);
        return this;
    }

    public JMSProducer setProperty(String name, short value) {
        this.properties.put(name, value);
        return this;
    }

    public JMSProducer setProperty(String name, int value) {
        this.properties.put(name, value);
        return this;
    }

    public JMSProducer setProperty(String name, long value) {
        this.properties.put(name, value);
        return this;
    }

    public JMSProducer setProperty(String name, float value) {
        this.properties.put(name, Float.valueOf(value));
        return this;
    }

    public JMSProducer setProperty(String name, double value) {
        this.properties.put(name, value);
        return this;
    }

    public JMSProducer setProperty(String name, String value) {
        this.properties.put(name, value);
        return this;
    }

    public JMSProducer setProperty(String name, Object value) {
        this.properties.put(name, value);
        return this;
    }

    public JMSProducer setTimeToLive(long timeToLive) {
        this.timeToLive = timeToLive;
        return this;
    }
}

