/*
 * Decompiled with CFR 0.152.
 */
package org.zeromq.jms;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;

public class ZmqMessage
implements Message,
Externalizable {
    private final Map<String, Object> properties = new HashMap<String, Object>();
    private String correlationID;
    private int deliveryMode;
    private Destination destrination;
    private long expiration;
    private String messageID;
    private int priority;
    private boolean redelivered;
    private Destination replyTo;
    private long timestamp;
    private String type;
    private long deliveryTime;

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void acknowledge() throws JMSException {
        throw new UnsupportedOperationException();
    }

    public void clearBody() throws JMSException {
        throw new UnsupportedOperationException();
    }

    public void clearProperties() throws JMSException {
        this.properties.clear();
    }

    public boolean getBooleanProperty(String name) throws JMSException {
        return (Boolean)this.properties.get(name);
    }

    public byte getByteProperty(String name) throws JMSException {
        return (Byte)this.properties.get(name);
    }

    public double getDoubleProperty(String name) throws JMSException {
        return (Double)this.properties.get(name);
    }

    public float getFloatProperty(String name) throws JMSException {
        return ((Float)this.properties.get(name)).floatValue();
    }

    public int getIntProperty(String name) throws JMSException {
        return (Integer)this.properties.get(name);
    }

    public String getJMSCorrelationID() throws JMSException {
        return this.correlationID;
    }

    public byte[] getJMSCorrelationIDAsBytes() throws JMSException {
        if (this.correlationID == null) {
            return null;
        }
        return this.correlationID.getBytes();
    }

    public int getJMSDeliveryMode() throws JMSException {
        return this.deliveryMode;
    }

    public Destination getJMSDestination() throws JMSException {
        return this.destrination;
    }

    public long getJMSExpiration() throws JMSException {
        return this.expiration;
    }

    public String getJMSMessageID() throws JMSException {
        return this.messageID;
    }

    public int getJMSPriority() throws JMSException {
        return this.priority;
    }

    public boolean getJMSRedelivered() throws JMSException {
        return this.redelivered;
    }

    public Destination getJMSReplyTo() throws JMSException {
        return this.replyTo;
    }

    public long getJMSTimestamp() throws JMSException {
        return this.timestamp;
    }

    public String getJMSType() throws JMSException {
        return this.type;
    }

    public long getLongProperty(String name) throws JMSException {
        return (Long)this.properties.get(name);
    }

    public Object getObjectProperty(String name) throws JMSException {
        return this.properties.get(name);
    }

    public Enumeration<String> getPropertyNames() throws JMSException {
        Vector<String> names = new Vector<String>(this.properties.keySet());
        return names.elements();
    }

    public short getShortProperty(String name) throws JMSException {
        return (Short)this.properties.get(name);
    }

    public String getStringProperty(String name) throws JMSException {
        return (String)this.properties.get(name);
    }

    public boolean propertyExists(String name) throws JMSException {
        return this.properties.containsKey(name);
    }

    public void setBooleanProperty(String name, boolean value) throws JMSException {
        this.properties.put(name, value);
    }

    public void setByteProperty(String name, byte value) throws JMSException {
        this.properties.put(name, value);
    }

    public void setDoubleProperty(String name, double value) throws JMSException {
        this.properties.put(name, value);
    }

    public void setFloatProperty(String name, float value) throws JMSException {
        this.properties.put(name, Float.valueOf(value));
    }

    public void setIntProperty(String name, int value) throws JMSException {
        this.properties.put(name, value);
    }

    public void setJMSCorrelationID(String correlationID) throws JMSException {
        this.correlationID = correlationID;
    }

    public void setJMSCorrelationIDAsBytes(byte[] correlationIDAsBytes) throws JMSException {
        this.correlationID = new String(correlationIDAsBytes);
    }

    public void setJMSDeliveryMode(int deliveryMode) throws JMSException {
        this.deliveryMode = deliveryMode;
    }

    public void setJMSDestination(Destination destrination) throws JMSException {
        this.destrination = destrination;
    }

    public void setJMSExpiration(long expiration) throws JMSException {
        this.expiration = expiration;
    }

    public void setJMSMessageID(String messageID) throws JMSException {
        this.messageID = messageID;
    }

    public void setJMSPriority(int priority) throws JMSException {
        this.priority = priority;
    }

    public void setJMSRedelivered(boolean redelivered) throws JMSException {
        this.redelivered = redelivered;
    }

    public void setJMSReplyTo(Destination replyTo) throws JMSException {
        this.replyTo = replyTo;
    }

    public void setJMSTimestamp(long timestamp) throws JMSException {
        this.timestamp = timestamp;
    }

    public void setJMSType(String type) throws JMSException {
        this.type = type;
    }

    public long getJMSDeliveryTime() throws JMSException {
        return this.deliveryTime;
    }

    public void setJMSDeliveryTime(long deliveryTime) throws JMSException {
        this.deliveryTime = deliveryTime;
    }

    public void setLongProperty(String name, long value) throws JMSException {
        this.properties.put(name, value);
    }

    public void setObjectProperty(String name, Object value) throws JMSException {
        this.properties.put(name, value);
    }

    public void setShortProperty(String name, short value) throws JMSException {
        this.properties.put(name, value);
    }

    public void setStringProperty(String name, String value) throws JMSException {
        this.properties.put(name, value);
    }

    public <T> T getBody(Class<T> c) throws JMSException {
        return null;
    }

    public boolean isBodyAssignableTo(Class c) throws JMSException {
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.messageID == null ? 0 : this.messageID.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ZmqMessage other = (ZmqMessage)obj;
        return !(this.messageID == null ? other.messageID != null : !this.messageID.equals(other.messageID));
    }

    public String toString() {
        return "ZmqMessage [properties=" + this.properties + ", correlationID=" + this.correlationID + ", deliveryMode=" + this.deliveryMode + ", destrination=" + this.destrination + ", expiration=" + this.expiration + ", messageID=" + this.messageID + ", priority=" + this.priority + ", redelivered=" + this.redelivered + ", timestamp=" + this.timestamp + ", type=" + this.type + ", deliveryTime=" + this.deliveryTime + "]";
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.correlationID);
        out.writeInt(this.deliveryMode);
        out.writeObject(this.destrination);
        out.writeLong(this.expiration);
        out.writeObject(this.messageID);
        out.writeInt(this.priority);
        out.writeBoolean(this.redelivered);
        out.writeObject(this.replyTo);
        out.writeLong(this.timestamp);
        out.writeObject(this.type);
        out.writeLong(this.deliveryTime);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.correlationID = (String)in.readObject();
        this.deliveryMode = in.readInt();
        this.destrination = (Destination)in.readObject();
        this.expiration = in.readLong();
        this.messageID = (String)in.readObject();
        this.priority = in.readInt();
        this.redelivered = in.readBoolean();
        this.replyTo = (Destination)in.readObject();
        this.timestamp = in.readLong();
        this.type = (String)in.readObject();
        this.deliveryTime = in.readLong();
    }
}

