/*
 * Decompiled with CFR 0.152.
 */
package org.zeromq.jms;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.StreamMessage;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.management.ObjectName;
import org.zeromq.jms.ZmqException;
import org.zeromq.jms.ZmqQueue;
import org.zeromq.jms.ZmqQueueReciever;
import org.zeromq.jms.ZmqQueueSender;
import org.zeromq.jms.ZmqTextMessage;
import org.zeromq.jms.ZmqTopic;
import org.zeromq.jms.ZmqTopicPublisher;
import org.zeromq.jms.ZmqTopicSubscriber;
import org.zeromq.jms.ZmqURI;
import org.zeromq.jms.jmx.ZmqMBeanUtils;
import org.zeromq.jms.protocol.ZmqGateway;
import org.zeromq.jms.protocol.ZmqGatewayFactory;
import org.zeromq.jms.protocol.ZmqSocketType;

public class ZmqSession
implements QueueSession,
TopicSession {
    private static final Logger LOGGER = Logger.getLogger(ZmqSession.class.getCanonicalName());
    private final Map<String, ZmqURI> destinationSchema;
    private final boolean transacted;
    private final int acknowledgeMode;
    private final ExceptionListener exceptionHandler;
    private final List<ZmqGateway> gateways = new ArrayList<ZmqGateway>();
    private static AtomicInteger gatewayProducerCount = new AtomicInteger(0);
    private static AtomicInteger gatewayConsumerCount = new AtomicInteger(0);
    private final ZmqGatewayFactory gatewayFactory;
    private final List<ObjectName> mbeanNames = new ArrayList<ObjectName>();

    ZmqSession(ZmqGatewayFactory gatewayFactory, Map<String, ZmqURI> destinationSchema, boolean transacted, int acknowledgeMode, ExceptionListener exceptionHandler) {
        this.destinationSchema = destinationSchema;
        this.transacted = transacted;
        this.acknowledgeMode = acknowledgeMode;
        this.exceptionHandler = exceptionHandler;
        this.gatewayFactory = gatewayFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void open(ZmqGateway gateway) throws JMSException {
        try {
            gateway.open(-1);
            List<ObjectName> objectNames = ZmqMBeanUtils.register(gateway);
            List<Object> list = this.mbeanNames;
            synchronized (list) {
                this.mbeanNames.addAll(objectNames);
            }
            list = this.gateways;
            synchronized (list) {
                this.gateways.add(gateway);
            }
        }
        catch (RuntimeException ex) {
            LOGGER.log(Level.SEVERE, "Unable to open to ZMQ gateway: " + gateway, ex);
            throw new ZmqException("Unable to open to ZMQ gateway: " + gateway, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws JMSException {
        List<ZmqGateway> list = this.gateways;
        synchronized (list) {
            for (ZmqGateway gateway : this.gateways) {
                if (!gateway.isActive()) continue;
                gateway.close(-1);
            }
            this.gateways.clear();
        }
        for (ObjectName objectName : this.mbeanNames) {
            ZmqMBeanUtils.unregister(objectName);
        }
        this.mbeanNames.clear();
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "Session closed: " + this, new Exception("Closing stack"));
        } else {
            LOGGER.info("Session closed: " + this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws JMSException {
        if (this.transacted) {
            try {
                List<ZmqGateway> list = this.gateways;
                synchronized (list) {
                    for (ZmqGateway gateway : this.gateways) {
                        gateway.commit();
                    }
                }
            }
            catch (ZmqException ex) {
                throw new ZmqException("Unable to commit messages.", (Exception)((Object)ex));
            }
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("Commited messages");
            }
        } else {
            throw new ZmqException("Session was not enabled for transactions.");
        }
        LOGGER.info("Session committed");
    }

    public BytesMessage createBytesMessage() throws JMSException {
        throw new UnsupportedOperationException();
    }

    public MessageProducer createProducer(Destination destination) throws JMSException {
        if (destination instanceof Topic) {
            TopicPublisher producer = this.createPublisher((Topic)destination);
            return producer;
        }
        QueueSender producer = this.createSender((Queue)destination);
        return producer;
    }

    public MessageConsumer createConsumer(Destination destination) throws JMSException {
        MessageConsumer consumer = this.createConsumer(destination, null, false);
        return consumer;
    }

    public MessageConsumer createConsumer(Destination destination, String messageSelector) throws JMSException {
        MessageConsumer consumer = this.createConsumer(destination, messageSelector, false);
        return consumer;
    }

    public MessageConsumer createConsumer(Destination destination, String messageSelector, boolean noLocal) throws JMSException {
        if (destination instanceof Topic) {
            TopicSubscriber consumer = this.createSubscriber((Topic)destination, messageSelector, noLocal);
            return consumer;
        }
        QueueReceiver consumer = this.createReceiver((Queue)destination, messageSelector);
        return consumer;
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name) throws JMSException {
        throw new UnsupportedOperationException();
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name, String messageSelector, boolean noLocal) throws JMSException {
        throw new UnsupportedOperationException();
    }

    public MapMessage createMapMessage() throws JMSException {
        throw new UnsupportedOperationException();
    }

    public Message createMessage() throws JMSException {
        throw new UnsupportedOperationException();
    }

    public ObjectMessage createObjectMessage() throws JMSException {
        throw new UnsupportedOperationException();
    }

    public ObjectMessage createObjectMessage(Serializable object) throws JMSException {
        throw new UnsupportedOperationException();
    }

    public StreamMessage createStreamMessage() throws JMSException {
        throw new UnsupportedOperationException();
    }

    public TemporaryTopic createTemporaryTopic() throws JMSException {
        throw new UnsupportedOperationException();
    }

    public TextMessage createTextMessage() throws JMSException {
        ZmqTextMessage message = new ZmqTextMessage();
        return message;
    }

    public TextMessage createTextMessage(String text) throws JMSException {
        TextMessage message = this.createTextMessage();
        message.setText(text);
        return message;
    }

    public Topic createTopic(String topicName) throws JMSException {
        ZmqURI uri;
        String destinationName = topicName;
        if (topicName.startsWith("jms:topic")) {
            uri = ZmqURI.create(topicName);
            destinationName = uri.getDestinationName();
            if (this.destinationSchema.containsKey(destinationName)) {
                LOGGER.warning("Creating topic with URI already exists in scheam: " + uri);
            } else {
                this.destinationSchema.put(destinationName, uri);
            }
        }
        if (!this.destinationSchema.containsKey(destinationName)) {
            throw new ZmqException("Unable to resolve topic within schema store for name: " + destinationName);
        }
        uri = this.destinationSchema.get(destinationName);
        String addr = uri.getOptionValue("socket.addr", null);
        if (addr == null) {
            addr = uri.getOptionValue("gateway.addr", null);
        }
        if (addr == null) {
            throw new ZmqException("Unable to resolve 'socket.addr' or 'gateway.addr' for queue URI: " + uri);
        }
        ZmqTopic topic = new ZmqTopic(uri);
        return topic;
    }

    public int getAcknowledgeMode() throws JMSException {
        return this.acknowledgeMode;
    }

    public MessageListener getMessageListener() throws JMSException {
        throw new UnsupportedOperationException();
    }

    public boolean getTransacted() throws JMSException {
        return this.transacted;
    }

    public void recover() throws JMSException {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws JMSException {
        if (this.transacted) {
            try {
                List<ZmqGateway> list = this.gateways;
                synchronized (list) {
                    for (ZmqGateway gateway : this.gateways) {
                        gateway.rollback();
                    }
                }
            }
            catch (ZmqException ex) {
                throw new ZmqException("Unable to rollback messages", (Exception)((Object)ex));
            }
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("rollback messages");
            }
        } else {
            throw new ZmqException("Session was not enabled for transactions.");
        }
        LOGGER.info("Session rolled back");
    }

    public void run() {
        throw new UnsupportedOperationException();
    }

    public void setMessageListener(MessageListener listener) throws JMSException {
        throw new UnsupportedOperationException();
    }

    public void unsubscribe(String name) throws JMSException {
        throw new UnsupportedOperationException();
    }

    public QueueBrowser createBrowser(Queue queue) throws JMSException {
        throw new UnsupportedOperationException();
    }

    public QueueBrowser createBrowser(Queue queue, String messageSelector) throws JMSException {
        throw new UnsupportedOperationException();
    }

    public Queue createQueue(String queueName) throws JMSException {
        ZmqURI uri;
        String destinationName = queueName;
        if (queueName.startsWith("jms:queue")) {
            uri = ZmqURI.create(queueName);
            destinationName = uri.getDestinationName();
            if (this.destinationSchema.containsKey(destinationName)) {
                LOGGER.warning("Creating queue with URI already exists in scheam: " + uri);
            } else {
                this.destinationSchema.put(destinationName, uri);
            }
        }
        if (!this.destinationSchema.containsKey(destinationName)) {
            throw new ZmqException("Unable to resolve queue within schema store for name: " + destinationName);
        }
        uri = this.destinationSchema.get(destinationName);
        String addr = uri.getOptionValue("socket.addr", null);
        if (addr == null) {
            addr = uri.getOptionValue("gateway.addr", null);
        }
        if (addr == null) {
            throw new ZmqException("Unable to resolve 'socket.addr' or 'gateway.addr' for queue URI: " + uri);
        }
        ZmqQueue queue = new ZmqQueue(queueName);
        return queue;
    }

    public TemporaryQueue createTemporaryQueue() throws JMSException {
        throw new UnsupportedOperationException();
    }

    public QueueReceiver createReceiver(Queue queue) throws JMSException {
        return this.createReceiver(queue, null);
    }

    public QueueReceiver createReceiver(Queue queue, String messageSelector) throws JMSException {
        ZmqQueue zmqQueue = (ZmqQueue)queue;
        boolean transacted = this.getTransacted();
        String prefixName = "receiver-" + gatewayConsumerCount.incrementAndGet();
        ZmqGateway gateway = this.gatewayFactory.newConsumerGateway(prefixName, zmqQueue, ZmqSocketType.PULL, true, messageSelector, transacted);
        this.open(gateway);
        ZmqQueueReciever reciever = new ZmqQueueReciever(gateway, (Destination)queue, messageSelector, this.exceptionHandler);
        LOGGER.info("Created recevier: " + reciever);
        return reciever;
    }

    public QueueSender createSender(Queue queue) throws JMSException {
        ZmqQueue zmqQueue = (ZmqQueue)queue;
        boolean transacted = this.getTransacted();
        String prefixName = "sender-" + gatewayProducerCount.incrementAndGet();
        ZmqGateway gateway = this.gatewayFactory.newProducerGateway(prefixName, zmqQueue, ZmqSocketType.PUSH, false, transacted);
        this.open(gateway);
        ZmqQueueSender sender = new ZmqQueueSender(gateway, queue);
        LOGGER.info("Created sender: " + sender);
        return sender;
    }

    public TopicPublisher createPublisher(Topic topic) throws JMSException {
        ZmqTopic zmqTopic = (ZmqTopic)topic;
        boolean transacted = this.getTransacted();
        String prefixName = "publisher-" + gatewayProducerCount.incrementAndGet();
        ZmqGateway gateway = this.gatewayFactory.newProducerGateway(prefixName, zmqTopic, ZmqSocketType.PUB, true, transacted);
        this.open(gateway);
        ZmqTopicPublisher publisher = new ZmqTopicPublisher(gateway, topic);
        LOGGER.info("Created publisher: " + publisher);
        return publisher;
    }

    public TopicSubscriber createSubscriber(Topic topic) throws JMSException {
        TopicSubscriber subscriber = this.createSubscriber(topic, null, false);
        return subscriber;
    }

    public TopicSubscriber createSubscriber(Topic topic, String messageSelector, boolean noLocal) throws JMSException {
        ZmqTopic zmqTopic = (ZmqTopic)topic;
        boolean transacted = this.getTransacted();
        String prefixName = "subscriber-" + gatewayConsumerCount.incrementAndGet();
        ZmqGateway gateway = this.gatewayFactory.newConsumerGateway(prefixName, zmqTopic, ZmqSocketType.SUB, false, messageSelector, transacted);
        this.open(gateway);
        ZmqTopicSubscriber subscriber = new ZmqTopicSubscriber(gateway, (Destination)topic, messageSelector, noLocal, this.exceptionHandler);
        LOGGER.info("Created subscriber: " + subscriber);
        return subscriber;
    }

    public MessageConsumer createDurableConsumer(Topic topic, String name) throws JMSException {
        throw new UnsupportedOperationException();
    }

    public MessageConsumer createDurableConsumer(Topic topic, String name, String messageSelector, boolean noLocal) throws JMSException {
        throw new UnsupportedOperationException();
    }

    public MessageConsumer createSharedConsumer(Topic topic, String sharedSubscriptionName) throws JMSException {
        throw new UnsupportedOperationException();
    }

    public MessageConsumer createSharedConsumer(Topic topic, String sharedSubscriptionName, String messageSelector) throws JMSException {
        throw new UnsupportedOperationException();
    }

    public MessageConsumer createSharedDurableConsumer(Topic topic, String name) throws JMSException {
        throw new UnsupportedOperationException();
    }

    public MessageConsumer createSharedDurableConsumer(Topic topic, String name, String messageSelector) throws JMSException {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return "ZmqSession [destinationSchema=" + this.destinationSchema + ", transacted=" + this.transacted + ", acknowledgeMode=" + this.acknowledgeMode + ", gateways=" + this.gateways + "]";
    }
}

