/*
 * Decompiled with CFR 0.152.
 */
package org.zeromq.jms;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ZmqURI
implements Externalizable {
    private static final String TOKENISE_REGX = "(tcp://(\\*|((\\w+|\\.)+)):\\d+)|(inproc://\\w+)|(\\w|\\.)+|:|\\?|=|,|\\&";
    private String str;
    private String scheme;
    private String destinationType;
    private String destinationName;
    private Map<String, List<String>> options;

    public ZmqURI() {
    }

    protected ZmqURI(String str, String scheme, String destinationType, String destinationName, Map<String, List<String>> options) {
        this.str = str;
        this.scheme = scheme;
        this.destinationType = destinationType;
        this.destinationName = destinationName;
        this.options = options;
    }

    public static ZmqURI create(String str) throws IllegalArgumentException {
        try {
            ZmqURI uri = ZmqURI.parse(str);
            return uri;
        }
        catch (ParseException ex) {
            throw new IllegalArgumentException("URI string cannot be parse: " + str, ex);
        }
    }

    private static String parseValue(String regex, int index, List<Token> tokens) throws ParseException {
        int pos = 0;
        if (index - 1 >= 0) {
            Token prevToken = tokens.get(index - 1);
            pos = prevToken.pos + prevToken.value.length();
        }
        if (index >= tokens.size()) {
            throw new ParseException("Missing expecting value:" + regex, pos);
        }
        String value = tokens.get(index).value;
        Pattern pattern = Pattern.compile(regex, 2);
        if (!pattern.matcher(value).matches()) {
            throw new ParseException("Invalid value [" + value + "] at position " + pos + " for pattern [" + regex + "]", pos);
        }
        return value;
    }

    private static ZmqURI parse(String str) throws ParseException {
        Pattern pattern = Pattern.compile(TOKENISE_REGX, 2);
        Matcher matcher = pattern.matcher(str);
        ArrayList<Token> tokens = new ArrayList<Token>();
        int start = 0;
        while (matcher.find(start)) {
            String token = matcher.group();
            tokens.add(new Token(token, start));
            start = matcher.end();
        }
        int index = 0;
        String scheme = ZmqURI.parseValue("jms", index++, tokens);
        ZmqURI.parseValue(":", index++, tokens);
        String destinationType = ZmqURI.parseValue("(queue|topic)", index++, tokens);
        ZmqURI.parseValue(":", index++, tokens);
        String destinationName = ZmqURI.parseValue("\\w+", index++, tokens);
        HashMap options = new HashMap();
        if (tokens.size() > index) {
            ZmqURI.parseValue("\\?", index++, tokens);
            int i = index;
            while (i < tokens.size()) {
                String optionName = ZmqURI.parseValue("(\\w|\\.)+", i, tokens);
                if (optionName == null || optionName.length() == 0 || optionName.startsWith("socket") && optionName.indexOf(46) <= 0) {
                    Token token = (Token)tokens.get(i);
                    throw new ParseException("Invalid tokattribute name [" + optionName + "] within token: " + token, token.pos);
                }
                String optionValue = null;
                ZmqURI.parseValue("=", ++i, tokens);
                boolean nextOptionValue = true;
                while (nextOptionValue) {
                    if (tokens.size() > i + 1 && !((Token)tokens.get(i + 1)).hasValue("\\&")) {
                        optionValue = ZmqURI.parseValue(".*", ++i, tokens);
                    }
                    if (!options.containsKey(optionName)) {
                        options.put(optionName, new ArrayList());
                    }
                    List optionValues = (List)options.get(optionName);
                    optionValues.add(optionValue);
                    boolean bl = nextOptionValue = tokens.size() > i + 1 && ((Token)tokens.get(i + 1)).hasValue(",");
                    if (!nextOptionValue) continue;
                    ++i;
                }
                if (tokens.size() > i + 1) {
                    ZmqURI.parseValue("\\&", ++i, tokens);
                }
                ++i;
            }
        }
        ZmqURI uri = new ZmqURI(str, scheme, destinationType, destinationName, Collections.unmodifiableMap(options));
        return uri;
    }

    protected String getStr() {
        return this.str;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getDestinationType() {
        return this.destinationType;
    }

    public String getDestinationName() {
        return this.destinationName;
    }

    public boolean isOption(String paramName) {
        return this.options.containsKey(paramName);
    }

    public Map<String, List<String>> getOptions() {
        return this.options;
    }

    public Map<String, List<String>> getOptions(String prefix) {
        HashMap<String, List<String>> selectedOptions = new HashMap<String, List<String>>();
        for (String name : this.options.keySet()) {
            if (!name.startsWith(prefix)) continue;
            List<String> value = this.options.get(name);
            selectedOptions.put(name, value);
        }
        return selectedOptions;
    }

    public String[] getOptionValues(String paramName) {
        List<String> values = this.options.get(paramName);
        if (values == null) {
            return null;
        }
        return values.toArray(new String[0]);
    }

    public String[] getOptionValues(String paramName, String[] defaultValues) {
        String[] values = this.getOptionValues(paramName);
        if (values == null) {
            return defaultValues;
        }
        return values;
    }

    public String getOptionValue(String paramName) {
        String[] values = this.getOptionValues(paramName);
        if (values == null || values.length == 0) {
            return null;
        }
        return values[0];
    }

    public String getOptionValue(String paramName, String defaultValue) {
        String[] values = this.getOptionValues(paramName);
        if (values == null || values.length == 0) {
            return defaultValue;
        }
        return values[0];
    }

    public boolean getOptionValue(String paramName, boolean defaultValue) {
        String[] values = this.getOptionValues(paramName);
        if (values == null || values.length == 0) {
            return defaultValue;
        }
        return Boolean.parseBoolean(values[0]);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.destinationName == null ? 0 : this.destinationName.hashCode());
        result = 31 * result + (this.str == null ? 0 : this.str.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ZmqURI other = (ZmqURI)obj;
        if (this.destinationName == null ? other.destinationName != null : !this.destinationName.equals(other.destinationName)) {
            return false;
        }
        return !(this.str == null ? other.str != null : !this.str.equals(other.str));
    }

    public String toString() {
        return "ZmqURI [str=" + this.str + "]";
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.str);
        out.writeObject(this.scheme);
        out.writeObject(this.destinationType);
        out.writeObject(this.destinationName);
        out.writeInt(this.options.size());
        for (String name : this.options.keySet()) {
            List<String> values = this.options.get(name);
            out.writeInt(values.size());
            for (String value : values) {
                out.writeObject(value);
            }
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.str = (String)in.readObject();
        this.scheme = (String)in.readObject();
        this.destinationType = (String)in.readObject();
        this.destinationName = (String)in.readObject();
        this.options = new HashMap<String, List<String>>();
        int optionCount = in.readInt();
        int i = 0;
        while (i < optionCount) {
            String optionName = (String)in.readObject();
            int valueCount = in.readInt();
            if (!this.options.containsKey(optionName)) {
                this.options.put(optionName, new ArrayList());
            }
            List<String> optionValues = this.options.get(optionName);
            int j = 0;
            while (j < valueCount) {
                String optionValue = (String)in.readObject();
                optionValues.add(optionValue);
                ++j;
            }
            ++i;
        }
    }

    private static final class Token {
        private final String value;
        private final int pos;

        private Token(String value, int pos) {
            this.value = value;
            this.pos = pos;
        }

        private boolean hasValue(String value) {
            return this.value.equals(value);
        }

        public String toString() {
            return "Token [value=" + this.value + ", pos=" + this.pos + "]";
        }
    }
}

