/*
 * Decompiled with CFR 0.152.
 */
package org.zeromq.jms.jconsole;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.text.DateFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableCellRenderer;
import org.zeromq.jms.jconsole.ZmqMonitorTableModel;
import org.zeromq.jms.jmx.ZmqGatewayManagerMBean;
import org.zeromq.jms.jmx.ZmqMBeanUtils;
import org.zeromq.jms.jmx.ZmqMetricsMBean;
import org.zeromq.jms.jmx.ZmqSocketStatisticsMBean;

public class ZmqMonitorTable
extends JPanel {
    private static final long serialVersionUID = 3865700192774656355L;
    private final ZmqMonitorTableModel model = new ZmqMonitorTableModel();
    private MBeanServerConnection mbConnection;

    public ZmqMonitorTable() {
        JLabel label = new JLabel("Gateway/Sockets", 0);
        JTable table = new JTable(this.model);
        int i = 0;
        while (i < table.getColumnModel().getColumnCount()) {
            DefaultTableCellRenderer cellRenderer;
            String columnName = ZmqMonitorTableModel.COLUMN_NAMES[i];
            Format columnFormat = ZmqMonitorTableModel.COLUMN_FORMATS[i];
            if ("Name".equals(columnName)) {
                cellRenderer = new TrafficLightRender();
                table.getColumnModel().getColumn(i).setCellRenderer(cellRenderer);
            } else if (columnFormat != null) {
                cellRenderer = new FormatRenderer(columnFormat);
                table.getColumnModel().getColumn(i).setCellRenderer(cellRenderer);
                if (columnFormat instanceof DateFormat) {
                    String value = columnFormat.format(new Date());
                    Component cell = cellRenderer.getTableCellRendererComponent(table, value, false, false, 0, i);
                    int width = cell.getPreferredSize().width + table.getIntercellSpacing().width;
                    table.getColumnModel().getColumn(i).setMinWidth(width);
                }
            }
            ++i;
        }
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.getViewport().add(table);
        JButton button = new JButton("Refresh");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ZmqMonitorTable.this.initComponents();
            }
        });
        JPanel content = new JPanel(new BorderLayout());
        content.add((Component)label, "First");
        content.add((Component)scrollPane, "Center");
        content.add((Component)button, "Last");
        this.add(content);
        this.setVisible(true);
    }

    public void setConnection(MBeanServerConnection connection) {
        this.mbConnection = connection;
    }

    public void initComponents() {
        try {
            List<ZmqMetricsMBean> rows = this.getMonitorTableRows(this.mbConnection);
            this.model.setRow(rows);
            this.model.fireTableDataChanged();
        }
        catch (IOException | MalformedObjectNameException ex) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JOptionPane.showMessageDialog(ZmqMonitorTable.this, "Cannot access the ZMQ MXBean in the target VM: " + ex.getMessage(), "ZmqMonitorTable", 0);
                }
            });
        }
    }

    private List<ZmqMetricsMBean> getMonitorTableRows(MBeanServerConnection mbConnection) throws IOException, MalformedObjectNameException {
        ArrayList<ZmqMetricsMBean> rows = new ArrayList<ZmqMetricsMBean>();
        List<ZmqGatewayManagerMBean> gatewayMBeanList = ZmqMBeanUtils.getGatewayManagerMBeans(mbConnection);
        for (ZmqGatewayManagerMBean gatewayMBean : gatewayMBeanList) {
            rows.add(gatewayMBean);
            String gatewayName = gatewayMBean.getName();
            List<ZmqSocketStatisticsMBean> socketMBeanList = ZmqMBeanUtils.getSocketStatisticsMBeans(mbConnection, gatewayName);
            for (ZmqSocketStatisticsMBean socketMBean : socketMBeanList) {
                rows.add(socketMBean);
            }
        }
        return rows;
    }

    private static class FormatRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = -415071752821954019L;
        private final Format format;

        FormatRenderer(Format format) {
            this.format = format;
            if (format instanceof NumberFormat) {
                this.setHorizontalAlignment(4);
            } else if (format instanceof DateFormat) {
                this.setHorizontalAlignment(0);
            }
        }

        @Override
        public void setValue(Object value) {
            Object formattedValue;
            try {
                formattedValue = value == null ? null : this.format.format(value);
            }
            catch (IllegalArgumentException e) {
                formattedValue = value;
            }
            super.setValue(formattedValue);
        }
    }

    public static class TrafficLightRender
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = -8226481938945715389L;

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int rowIndex, int colIndex) {
            JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, rowIndex, colIndex);
            ZmqMonitorTableModel tableModel = (ZmqMonitorTableModel)table.getModel();
            if (tableModel.isActive(rowIndex)) {
                label.setBackground(Color.GREEN);
            } else {
                label.setBackground(Color.RED);
            }
            return label;
        }
    }
}

