/*
 * Decompiled with CFR 0.152.
 */
package org.zeromq.jms.jconsole;

import java.text.DecimalFormat;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.table.AbstractTableModel;
import org.zeromq.jms.jmx.ZmqGatewayManagerMBean;
import org.zeromq.jms.jmx.ZmqMetricsMBean;
import org.zeromq.jms.jmx.ZmqSocketStatisticsMBean;

public class ZmqMonitorTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = -7662927243300887754L;
    public static final String[] COLUMN_NAMES = new String[]{"Name", "Flags", "Start Time", "Last Send", "Send Rate (s)", "Send Max Rate (s)", "Send (30s)", "Send (60s)", "Send (5min)", "Send", "Last Rec", "Rec Rate (s)", "Rec Max Rate (s)", "Rec (30s)", "Rec (60s)", "Rec (5min)", "Rec"};
    public static final Format[] COLUMN_FORMATS;
    private final Map<String, String> columnToMetricMap = new HashMap<String, String>();
    private List<ZmqMetricsMBean> rows = new ArrayList<ZmqMetricsMBean>();

    static {
        Format[] formatArray = new Format[17];
        formatArray[2] = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        formatArray[3] = new SimpleDateFormat("HH:mm:ss.SSS");
        formatArray[4] = new DecimalFormat("0.00");
        formatArray[5] = new DecimalFormat("0.00");
        formatArray[6] = new DecimalFormat("0");
        formatArray[7] = new DecimalFormat("0");
        formatArray[8] = new DecimalFormat("0");
        formatArray[9] = new DecimalFormat("0");
        formatArray[10] = new SimpleDateFormat("HH:mm:ss.SSS");
        formatArray[11] = new DecimalFormat("0.00");
        formatArray[12] = new DecimalFormat("0.00");
        formatArray[13] = new DecimalFormat("0");
        formatArray[14] = new DecimalFormat("0");
        formatArray[15] = new DecimalFormat("0");
        formatArray[16] = new DecimalFormat("0");
        COLUMN_FORMATS = formatArray;
    }

    public ZmqMonitorTableModel() {
        this.columnToMetricMap.put("Send Rate (s)", "Rate (s)");
        this.columnToMetricMap.put("Send Rate (m)", "Rate (min)");
        this.columnToMetricMap.put("Send Max Rate (s)", "Max Rate (s)");
        this.columnToMetricMap.put("Send (30s)", "Count (30s)");
        this.columnToMetricMap.put("Send (60s)", "Count (60s)");
        this.columnToMetricMap.put("Send (90s)", "Count (90s)");
        this.columnToMetricMap.put("Send (2min)", "Count (2min");
        this.columnToMetricMap.put("Send (5min)", "Count (5min)");
        this.columnToMetricMap.put("Send (10min)", "Count (10min)");
        this.columnToMetricMap.put("Send (30min)", "Count (30min)");
        this.columnToMetricMap.put("Send (1h)", "Count (1h)");
        this.columnToMetricMap.put("Send (6h)", "Count (6h)");
        this.columnToMetricMap.put("Send (12h)", "Count (12h)");
        this.columnToMetricMap.put("Send (24h)", "Count (24h)");
        this.columnToMetricMap.put("Rec Rate (s)", "Rate (s)");
        this.columnToMetricMap.put("Rec Rate (m)", "Rate (min)");
        this.columnToMetricMap.put("Rec Max Rate (s)", "Max Rate (s)");
        this.columnToMetricMap.put("Rec (30s)", "Count (30s)");
        this.columnToMetricMap.put("Rec (60s)", "Count (60s)");
        this.columnToMetricMap.put("Rec (90s)", "Count (90s)");
        this.columnToMetricMap.put("Rec (2min)", "Count (2min");
        this.columnToMetricMap.put("Rec (5min)", "Count (5min)");
        this.columnToMetricMap.put("Rec (10min)", "Count (10min)");
        this.columnToMetricMap.put("Rec (30min)", "Count (30min)");
        this.columnToMetricMap.put("Rec (1h)", "Count (1h)");
        this.columnToMetricMap.put("Rec (6h)", "Count (6h)");
        this.columnToMetricMap.put("Rec (12h)", "Count (12h)");
        this.columnToMetricMap.put("Rec (24h)", "Count (24h)");
    }

    public void setRow(List<ZmqMetricsMBean> rows) {
        this.rows = rows;
    }

    public boolean isActive(int rowIndex) {
        ZmqMetricsMBean mBean = this.rows.get(rowIndex);
        return mBean.isActive();
    }

    @Override
    public int getRowCount() {
        return this.rows.size();
    }

    @Override
    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return COLUMN_NAMES[columnIndex];
    }

    public Class<? extends Object> getColumnClass(int columnIndex) {
        Object value = this.getValueAt(0, columnIndex);
        return value != null ? value.getClass() : String.class;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        ZmqMetricsMBean mBean = this.rows.get(rowIndex);
        if (mBean instanceof ZmqGatewayManagerMBean) {
            return this.getValue((ZmqGatewayManagerMBean)mBean, columnIndex);
        }
        if (mBean instanceof ZmqSocketStatisticsMBean) {
            return this.getValue((ZmqSocketStatisticsMBean)mBean, columnIndex);
        }
        return false;
    }

    protected Object getValue(ZmqSocketStatisticsMBean socketMBean, int columnIndex) {
        String columnName;
        Object value = null;
        switch (columnName = COLUMN_NAMES[columnIndex]) {
            case "Name": {
                value = "   " + socketMBean.getAddr();
                break;
            }
            case "Active": {
                value = socketMBean.isActive();
                break;
            }
            case "Send": {
                value = socketMBean.getSendCount();
                break;
            }
            case "Last Send": {
                value = socketMBean.getLastSendTime();
                break;
            }
            case "Rec": {
                value = socketMBean.getReceiveCount();
                break;
            }
            case "Last Rec": {
                value = socketMBean.getLastReceiveTime();
                break;
            }
            default: {
                if (!this.columnToMetricMap.containsKey(columnName)) break;
                String metricName = this.columnToMetricMap.get(columnName);
                if (columnName.startsWith("Send")) {
                    value = socketMBean.getSendMetrics().get(metricName);
                    break;
                }
                if (!columnName.startsWith("Rec")) break;
                value = socketMBean.getReceiveMetrics().get(metricName);
            }
        }
        return value;
    }

    protected Object getValue(ZmqGatewayManagerMBean gatewayMBean, int columnIndex) {
        String columnName;
        Object value = null;
        switch (columnName = COLUMN_NAMES[columnIndex]) {
            case "Name": {
                value = gatewayMBean.getName();
                break;
            }
            case "Active": {
                value = gatewayMBean.isActive();
                break;
            }
            case "Flags": {
                StringBuilder flagsBuilder = new StringBuilder(gatewayMBean.getDirection().subSequence(0, 1));
                if (gatewayMBean.isBound()) {
                    flagsBuilder.append(",B");
                }
                if (gatewayMBean.isAcknowledged()) {
                    flagsBuilder.append(",A");
                }
                if (gatewayMBean.isHeartbeat()) {
                    flagsBuilder.append(",H");
                }
                if (gatewayMBean.isTransacted()) {
                    flagsBuilder.append(",T");
                }
                value = flagsBuilder.toString();
                break;
            }
            case "Start Time": {
                value = gatewayMBean.getStartTime();
                break;
            }
            case "Send": {
                value = gatewayMBean.getSendCount();
                break;
            }
            case "Last Send": {
                value = gatewayMBean.getLastSendTime();
                break;
            }
            case "Rec": {
                value = gatewayMBean.getReceiveCount();
                break;
            }
            case "Last Rec": {
                value = gatewayMBean.getLastReceiveTime();
            }
        }
        return value;
    }
}

