/*
 * Decompiled with CFR 0.152.
 */
package org.zeromq.jms.jmx;

import java.io.Serializable;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.zeromq.jms.jmx.ZmqGatewayManagerMBean;
import org.zeromq.jms.protocol.ZmqGateway;
import org.zeromq.jms.protocol.ZmqSocketMetrics;

public class ZmqGatewayManager
implements ZmqGatewayManagerMBean,
Serializable {
    private static final long serialVersionUID = -3472494196728884010L;
    private final String name;
    private final ZmqGateway gateway;

    public ZmqGatewayManager(String name, ZmqGateway gateway) {
        this.name = name;
        this.gateway = gateway;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isActive() {
        return this.gateway.isActive();
    }

    @Override
    public Date getStartTime() {
        return this.gateway.getStartTime();
    }

    @Override
    public boolean isTransacted() {
        return this.gateway.isTransacted();
    }

    @Override
    public boolean isBound() {
        return this.gateway.isBound();
    }

    @Override
    public boolean isAcknowledged() {
        return this.gateway.isAcknowledged();
    }

    @Override
    public boolean isHeartbeat() {
        return this.gateway.isHeartbeat();
    }

    @Override
    public String getDirection() {
        return this.gateway.getDirection().toString();
    }

    protected Map<String, Double> calculateMetrics(int bucketInterval, long[] bucketCounts) {
        LinkedHashMap<String, Double> metrics = new LinkedHashMap<String, Double>();
        double countSum = 0.0;
        int intervalSum = 0;
        int i = 0;
        while (i < bucketCounts.length) {
            double rate = (countSum += (double)bucketCounts[i]) / (double)(intervalSum += bucketInterval);
            if (!metrics.containsKey("Rate (s)") && intervalSum >= 1000) {
                metrics.put("Rate (s)", rate);
            } else if (!metrics.containsKey("Rate (s)") && intervalSum >= 60000) {
                metrics.put("Rate (s)", rate);
            } else if (!metrics.containsKey("Max Rate (s)")) {
                metrics.put("Max Rate (s)", rate);
            } else {
                double maxRate = (Double)metrics.get("Max Rate (s)");
                if (rate > maxRate) {
                    metrics.put("Max Rate (s)", rate);
                } else if (!metrics.containsKey("Count (30s)") && intervalSum >= 30000) {
                    metrics.put("Count (30s)", countSum);
                } else if (!metrics.containsKey("Count (60s)") && intervalSum >= 60000) {
                    metrics.put("Count (60s)", countSum);
                } else if (!metrics.containsKey("Count (90s)") && intervalSum >= 90000) {
                    metrics.put("Count (90s)", countSum);
                } else if (!metrics.containsKey("Count (2min") && intervalSum >= 120000) {
                    metrics.put("Count (2min", countSum);
                } else if (!metrics.containsKey("Count (5min)") && intervalSum >= 300000) {
                    metrics.put("Count (5min)", countSum);
                } else if (!metrics.containsKey("Count (10min)") && intervalSum >= 600000) {
                    metrics.put("Count (10min)", countSum);
                } else if (!metrics.containsKey("Count (30min)") && intervalSum >= 1800000) {
                    metrics.put("Count (30min)", countSum);
                } else if (!metrics.containsKey("Count (1h)") && intervalSum >= 3600000) {
                    metrics.put("Count (1h)", countSum);
                } else if (!metrics.containsKey("Count (6h)") && intervalSum >= 21600000) {
                    metrics.put("Count (6h)", countSum);
                } else if (!metrics.containsKey("Count (12h)") && intervalSum >= 43200000) {
                    metrics.put("Count (12h)", countSum);
                } else if (!metrics.containsKey("Count (24h)") && intervalSum >= 86400000) {
                    metrics.put("Count (24h)", countSum);
                }
            }
            ++i;
        }
        return metrics;
    }

    @Override
    public Map<String, Double> getSendMetrics() {
        List<ZmqSocketMetrics> metricsList = this.gateway.getMetrics();
        if (metricsList.size() > 0) {
            int bucketInterval = metricsList.get(0).getBucketInternval();
            long[] bucketCounts = metricsList.get(0).getSendBucketCounts();
            if (bucketCounts != null) {
                long[] sumBucketCounts = new long[bucketCounts.length];
                for (ZmqSocketMetrics socketMetrics : metricsList) {
                    long[] socketBucketCounts = socketMetrics.getSendBucketCounts();
                    int i = 0;
                    while (i < sumBucketCounts.length) {
                        sumBucketCounts[i] = sumBucketCounts[i] + socketBucketCounts[i];
                        ++i;
                    }
                }
                return this.calculateMetrics(bucketInterval, sumBucketCounts);
            }
        }
        return new LinkedHashMap<String, Double>();
    }

    @Override
    public Map<String, Double> getReceiveMetrics() {
        List<ZmqSocketMetrics> metricsList = this.gateway.getMetrics();
        if (metricsList.size() > 0) {
            int bucketInterval = metricsList.get(0).getBucketInternval();
            long[] bucketCounts = metricsList.get(0).getReceiveBucketCounts();
            if (bucketCounts != null) {
                long[] sumBucketCounts = new long[bucketCounts.length];
                for (ZmqSocketMetrics socketMetrics : metricsList) {
                    long[] socketBucketCounts = socketMetrics.getReceiveBucketCounts();
                    int i = 0;
                    while (i < sumBucketCounts.length) {
                        sumBucketCounts[i] = sumBucketCounts[i] + socketBucketCounts[i];
                        ++i;
                    }
                }
                return this.calculateMetrics(bucketInterval, sumBucketCounts);
            }
        }
        return new LinkedHashMap<String, Double>();
    }

    @Override
    public long getSendCount() {
        List<ZmqSocketMetrics> metricsList = this.gateway.getMetrics();
        long sendCount = 0L;
        if (metricsList.size() > 0) {
            for (ZmqSocketMetrics socketMetrics : metricsList) {
                sendCount += socketMetrics.getSendCount();
            }
        }
        return sendCount;
    }

    @Override
    public Date getLastSendTime() {
        List<ZmqSocketMetrics> metricsList = this.gateway.getMetrics();
        long lastSendTime = 0L;
        if (metricsList.size() > 0) {
            for (ZmqSocketMetrics socketMetrics : metricsList) {
                if (lastSendTime >= socketMetrics.getLastSendTime()) continue;
                lastSendTime = socketMetrics.getLastSendTime();
            }
        }
        if (lastSendTime == 0L) {
            return null;
        }
        return new Date(lastSendTime);
    }

    @Override
    public long getReceiveCount() {
        List<ZmqSocketMetrics> metricsList = this.gateway.getMetrics();
        long receiveCount = 0L;
        if (metricsList.size() > 0) {
            for (ZmqSocketMetrics socketMetrics : metricsList) {
                receiveCount += socketMetrics.getReceiveCount();
            }
        }
        return receiveCount;
    }

    @Override
    public Date getLastReceiveTime() {
        List<ZmqSocketMetrics> metricsList = this.gateway.getMetrics();
        long lastReceiveTime = 0L;
        if (metricsList.size() > 0) {
            for (ZmqSocketMetrics socketMetrics : metricsList) {
                if (lastReceiveTime >= socketMetrics.getLastReceiveTime()) continue;
                lastReceiveTime = socketMetrics.getLastReceiveTime();
            }
        }
        if (lastReceiveTime == 0L) {
            return null;
        }
        return new Date(lastReceiveTime);
    }
}

