/*
 * Decompiled with CFR 0.152.
 */
package org.zeromq.jms.jmx;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.JMX;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.zeromq.jms.jmx.ZmqGatewayManager;
import org.zeromq.jms.jmx.ZmqGatewayManagerMBean;
import org.zeromq.jms.jmx.ZmqSocketStatistics;
import org.zeromq.jms.jmx.ZmqSocketStatisticsMBean;
import org.zeromq.jms.protocol.ZmqGateway;
import org.zeromq.jms.protocol.ZmqSocketMetrics;
import org.zeromq.jms.protocol.ZmqSocketType;

public class ZmqMBeanUtils {
    private static final Logger LOGGER = Logger.getLogger(ZmqMBeanUtils.class.getCanonicalName());
    private static final Map<ObjectName, Integer> REGISTERED_NAMES = new HashMap<ObjectName, Integer>();

    private ZmqMBeanUtils() {
    }

    public static Set<ObjectInstance> getMbeans(MBeanServerConnection mBeanServerConnection) throws MalformedObjectNameException, IOException {
        ObjectName objectQueryName = new ObjectName("org.zeromq:type=ZMQ,*");
        Set<ObjectInstance> objectInstances = mBeanServerConnection.queryMBeans(objectQueryName, null);
        return objectInstances;
    }

    public static List<ZmqGatewayManagerMBean> getGatewayManagerMBeans(MBeanServerConnection mBeanServerConnection) throws MalformedObjectNameException, IOException {
        LinkedList<ZmqGatewayManagerMBean> managerMBeanList = new LinkedList<ZmqGatewayManagerMBean>();
        ObjectName objectQueryName = new ObjectName("org.zeromq:type=ZMQ,*");
        Set<ObjectInstance> objectInstances = mBeanServerConnection.queryMBeans(objectQueryName, null);
        for (ObjectInstance objectInstance : objectInstances) {
            ObjectName objectName = objectInstance.getObjectName();
            String socketName = objectName.getKeyProperty("socket");
            if (socketName != null) continue;
            ZmqGatewayManagerMBean proxyMBean = JMX.newMBeanProxy(mBeanServerConnection, objectName, ZmqGatewayManagerMBean.class);
            managerMBeanList.add(proxyMBean);
        }
        return managerMBeanList;
    }

    public static List<ZmqGatewayManagerMBean> getGatewayManagerMBeans(MBeanServerConnection mBeanServerConnection, String namePattern) throws MalformedObjectNameException, IOException {
        List<ZmqGatewayManagerMBean> managerMBeanList = ZmqMBeanUtils.getGatewayManagerMBeans(mBeanServerConnection);
        LinkedList<ZmqGatewayManagerMBean> managerMBeanFilterList = new LinkedList<ZmqGatewayManagerMBean>();
        for (ZmqGatewayManagerMBean managerMBean : managerMBeanList) {
            String name = managerMBean.getName();
            if (!name.matches(namePattern)) continue;
            managerMBeanFilterList.add(managerMBean);
        }
        return managerMBeanFilterList;
    }

    public static List<ZmqSocketStatisticsMBean> getSocketStatisticsMBeans(MBeanServerConnection mBeanServerConnection, String gatewayName) throws MalformedObjectNameException, IOException {
        LinkedList<ZmqSocketStatisticsMBean> statisticsMBeanList = new LinkedList<ZmqSocketStatisticsMBean>();
        ObjectName objectQueryName = new ObjectName("org.zeromq:type=ZMQ,gateway=\"" + gatewayName + "\",socket=*");
        Set<ObjectInstance> objectInstances = mBeanServerConnection.queryMBeans(objectQueryName, null);
        for (ObjectInstance objectInstance : objectInstances) {
            ObjectName objectName = objectInstance.getObjectName();
            ZmqSocketStatisticsMBean proxyMBean = JMX.newMBeanProxy(mBeanServerConnection, objectName, ZmqSocketStatisticsMBean.class);
            statisticsMBeanList.add(proxyMBean);
        }
        return statisticsMBeanList;
    }

    public static List<ObjectName> register(ZmqGateway gateway) {
        LinkedList<ObjectName> objectNames = new LinkedList<ObjectName>();
        boolean isRegister = false;
        int version = 0;
        String gatewayName = null;
        ObjectName gatewayObjectName = null;
        try {
            do {
                String registeredVersion = isRegister ? "[" + ++version + "]" : "";
                gatewayName = String.valueOf(gateway.getName().replace(":", "").replace("/", "").replace("*", "")) + registeredVersion;
                String gatewayMBeanName = "org.zeromq:type=ZMQ,gateway=\"" + gatewayName + "\"";
                gatewayObjectName = new ObjectName(gatewayMBeanName);
                isRegister = REGISTERED_NAMES.containsKey(gatewayObjectName);
                if (!isRegister) continue;
                version = REGISTERED_NAMES.get(gatewayObjectName);
            } while (isRegister);
            ZmqGatewayManager gatewayMBean = new ZmqGatewayManager(gatewayName, gateway);
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            mbs.registerMBean(gatewayMBean, gatewayObjectName);
            REGISTERED_NAMES.put(gatewayObjectName, version);
            objectNames.add(gatewayObjectName);
            boolean isBound = gateway.isBound();
            ZmqSocketType type = gateway.getType();
            List<ZmqSocketMetrics> metrics = gateway.getMetrics();
            for (ZmqSocketMetrics metric : metrics) {
                String socketName = String.valueOf(gatewayName) + "@" + metric.getAddr().replace(":", "").replace("/", "").replace("*", "");
                ZmqSocketStatistics statisticsMBean = new ZmqSocketStatistics(socketName, metric.getAddr(), type.toString(), isBound, metric);
                String socketMBeanName = "org.zeromq:type=ZMQ,gateway=\"" + gatewayName + "\",socket=\"" + socketName + "\"";
                ObjectName socketObjectName = new ObjectName(socketMBeanName);
                mbs.registerMBean(statisticsMBean, socketObjectName);
                objectNames.add(socketObjectName);
                REGISTERED_NAMES.put(socketObjectName, version);
            }
        }
        catch (InstanceAlreadyExistsException | MBeanRegistrationException | MalformedObjectNameException | NotCompliantMBeanException ex) {
            LOGGER.log(Level.SEVERE, "Unable to register MBean: " + gatewayName, ex);
        }
        return objectNames;
    }

    public static void unregister(ObjectName objectName) {
        try {
            REGISTERED_NAMES.remove(objectName);
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            mbs.unregisterMBean(objectName);
        }
        catch (InstanceNotFoundException | MBeanRegistrationException ex) {
            LOGGER.log(Level.SEVERE, "Unable to unregister MBean: " + objectName, ex);
        }
    }
}

