/*
 * Decompiled with CFR 0.152.
 */
package org.zeromq.jms.protocol;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.zeromq.ZMQ;
import org.zeromq.ZMQException;
import org.zeromq.jms.protocol.ZmqSocketStatus;
import org.zeromq.jms.protocol.ZmqSocketType;
import zmq.ZError;

public class ZmqProxySession
implements Runnable {
    private static final Logger LOGGER = Logger.getLogger(ZmqProxySession.class.getCanonicalName());
    private volatile ZmqSocketStatus status = ZmqSocketStatus.STOPPED;
    private static final int SOCKET_RETRY_MILLI_SECOND = 10000;
    private final AtomicBoolean active;
    private final String name;
    private final ZMQ.Socket frontSocket;
    private final ZmqSocketType frontSocketType;
    private final String frontSocketAddr;
    private final boolean frontSocketBound;
    private final ZMQ.Socket backSocket;
    private final ZmqSocketType backSocketType;
    private final String backSocketAddr;
    private final boolean backSocketBound;

    public ZmqProxySession(String name, AtomicBoolean active, ZMQ.Socket frontSocket, ZmqSocketType frontSocketType, String frontSocketAddr, boolean frontSocketBound, ZMQ.Socket backSocket, ZmqSocketType backSocketType, String backSocketAddr, boolean backSocketBound) {
        this.active = active;
        this.name = name;
        this.frontSocket = frontSocket;
        this.frontSocketType = frontSocketType;
        this.frontSocketAddr = frontSocketAddr;
        this.frontSocketBound = frontSocketBound;
        this.backSocket = backSocket;
        this.backSocketType = backSocketType;
        this.backSocketAddr = backSocketAddr;
        this.backSocketBound = backSocketBound;
    }

    protected void setStatus(ZmqSocketStatus status) {
        if (this.status != status) {
            this.status = status;
            LOGGER.log(Level.INFO, "Proxy [" + this.name + "@" + this.frontSocketAddr + "|" + this.frontSocketAddr + "] changed status: " + (Object)((Object)status));
        }
    }

    @Override
    public void run() {
        ZmqSocketStatus status;
        this.setStatus(ZmqSocketStatus.PENDING);
        while ((status = this.openSocket(this.backSocket, this.backSocketAddr, this.backSocketBound)) != ZmqSocketStatus.RUNNING && this.active.get()) {
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException ex) {
                LOGGER.warning("Opening of back socket hibernation interrupted: " + this);
            }
            if (this.status == ZmqSocketStatus.PAUSED && this.active.get()) continue;
        }
        if (this.status == ZmqSocketStatus.RUNNING && this.active.get()) {
            while ((status = this.openSocket(this.frontSocket, this.frontSocketAddr, this.frontSocketBound)) != ZmqSocketStatus.RUNNING && this.active.get()) {
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException ex) {
                    LOGGER.warning("Opening of front socket hibernation interrupted: " + this);
                }
                if (this.status == ZmqSocketStatus.PAUSED && this.active.get()) continue;
            }
            if (this.status == ZmqSocketStatus.RUNNING && this.active.get()) {
                ZMQ.proxy((ZMQ.Socket)this.frontSocket, (ZMQ.Socket)this.backSocket, null);
                while (this.active.get()) {
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException ex) {
                        LOGGER.warning("Proxy hibernate for failover interrupted: " + this);
                    }
                }
            }
        }
        this.closeSocket(this.frontSocket, this.frontSocketAddr, this.frontSocketBound);
        this.closeSocket(this.backSocket, this.backSocketAddr, this.backSocketBound);
        this.setStatus(ZmqSocketStatus.STOPPED);
    }

    public ZmqSocketStatus getStatus() {
        return this.status;
    }

    protected ZmqSocketStatus closeSocket(ZMQ.Socket socket, String socketAddr, boolean socketBound) {
        if (socketBound) {
            try {
                try {
                    socket.setLinger(0L);
                }
                catch (ZError.CtxTerminatedException e) {
                    LOGGER.finest("Terminate exception of the setting of linger: " + this);
                }
                try {
                    socket.unbind(socketAddr);
                }
                catch (ZError.CtxTerminatedException e) {
                    LOGGER.finest("Terminate exception of the unbind: " + this);
                }
                socket.close();
            }
            catch (Exception ex) {
                LOGGER.log(Level.SEVERE, "Proxy [" + socketAddr + "] unbind failure: " + this, ex);
                throw ex;
            }
            LOGGER.info("Unbind Proxy [" + socketAddr + "] successful: " + this);
        } else {
            try {
                socket.setLinger(0L);
                socket.disconnect(socketAddr);
                socket.close();
            }
            catch (Exception ex) {
                LOGGER.log(Level.SEVERE, "Proxy [" + socketAddr + "] disconnect failure: " + this, ex);
                throw ex;
            }
            LOGGER.info("Disconnect Proxy [" + socketAddr + "] successful: " + this);
        }
        this.setStatus(ZmqSocketStatus.STOPPED);
        return this.getStatus();
    }

    protected ZmqSocketStatus openSocket(ZMQ.Socket socket, String socketAddr, boolean socketBound) {
        if (!this.active.get()) {
            return this.getStatus();
        }
        if (socketBound) {
            try {
                socket.bind(socketAddr);
            }
            catch (ZMQException ex) {
                if (ex.getErrorCode() == 48) {
                    this.setStatus(ZmqSocketStatus.PAUSED);
                    LOGGER.info("Proxy [" + socketAddr + "] socket UNSUCCESSFUL (Already Bound): " + this);
                    return this.getStatus();
                }
                LOGGER.log(Level.SEVERE, "Proxy [" + socketAddr + "] binding failure: " + this);
                this.setStatus(ZmqSocketStatus.ERROR);
                throw ex;
            }
            LOGGER.info("Bind proxy [" + socketAddr + "] successful: " + this);
        } else {
            try {
                socket.connect(socketAddr);
            }
            catch (Exception ex) {
                LOGGER.log(Level.SEVERE, "Proxy [" + socketAddr + "] connect failure: " + this, ex);
                this.setStatus(ZmqSocketStatus.ERROR);
                throw ex;
            }
            LOGGER.info("Connect Proxy [" + socketAddr + "] successful: " + this);
        }
        this.setStatus(ZmqSocketStatus.RUNNING);
        return this.getStatus();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.backSocketAddr == null ? 0 : this.backSocketAddr.hashCode());
        result = 31 * result + (this.frontSocketAddr == null ? 0 : this.frontSocketAddr.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ZmqProxySession other = (ZmqProxySession)obj;
        if (this.backSocketAddr == null ? other.backSocketAddr != null : !this.backSocketAddr.equals(other.backSocketAddr)) {
            return false;
        }
        if (this.frontSocketAddr == null ? other.frontSocketAddr != null : !this.frontSocketAddr.equals(other.frontSocketAddr)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public String toString() {
        return "ZmqProxySession [active=" + this.active + ", name=" + this.name + ", frontSocketType=" + (Object)((Object)this.frontSocketType) + ", frontSocketAddr=" + this.frontSocketAddr + ", frontSocketBound=" + this.frontSocketBound + ", backSocketType=" + (Object)((Object)this.backSocketType) + ", backSocketAddr=" + this.backSocketAddr + ", backSocketBound=" + this.backSocketBound + "]";
    }
}

