/*
 * Decompiled with CFR 0.152.
 */
package org.zeromq.jms.protocol;

import org.zeromq.jms.annotation.ZmqUriParameter;
import org.zeromq.jms.protocol.ZmqSocketType;

public class ZmqSocketContext {
    private String addr;
    private ZmqSocketType type;
    private Boolean bindFlag;
    private Long bindRetryWaitTime;
    private Integer recieveMsgFlag;
    private int ioThreads = 1;
    private String proxyAddr;
    private ZmqSocketType proxyType;
    private ZmqSocketType proxyOutType;
    private Long linger;
    private Long reconnectIVL;
    private Long backlog;
    private Long reconnectIVLMax;
    private Long maxMsgSize;
    private Long sndHWM;
    private Long rcvHWM;
    private Long affinity;
    private byte[] identity;
    private Long rate;
    private Long recoveryInterval;
    private Boolean reqCorrelate;
    private Boolean reqRelaxed;
    private Long multicastHops;
    private Integer receiveTimeOut;
    private Integer sendTimeOut;
    private Long tcpKeepAlive;
    private Long tcpKeepAliveCount;
    private Long tcpKeepAliveInterval;
    private Long tcpKeepAliveIdle;
    private Long sendBufferSize;
    private Long receiveBufferSize;
    private Boolean routerMandatory;
    private Boolean xpubVerbose;
    private Boolean ipv4Only;
    private Boolean delayAttachOnConnect;

    public ZmqSocketContext() {
    }

    public ZmqSocketContext(String addr, ZmqSocketType type, boolean bindFlag, int recieveMsgFlag) {
        this.addr = addr;
        this.type = type;
        this.bindFlag = bindFlag;
        this.recieveMsgFlag = recieveMsgFlag;
    }

    public ZmqSocketContext(ZmqSocketContext context) {
        this.addr = context.addr;
        this.type = context.type;
        this.bindFlag = context.bindFlag;
        this.bindRetryWaitTime = context.bindRetryWaitTime;
        this.recieveMsgFlag = context.recieveMsgFlag;
        this.ioThreads = context.ioThreads;
        this.proxyType = context.proxyType;
        this.proxyAddr = context.proxyAddr;
        this.linger = context.linger;
        this.reconnectIVL = context.reconnectIVL;
        this.backlog = context.backlog;
        this.reconnectIVLMax = context.reconnectIVLMax;
        this.maxMsgSize = context.maxMsgSize;
        this.sndHWM = context.sndHWM;
        this.rcvHWM = context.rcvHWM;
        this.affinity = context.affinity;
        this.identity = context.getIdentity();
        this.rate = context.rate;
        this.recoveryInterval = context.recoveryInterval;
        this.reqCorrelate = context.reqCorrelate;
        this.reqRelaxed = context.reqRelaxed;
        this.multicastHops = context.multicastHops;
        this.receiveTimeOut = context.receiveTimeOut;
        this.sendTimeOut = context.sendTimeOut;
        this.tcpKeepAlive = context.tcpKeepAlive;
        this.tcpKeepAliveCount = context.tcpKeepAliveCount;
        this.tcpKeepAliveInterval = context.tcpKeepAliveInterval;
        this.tcpKeepAliveIdle = context.tcpKeepAliveIdle;
        this.sendBufferSize = context.sendBufferSize;
        this.receiveBufferSize = context.receiveBufferSize;
        this.routerMandatory = context.routerMandatory;
        this.xpubVerbose = context.xpubVerbose;
        this.ipv4Only = context.ipv4Only;
        this.delayAttachOnConnect = context.delayAttachOnConnect;
    }

    public String getAddr() {
        return this.addr;
    }

    public void setAddr(String addr) {
        this.addr = addr;
    }

    public ZmqSocketType getType() {
        return this.type;
    }

    public void setType(ZmqSocketType type) {
        this.type = type;
    }

    public Boolean isBindFlag() {
        if (this.bindFlag != null && this.bindFlag.booleanValue()) {
            return true;
        }
        return false;
    }

    public void setBindFlag(Boolean bindFlag) {
        this.bindFlag = bindFlag;
    }

    public int getIOThreads() {
        return this.ioThreads;
    }

    @ZmqUriParameter(value="context.ioThreads")
    public void setIOThreads(int ioThreads) {
        this.ioThreads = ioThreads;
    }

    public boolean isProxy() {
        return this.proxyAddr != null;
    }

    public String getProxyAddr() {
        return this.proxyAddr;
    }

    @ZmqUriParameter(value="proxy.proxyAddr")
    public void setProxyAddr(String proxyAddr) {
        this.proxyAddr = proxyAddr;
    }

    public ZmqSocketType getProxyType() {
        return this.proxyType;
    }

    @ZmqUriParameter(value="proxy.proxyType")
    public void setProxyType(ZmqSocketType proxyType) {
        this.proxyType = proxyType;
    }

    public ZmqSocketType getOutProxyType() {
        return this.proxyOutType;
    }

    @ZmqUriParameter(value="proxy.proxyOutType")
    public void setProxyOutType(ZmqSocketType proxyOutType) {
        this.proxyOutType = proxyOutType;
    }

    public Long getBindRetryWaitTime() {
        return this.bindRetryWaitTime;
    }

    @ZmqUriParameter(value="socket.bindRetryWaitTime")
    public void setBindRetryWaitTime(Long bindRetryWaitTime) {
        this.bindRetryWaitTime = bindRetryWaitTime;
    }

    public Integer getRecieveMsgFlag() {
        return this.recieveMsgFlag;
    }

    @ZmqUriParameter(value="socket.recieveMsgFlag")
    public void setRecieveMsgFlag(Integer recieveMsgFlag) {
        this.recieveMsgFlag = recieveMsgFlag;
    }

    public Long getLinger() {
        return this.linger;
    }

    @ZmqUriParameter(value="socket.linger")
    public void setLinger(Long linger) {
        this.linger = linger;
    }

    public Long getReconnectIVL() {
        return this.reconnectIVL;
    }

    @ZmqUriParameter(value="socket.reconnectIVL")
    public void setReconnectIVL(Long reconnectIVL) {
        this.reconnectIVL = reconnectIVL;
    }

    public Long getBacklog() {
        return this.backlog;
    }

    @ZmqUriParameter(value="socket.backlog")
    public void setBacklog(Long backlog) {
        this.backlog = backlog;
    }

    public Long getReconnectIVLMax() {
        return this.reconnectIVLMax;
    }

    @ZmqUriParameter(value="socket.reconnectIVLMax")
    public void setReconnectIVLMax(Long reconnectIVLMax) {
        this.reconnectIVLMax = reconnectIVLMax;
    }

    public Long getMaxMsgSize() {
        return this.maxMsgSize;
    }

    @ZmqUriParameter(value="socket.maxMsgSize")
    public void setMaxMsgSize(Long maxMsgSize) {
        this.maxMsgSize = maxMsgSize;
    }

    public Long getSndHWM() {
        return this.sndHWM;
    }

    @ZmqUriParameter(value="socket.sndHWM")
    public void setSndHWM(Long sndHWM) {
        this.sndHWM = sndHWM;
    }

    public Long getRcvHWM() {
        return this.rcvHWM;
    }

    @ZmqUriParameter(value="socket.rcvHWM")
    public void setRcvHWM(Long rcvHWM) {
        this.rcvHWM = rcvHWM;
    }

    public Long getAffinity() {
        return this.affinity;
    }

    @ZmqUriParameter(value="socket.affinity")
    public void setAffinity(Long affinity) {
        this.affinity = affinity;
    }

    public byte[] getIdentity() {
        return this.identity;
    }

    @ZmqUriParameter(value="socket.identity")
    public void setIdentity(byte[] identity) {
        this.identity = identity;
    }

    public Long getRate() {
        return this.rate;
    }

    @ZmqUriParameter(value="socket.rate")
    public void setRate(Long rate) {
        this.rate = rate;
    }

    public Long getRecoveryInterval() {
        return this.recoveryInterval;
    }

    @ZmqUriParameter(value="socket.recoveryInterval")
    public void setRecoveryInterval(Long recoveryInterval) {
        this.recoveryInterval = recoveryInterval;
    }

    public Boolean getReqCorrelate() {
        return this.reqCorrelate;
    }

    @ZmqUriParameter(value="socket.reqCorrelate")
    public void setReqCorrelate(Boolean reqCorrelate) {
        this.reqCorrelate = reqCorrelate;
    }

    public Boolean getReqRelaxed() {
        return this.reqRelaxed;
    }

    @ZmqUriParameter(value="socket.reqRelaxed")
    public void setReqRelaxed(Boolean reqRelaxed) {
        this.reqRelaxed = reqRelaxed;
    }

    public Long getMulticastHops() {
        return this.multicastHops;
    }

    @ZmqUriParameter(value="socket.multicastHops")
    public void setMulticastHops(Long multicastHops) {
        this.multicastHops = multicastHops;
    }

    public Integer getReceiveTimeOut() {
        return this.receiveTimeOut;
    }

    @ZmqUriParameter(value="socket.receiveTimeOut")
    public void setReceiveTimeOut(Integer receiveTimeOut) {
        this.receiveTimeOut = receiveTimeOut;
    }

    public Integer getSendTimeOut() {
        return this.sendTimeOut;
    }

    @ZmqUriParameter(value="socket.sendTimeOut")
    public void setSendTimeOut(Integer sendTimeOut) {
        this.sendTimeOut = sendTimeOut;
    }

    public Long getTcpKeepAlive() {
        return this.tcpKeepAlive;
    }

    @ZmqUriParameter(value="socket.tcpKeepAlive")
    public void setTcpKeepAlive(Long tcpKeepAlive) {
        this.tcpKeepAlive = tcpKeepAlive;
    }

    public Long getTcpKeepAliveCount() {
        return this.tcpKeepAliveCount;
    }

    @ZmqUriParameter(value="socket.tcpKeepAliveCount")
    public void setTcpKeepAliveCount(Long tcpKeepAliveCount) {
        this.tcpKeepAliveCount = tcpKeepAliveCount;
    }

    public Long getTcpKeepAliveInterval() {
        return this.tcpKeepAliveInterval;
    }

    @ZmqUriParameter(value="socket.tcpKeepAliveInterval")
    public void setTcpKeepAliveInterval(Long tcpKeepAliveInterval) {
        this.tcpKeepAliveInterval = tcpKeepAliveInterval;
    }

    public Long getTcpKeepAliveIdle() {
        return this.tcpKeepAliveIdle;
    }

    @ZmqUriParameter(value="socket.tcpKeepAliveIdle")
    public void setTcpKeepAliveIdle(Long tcpKeepAliveIdle) {
        this.tcpKeepAliveIdle = tcpKeepAliveIdle;
    }

    public Long getSendBufferSize() {
        return this.sendBufferSize;
    }

    @ZmqUriParameter(value="socket.sendBufferSize")
    public void setSendBufferSize(Long sendBufferSize) {
        this.sendBufferSize = sendBufferSize;
    }

    public Long getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    @ZmqUriParameter(value="socket.receiveBufferSize")
    public void setReceiveBufferSize(Long receiveBufferSize) {
        this.receiveBufferSize = receiveBufferSize;
    }

    public Boolean getRouterMandatory() {
        return this.routerMandatory;
    }

    @ZmqUriParameter(value="socket.routerMandatory")
    public void setRouterMandatory(Boolean routerMandatory) {
        this.routerMandatory = routerMandatory;
    }

    public Boolean getXpubVerbose() {
        return this.xpubVerbose;
    }

    @ZmqUriParameter(value="socket.xpubVerbose")
    public void setXpubVerbose(Boolean xpubVerbose) {
        this.xpubVerbose = xpubVerbose;
    }

    public Boolean getIpv4Only() {
        return this.ipv4Only;
    }

    @ZmqUriParameter(value="socket.ipv4Only")
    public void setIpv4Only(Boolean ipv4Only) {
        this.ipv4Only = ipv4Only;
    }

    public Boolean getDelayAttachOnConnect() {
        return this.delayAttachOnConnect;
    }

    @ZmqUriParameter(value="socket.delayAttachOnConnect")
    public void setDelayAttachOnConnect(Boolean delayAttachOnConnect) {
        this.delayAttachOnConnect = delayAttachOnConnect;
    }

    public String toString() {
        return "ZmqSocketContext [addr=" + this.addr + ", type=" + (Object)((Object)this.type) + ", bindFlag=" + this.bindFlag + ", recieveMsgFlag=" + this.recieveMsgFlag + ", bindRetryWaitTime=" + this.bindRetryWaitTime + ", proxyAddr= " + this.proxyAddr + "]";
    }
}

