/*
 * Decompiled with CFR 0.152.
 */
package org.zeromq.jms.protocol;

import java.io.Serializable;
import org.zeromq.jms.protocol.ZmqSocketStatus;

public class ZmqSocketMetrics
implements Serializable {
    private static final long serialVersionUID = 3377715287843053265L;
    private final String addr;
    private ZmqSocketStatus status;
    private long sendCount = 0L;
    private long receiveCount = 0L;
    private long sendTime;
    private long receiveTime;
    private final int bucketCount;
    private final int bucketInterval;
    private int sendBucketIndex = 0;
    private int receiveBucketIndex = 0;
    private final long[] sendBucketCounts;
    private final long[] receiveBucketCounts;

    public ZmqSocketMetrics(String addr, int bucketCount, int bucketInterval, boolean logSend, boolean logReceive) {
        this.addr = addr;
        this.bucketCount = bucketCount;
        this.bucketInterval = bucketInterval;
        this.sendBucketCounts = logSend ? new long[bucketCount] : null;
        this.receiveBucketCounts = logReceive ? new long[bucketCount] : null;
    }

    private void resetBuckets(int index, int bucketIndex, long[] bucketCounts) {
        int skipCount = index - bucketIndex;
        if (skipCount < 0) {
            skipCount = this.bucketCount - bucketIndex + index;
        }
        int i = 0;
        while (i < skipCount) {
            int skipIndex = ((bucketIndex + skipCount) % this.bucketCount + this.bucketCount) % this.bucketCount;
            bucketCounts[skipIndex] = 0L;
            ++i;
        }
    }

    protected int increment(long currentTime, int bucketIndex, long[] bucketCounts) {
        int index = (int)(currentTime / (long)this.bucketInterval % (long)this.bucketCount);
        if (bucketIndex != index) {
            this.resetBuckets(index, bucketIndex, bucketCounts);
        }
        int n = index;
        bucketCounts[n] = bucketCounts[n] + 1L;
        return index;
    }

    public String getAddr() {
        return this.addr;
    }

    public boolean isActive() {
        return this.status == ZmqSocketStatus.ERROR;
    }

    public ZmqSocketStatus getStatus() {
        return this.status;
    }

    public void setStatus(ZmqSocketStatus status) {
        this.status = status;
    }

    public long getSendCount() {
        return this.sendCount;
    }

    public long getLastSendTime() {
        return this.sendTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementSend() {
        if (this.sendBucketCounts == null) {
            throw new IllegalStateException("Socket statistics no setup to count sends.");
        }
        this.sendTime = System.currentTimeMillis();
        ++this.sendCount;
        long[] lArray = this.sendBucketCounts;
        synchronized (this.sendBucketCounts) {
            this.sendBucketIndex = this.increment(this.sendTime, this.sendBucketIndex, this.sendBucketCounts);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public long getReceiveCount() {
        return this.receiveCount;
    }

    public long getLastReceiveTime() {
        return this.receiveTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void incrementReceive() {
        if (this.receiveBucketCounts == null) {
            throw new IllegalStateException("Socket statistics no setup to count receives.");
        }
        this.receiveTime = System.currentTimeMillis();
        ++this.receiveCount;
        long[] lArray = this.receiveBucketCounts;
        synchronized (this.receiveBucketCounts) {
            this.receiveBucketIndex = this.increment(this.receiveTime, this.receiveBucketIndex, this.receiveBucketCounts);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public int getBucketInternval() {
        return this.bucketInterval;
    }

    private long[] getBucketCounts(int bucketIndex, long[] bucketCounts) {
        long currentTime = System.currentTimeMillis();
        int currentIndex = (int)(currentTime / (long)this.bucketInterval % (long)this.bucketCount);
        if (bucketIndex != currentIndex) {
            this.resetBuckets(currentIndex, bucketIndex, bucketCounts);
        }
        long[] tempotalBucketCounts = new long[bucketCounts.length];
        int i = 0;
        while (i < this.bucketCount) {
            int index = ((bucketIndex - i) % this.bucketCount + this.bucketCount) % this.bucketCount;
            tempotalBucketCounts[i] = bucketCounts[index];
            ++i;
        }
        return tempotalBucketCounts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[] getSendBucketCounts() {
        if (this.sendBucketCounts == null) {
            return null;
        }
        long[] lArray = this.sendBucketCounts;
        synchronized (this.sendBucketCounts) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.getBucketCounts(this.sendBucketIndex, this.sendBucketCounts);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[] getReceiveBucketCounts() {
        if (this.receiveBucketCounts == null) {
            return null;
        }
        long[] lArray = this.receiveBucketCounts;
        synchronized (this.receiveBucketCounts) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.getBucketCounts(this.receiveBucketIndex, this.receiveBucketCounts);
        }
    }

    public String toString() {
        return "ZmqSocketMetrics [addr=" + this.addr + ", status=" + (Object)((Object)this.status) + ", sendCount=" + this.sendCount + ", receiveCount=" + this.receiveCount + ", sendTime=" + this.sendTime + ", receiveTime=" + this.receiveTime + "]";
    }
}

