/*
 * Decompiled with CFR 0.152.
 */
package org.zeromq.jms.protocol;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.zeromq.ZMQ;
import org.zeromq.ZMQException;
import org.zeromq.ZMsg;
import org.zeromq.jms.ZmqException;
import org.zeromq.jms.protocol.ZmqEvent;
import org.zeromq.jms.protocol.ZmqSocketListener;
import org.zeromq.jms.protocol.ZmqSocketMetrics;
import org.zeromq.jms.protocol.ZmqSocketStatus;
import org.zeromq.jms.protocol.ZmqSocketType;
import org.zeromq.jms.protocol.event.ZmqEventHandler;
import org.zeromq.jms.protocol.filter.ZmqFilterPolicy;

public class ZmqSocketSession
implements Runnable {
    private static final Logger LOGGER = Logger.getLogger(ZmqSocketSession.class.getCanonicalName());
    private volatile ZmqSocketStatus status = ZmqSocketStatus.STOPPED;
    private static final int SOCKET_RETRY_MILLI_SECOND = 3000;
    private volatile long lastReceiveTime = System.nanoTime();
    private volatile long lastSendTime = System.nanoTime();
    private final AtomicBoolean active;
    private final String name;
    private final ZMQ.Socket socket;
    private final ZmqSocketType socketType;
    private final String socketAddr;
    private final boolean socketBound;
    private final boolean socketIncoming;
    private final boolean socketOutgoing;
    private final int socketFlags;
    private final int socketWaitTime;
    private final boolean socketHeartbeat;
    private final boolean socketAcknowledge;
    private final ZmqSocketListener socketListener;
    private final ZmqSocketMetrics metrics;
    private final ZmqEventHandler handler;
    private final ZmqFilterPolicy filter;
    private final Map<Object, TrackEvent> trackEventMap = new HashMap<Object, TrackEvent>();

    public ZmqSocketSession(String name, AtomicBoolean active, ZMQ.Socket socket, ZmqSocketType socketType, String socketAddr, boolean socketBound, boolean socketIncoming, boolean socketOutgoing, int socketFlags, int socketWaitTime, boolean socketHeartbeat, boolean socketAcknowledge, ZmqSocketListener socketListener, ZmqFilterPolicy filter, ZmqEventHandler handler, ZmqSocketMetrics metrics) {
        this.name = name;
        this.active = active;
        this.socket = socket;
        this.socketType = socketType;
        this.socketAddr = socketAddr;
        this.socketBound = socketBound;
        this.socketIncoming = socketIncoming;
        this.socketOutgoing = socketOutgoing;
        this.socketFlags = socketFlags;
        this.socketWaitTime = socketWaitTime;
        this.socketHeartbeat = socketHeartbeat;
        this.socketAcknowledge = socketAcknowledge;
        this.socketListener = socketListener;
        this.filter = filter;
        this.handler = handler;
        this.metrics = metrics;
    }

    public String getAddr() {
        return this.socketAddr;
    }

    public ZmqSocketMetrics getMetrics() {
        return this.metrics;
    }

    public boolean isBound() {
        return this.socketBound;
    }

    public boolean isIncoming() {
        return this.socketIncoming;
    }

    public boolean isOutgoing() {
        return this.socketOutgoing;
    }

    public boolean isHeartbeat() {
        return this.socketHeartbeat;
    }

    public boolean isAcknowledge() {
        return this.socketAcknowledge;
    }

    public ZmqSocketStatus getStatus() {
        return this.status;
    }

    public TrackEvent untrack(Object messageId) {
        return this.trackEventMap.remove(messageId);
    }

    public List<TrackEvent> untrackAll() {
        ArrayList<TrackEvent> untrackEvents = new ArrayList<TrackEvent>(this.trackEventMap.values());
        this.trackEventMap.clear();
        return untrackEvents;
    }

    public TrackEvent track(ZmqEvent event) {
        long messageSent = System.currentTimeMillis();
        Object messageId = event.getMessageId();
        TrackEvent tackEvent = new TrackEvent(event, messageSent);
        return this.trackEventMap.put(messageId, tackEvent);
    }

    public int trackedCount() {
        return this.trackEventMap.size();
    }

    public boolean isTracked(Object messageId) {
        return this.trackEventMap.containsKey(messageId);
    }

    protected void setStatus(ZmqSocketStatus status) {
        if (this.status != status) {
            this.status = status;
            this.metrics.setStatus(status);
            LOGGER.log(Level.INFO, "Socket [" + this.name + "@" + this.socketAddr + "] changed status: " + (Object)((Object)status));
        }
    }

    public void pause() {
        this.setStatus(ZmqSocketStatus.PAUSED);
        LOGGER.warning("Socket paused: " + this);
    }

    public long getLastReceiveTime() {
        return this.lastReceiveTime;
    }

    public long getLastSendTime() {
        return this.lastSendTime;
    }

    @Override
    public void run() {
        ZmqSocketStatus status;
        this.setStatus(ZmqSocketStatus.PENDING);
        while ((status = this.openSocket(this)) != ZmqSocketStatus.RUNNING && this.active.get()) {
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException ex) {
                LOGGER.warning("Opening of socket hibernation interrupted: " + this);
            }
            if (this.status == ZmqSocketStatus.PAUSED && this.active.get()) continue;
        }
        if (this.status == ZmqSocketStatus.RUNNING && this.active.get()) {
            if (this.socketOutgoing) {
                this.socket.setReceiveTimeOut(0);
            } else {
                this.socket.setReceiveTimeOut(this.socketWaitTime);
            }
            while (this.active.get()) {
                if (this.socketOutgoing) {
                    this.status = this.sendSocket(this);
                    if (this.status == ZmqSocketStatus.ERROR) break;
                }
                if (!this.socketIncoming) continue;
                this.status = this.receiveSocket(this);
                if (this.status == ZmqSocketStatus.ERROR) break;
            }
            if (this.socketHeartbeat && this.socketOutgoing && this.socketIncoming) {
                this.socket.setReceiveTimeOut(this.socketWaitTime);
                this.sendSocket(this);
            }
        }
        this.closeSocket(this);
        this.setStatus(ZmqSocketStatus.STOPPED);
    }

    protected ZmqSocketStatus openSocket(ZmqSocketSession socketSession) {
        String socketAddr = socketSession.socketAddr;
        ZMQ.Socket socket = socketSession.socket;
        boolean openSocket = this.socketListener.open(this);
        if (!openSocket) {
            this.setStatus(ZmqSocketStatus.PAUSED);
            return this.getStatus();
        }
        if (this.socketBound) {
            try {
                socket.bind(socketAddr);
            }
            catch (ZMQException ex) {
                if (ex.getErrorCode() == 48) {
                    this.setStatus(ZmqSocketStatus.PAUSED);
                    LOGGER.info("Bind socket UNSUCCESSFUL (Already Bound): " + this);
                    return this.getStatus();
                }
                LOGGER.log(Level.SEVERE, "Socket binding failure: " + this);
                this.setStatus(ZmqSocketStatus.ERROR);
                throw ex;
            }
            LOGGER.info("Bind socket successful: " + this);
        } else {
            try {
                socket.connect(socketAddr);
            }
            catch (Exception ex) {
                LOGGER.log(Level.SEVERE, "Socket connect failure: " + this, ex);
                this.setStatus(ZmqSocketStatus.ERROR);
                throw ex;
            }
            LOGGER.info("Connect socket successful: " + this);
        }
        this.setStatus(ZmqSocketStatus.RUNNING);
        return this.getStatus();
    }

    protected ZmqSocketStatus closeSocket(ZmqSocketSession socketSession) {
        String socketAddr = socketSession.socketAddr;
        ZMQ.Socket socket = socketSession.socket;
        if (this.socketBound) {
            try {
                socket.setLinger(0L);
                socket.unbind(socketAddr);
                socket.close();
            }
            catch (Exception ex) {
                LOGGER.log(Level.SEVERE, "Socketing unbind failure: " + this, ex);
                throw ex;
            }
            LOGGER.info("Unbind socket successful: " + this);
        } else {
            try {
                socket.setLinger(0L);
                socket.disconnect(socketAddr);
                socket.close();
            }
            catch (Exception ex) {
                LOGGER.log(Level.SEVERE, "Socket disconnect failure: " + this, ex);
                throw ex;
            }
            LOGGER.info("Disconnect socket successful: " + this);
        }
        this.setStatus(ZmqSocketStatus.STOPPED);
        this.socketListener.close(this);
        return this.getStatus();
    }

    protected ZmqSocketStatus sendSocket(ZmqSocketSession socketSession) {
        block6: {
            ZmqEvent socketEvent = null;
            try {
                if (this.socketListener == null) break block6;
                do {
                    if ((socketEvent = this.socketListener.send(this)) == null) continue;
                    ZMsg msg = this.handler.createMsg(this.socketType, this.filter, socketEvent);
                    boolean success = msg.send(this.socket, true);
                    if (success) {
                        this.metrics.incrementSend();
                        this.lastSendTime = System.nanoTime();
                        if (!LOGGER.isLoggable(Level.FINEST)) continue;
                        LOGGER.log(Level.FINEST, "Socket [" + this.name + "@" + this.socketAddr + "] sent message: " + socketEvent);
                        continue;
                    }
                    LOGGER.log(Level.WARNING, "Error (" + this.socket.base().errno() + ") on socket [" + this.name + "@" + this.socketAddr + "] and was unable to send message: " + socketEvent);
                    this.socketListener.error(this, socketEvent);
                    try {
                        Thread.sleep(3000L);
                    }
                    catch (InterruptedException ex) {
                        LOGGER.log(Level.SEVERE, "Socket [" + this.name + "@" + this.socketAddr + "] Session sleeping interuupted", ex);
                    }
                    break;
                } while (socketEvent != null && this.active.get());
            }
            catch (ZmqException ex) {
                LOGGER.log(Level.SEVERE, "Unable to send message due to internal error: " + this, (Throwable)((Object)ex));
                this.socketListener.error(this, socketEvent);
            }
        }
        return this.getStatus();
    }

    protected ZmqSocketStatus receiveSocket(ZmqSocketSession socketSession) {
        if (!this.active.get()) {
            return this.getStatus();
        }
        try {
            ZMsg msg = ZMsg.recvMsg((ZMQ.Socket)this.socket, (int)this.socketFlags);
            while (msg != null) {
                this.metrics.incrementReceive();
                this.lastReceiveTime = System.nanoTime();
                try {
                    ZmqEvent event = this.handler.createEvent(this.socketType, msg);
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.log(Level.FINEST, "Socket [" + this.name + "@" + this.socketAddr + "] recieved message: " + event);
                    }
                    if (event != null && this.socketListener != null) {
                        this.setStatus(ZmqSocketStatus.RUNNING);
                        ZmqEvent replyEvent = this.socketListener.receive(this, event);
                        if (replyEvent != null) {
                            if (this.socketIncoming) {
                                ZMsg replyMsg = this.handler.createMsg(this.socketType, this.filter, replyEvent);
                                replyMsg.send(this.socket, true);
                                this.metrics.incrementSend();
                                this.lastSendTime = System.nanoTime();
                            } else {
                                LOGGER.log(Level.SEVERE, "Socketing has not outgoing state: " + this);
                            }
                            if (LOGGER.isLoggable(Level.FINEST)) {
                                LOGGER.log(Level.FINEST, "Socket [" + this.name + "@" + this.socketAddr + "] sent response message: " + replyEvent);
                            }
                        }
                    }
                }
                catch (ZmqException ex) {
                    LOGGER.log(Level.SEVERE, "Socketing incoming failure: " + this, (Throwable)((Object)ex));
                }
                msg.destroy();
                msg = ZMsg.recvMsg((ZMQ.Socket)this.socket);
            }
        }
        catch (ZMQException ex) {
            this.setStatus(ZmqSocketStatus.ERROR);
            LOGGER.log(Level.SEVERE, "Socketing incoming failure: " + this, ex);
        }
        return this.getStatus();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.socketAddr == null ? 0 : this.socketAddr.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ZmqSocketSession other = (ZmqSocketSession)obj;
        return !(this.socketAddr == null ? other.socketAddr != null : !this.socketAddr.equals(other.socketAddr));
    }

    public String toString() {
        return "ZmqSocketSession [name=" + this.name + ", socketType=" + (Object)((Object)this.socketType) + ", socketAddr=" + this.socketAddr + ", socketBound=" + this.socketBound + ", socketIncoming=" + this.socketIncoming + ", socketOutgoing=" + this.socketOutgoing + ", socketFlags=" + this.socketFlags + ", socketWaitTime=" + this.socketWaitTime + ", socketHeartbeat=" + this.socketHeartbeat + ", socketAcknowledge=" + this.socketAcknowledge + "]";
    }

    public static final class TrackEvent {
        private final ZmqEvent event;
        private final long eventSent;

        TrackEvent(ZmqEvent event, long eventSent) {
            this.event = event;
            this.eventSent = eventSent;
        }

        public ZmqEvent getEvent() {
            return this.event;
        }

        public long getEventSent() {
            return this.eventSent;
        }

        public String toString() {
            return "TrackEvent [eventSent=" + this.eventSent + ", event=" + this.event + "]";
        }
    }
}

