/*
 * Decompiled with CFR 0.152.
 */
package org.zeromq.jms.util;

import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.zeromq.jms.annotation.ZmqUriParameter;

public class ClassUtils {
    private static final Logger LOGGER = Logger.getLogger(ClassUtils.class.getCanonicalName());

    private ClassUtils() {
    }

    public static Class<?> getClass(List<Class<?>> possibleClasses, Class<? extends Annotation> annotation, String name, String value) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Class<?> clazz = null;
        for (Class<?> possibleClass : possibleClasses) {
            if (possibleClass.isAnnotationPresent(annotation)) {
                Annotation annotationClass = possibleClass.getAnnotation(annotation);
                Class<? extends Annotation> type = annotationClass.annotationType();
                Method[] methodArray = type.getDeclaredMethods();
                int n = methodArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object attributeValue;
                    Method method = methodArray[n2];
                    if (method.getName().equals(name) && method.getParameterTypes().length == 0 && (attributeValue = method.invoke((Object)annotationClass, new Object[0])) != null && attributeValue.equals(value)) {
                        if (clazz != null) {
                            throw new IllegalStateException("Conflict with value (" + name + "=" + value + " ) between classes: " + clazz.getCanonicalName() + ", " + possibleClass.getCanonicalName());
                        }
                        clazz = possibleClass;
                    }
                    ++n2;
                }
            }
            if (!possibleClass.getSimpleName().equals(value)) continue;
            if (clazz != null) {
                throw new IllegalStateException("Conflict with value (" + name + "=" + value + " ) between classes: " + clazz.getCanonicalName() + ", " + possibleClass.getCanonicalName());
            }
            clazz = possibleClass;
        }
        if (clazz == null && value.contains(".")) {
            try {
                clazz = Class.forName(value);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return clazz;
    }

    public static Method getSetterMethod(Class<?> clazz, Class<? extends Annotation> annotation, String name, String value) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Method setterMethod = null;
        Method[] methodArray = clazz.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            String methodName;
            Method possibleMethod = methodArray[n2];
            if (possibleMethod.isAnnotationPresent(annotation)) {
                Annotation[] methodAnnotations;
                Annotation[] annotationArray = methodAnnotations = possibleMethod.getDeclaredAnnotations();
                int n3 = methodAnnotations.length;
                int n4 = 0;
                while (n4 < n3) {
                    Annotation methodAnnotation = annotationArray[n4];
                    if (annotation.isInstance(methodAnnotation)) {
                        Class<? extends Annotation> type = methodAnnotation.annotationType();
                        Method[] methodArray2 = type.getDeclaredMethods();
                        int n5 = methodArray2.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            Object attributeValue;
                            Method annotationMethod = methodArray2[n6];
                            if (annotationMethod.getName().equals(name) && annotationMethod.getParameterTypes().length == 0 && (attributeValue = annotationMethod.invoke((Object)methodAnnotation, new Object[0])) != null && attributeValue.equals(value)) {
                                if (setterMethod != null) {
                                    throw new IllegalStateException("Conflict with value (" + name + "=" + value + " ) between methods: " + setterMethod.getName() + ", " + possibleMethod.getName());
                                }
                                setterMethod = possibleMethod;
                            }
                            ++n6;
                        }
                    }
                    ++n4;
                }
            }
            if (possibleMethod.getParameterTypes().length == 1 && ((methodName = possibleMethod.getName()).equalsIgnoreCase(value) || methodName.equalsIgnoreCase("set" + value))) {
                if (setterMethod != null) {
                    throw new IllegalStateException("Conflict with value (" + name + "=" + value + " ) between methods: " + setterMethod.getName() + ", " + possibleMethod.getName());
                }
                setterMethod = possibleMethod;
            }
            ++n2;
        }
        return setterMethod;
    }

    public static List<Method> getMethods(Class<?> clazz, Class<? extends Annotation> annotation) {
        LinkedList<Method> annotatedMethods = new LinkedList<Method>();
        Method[] methodArray = clazz.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (method.isAnnotationPresent(annotation)) {
                annotatedMethods.add(method);
            }
            ++n2;
        }
        return annotatedMethods;
    }

    public static List<Class<?>> getClasses(String packageName, Class<? extends Annotation> annotation) throws ClassNotFoundException, IOException {
        List<Class<?>> classes = ClassUtils.getClasses(packageName);
        LinkedList annotatedClasses = new LinkedList();
        for (Class<?> clazz : classes) {
            if (!clazz.isAnnotationPresent(annotation)) continue;
            annotatedClasses.add(clazz);
        }
        return annotatedClasses;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean packageExists(String packageName) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        String path = packageName.replace('.', '/');
        try {
            URL resource;
            Enumeration<URL> resources = classLoader.getResources(path);
            do {
                if (resources.hasMoreElements()) continue;
                return true;
            } while ((resource = resources.nextElement()) != null);
            LOGGER.warning("Unable to retrieve resources from the package: " + packageName);
            return false;
        }
        catch (IOException ex) {
            LOGGER.warning("Unable to locate package: " + packageName);
            return false;
        }
    }

    public static List<Class<?>> getClasses(String basePackageName) throws ClassNotFoundException, IOException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        String path = basePackageName.replace('.', '/');
        Enumeration<URL> resources = classLoader.getResources(path);
        HashSet<File> dirs = new HashSet<File>();
        while (resources.hasMoreElements()) {
            URL resource = resources.nextElement();
            dirs.add(new File(resource.getFile()));
        }
        LinkedList classes = new LinkedList();
        for (File directory : dirs) {
            classes.addAll(ClassUtils.findClasses(directory, basePackageName));
        }
        return classes;
    }

    private static List<Class<?>> findClasses(File directory, String packageName) throws ClassNotFoundException {
        File[] files;
        LinkedList classes = new LinkedList();
        if (!directory.exists()) {
            return classes;
        }
        File[] fileArray = files = directory.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                classes.addAll(ClassUtils.findClasses(file, String.valueOf(packageName) + "." + file.getName()));
            } else if (file.getName().endsWith(".class")) {
                try {
                    classes.add(Class.forName(String.valueOf(packageName) + '.' + file.getName().substring(0, file.getName().length() - 6)));
                }
                catch (UnsupportedClassVersionError ex) {
                    LOGGER.log(Level.WARNING, "Unable to loader class " + file.getName() + " due to JVM version conflict: " + ex.getMessage());
                }
            }
            ++n2;
        }
        return classes;
    }

    public static void setMethods(Map<String, List<String>> parameters, Object config) throws ReflectiveOperationException {
        List<Method> methods = ClassUtils.getMethods(config.getClass(), ZmqUriParameter.class);
        for (Method method : methods) {
            String paramValue;
            ZmqUriParameter attribute = method.getAnnotation(ZmqUriParameter.class);
            String paramName = attribute.value();
            List<String> paramValues = parameters.get(paramName);
            String string = paramValue = paramValues == null || paramValues.size() == 0 ? null : paramValues.get(0);
            if (paramValue == null) continue;
            Object value = null;
            Class<?>[] paramTypes = method.getParameterTypes();
            if (paramTypes != null && paramTypes.length == 1) {
                Class<Object> paramType = paramTypes[0];
                if (paramType == Integer.TYPE || paramType.isAssignableFrom(Integer.class)) {
                    value = Integer.parseInt(paramValue);
                } else if (paramType == Long.TYPE || paramType.isAssignableFrom(Long.class)) {
                    value = Long.parseLong(paramValue);
                } else if (paramType == Short.TYPE || paramType.isAssignableFrom(Short.class)) {
                    value = Short.decode(paramValue);
                } else if (paramType == Double.TYPE || paramType.isAssignableFrom(Double.class)) {
                    value = Double.parseDouble(paramValue);
                } else if (paramType == Float.TYPE || paramType.isAssignableFrom(Float.class)) {
                    value = Float.valueOf(Float.parseFloat(paramValue));
                } else if (paramType == Boolean.TYPE || paramType.isAssignableFrom(Boolean.class)) {
                    value = Boolean.parseBoolean(paramValue);
                } else if (paramType.isAssignableFrom(byte[].class)) {
                    value = paramValue.getBytes();
                } else if (paramType.isAssignableFrom(String.class)) {
                    value = paramValue;
                } else if (paramType.isEnum()) {
                    value = Enum.valueOf(paramType, paramValue);
                } else {
                    throw new UnsupportedOperationException("Unable to map parameter [" + paramName + "] with value [" + paramValue + "] to required type: " + paramType);
                }
            }
            if (value == null) continue;
            try {
                LOGGER.info("Setting configuration parameter " + paramName + "=" + paramValue + " on: " + config);
                method.invoke(config, value);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
                LOGGER.log(Level.SEVERE, "Unable to invoke setter method: " + method.getName() + "(" + value + ")", ex);
                throw ex;
            }
        }
    }
}

