/*
 * Decompiled with CFR 0.152.
 */
package org.zeromq.jms.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class ExtendedLogFormatter
extends Formatter {
    @Override
    public String format(LogRecord record) {
        Object[] arguments = new Object[6];
        arguments[0] = new Date(record.getMillis());
        arguments[1] = record.getLevel().getName();
        arguments[2] = Thread.currentThread().getName();
        arguments[3] = String.valueOf(this.compactClassName(record.getSourceClassName())) + "." + record.getSourceMethodName();
        Throwable thrown = record.getThrown();
        if (thrown == null) {
            arguments[4] = record.getMessage();
        } else {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            printWriter.println(record.getMessage());
            thrown.printStackTrace(printWriter);
            arguments[4] = stringWriter.toString();
        }
        return String.format("%1$tF %1$tT:%1$tL %2$7s --- [%3$17s] %4$-60s : %5$s\n", arguments);
    }

    private String compactClassName(String canonicalName) {
        StringBuilder builder = new StringBuilder();
        int prevPos = 0;
        int nextPos = 0;
        do {
            if ((nextPos = canonicalName.indexOf(".", nextPos + 1)) <= 0) continue;
            builder.append(canonicalName.charAt(prevPos)).append(".");
            prevPos = nextPos + 1;
        } while (nextPos > 0);
        builder.append(canonicalName.substring(prevPos));
        return builder.toString();
    }
}

