/*
 * Decompiled with CFR 0.152.
 */
package org.zeromq.jms.util;

import java.util.concurrent.TimeUnit;

public class Stopwatch {
    private final long start = System.nanoTime();

    public long lapsedTime(TimeUnit unit) {
        long now = System.nanoTime();
        return unit.convert(now - this.start, TimeUnit.NANOSECONDS);
    }

    public long lapsedTime() {
        return this.lapsedTime(TimeUnit.MILLISECONDS);
    }

    public boolean sleep(long waitTime, TimeUnit unit) {
        long waitNanoseconds = TimeUnit.NANOSECONDS.convert(waitTime, unit);
        long waitMilliseconds = TimeUnit.MILLISECONDS.convert(waitTime, unit);
        int waitNanoAjustementNano = (int)waitNanoseconds % 1000;
        try {
            Thread.sleep(waitMilliseconds, waitNanoAjustementNano);
        }
        catch (InterruptedException ex) {
            return false;
        }
        return true;
    }

    public boolean sleep(long millis) {
        return this.sleep(millis, TimeUnit.MILLISECONDS);
    }

    public boolean before(long time, TimeUnit unit) {
        long waitNanoseconds = TimeUnit.NANOSECONDS.convert(time, unit);
        long lapsedTime = this.lapsedTime(TimeUnit.NANOSECONDS);
        return lapsedTime < waitNanoseconds;
    }

    public boolean before(long millis) {
        return this.before(millis, TimeUnit.MILLISECONDS);
    }

    public String toString() {
        return "Stopwatch [elapsedTime=" + this.lapsedTime() + "]";
    }
}

