/*
 * Decompiled with CFR 0.152.
 */
package zmq.poll;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import zmq.poll.IPollEvents;
import zmq.util.Clock;
import zmq.util.MultiMap;

abstract class PollerBase
implements Runnable {
    private final AtomicInteger load;
    private final MultiMap<Long, TimerInfo> timers;
    protected final Thread worker;

    protected PollerBase(String name) {
        this.worker = new Thread((Runnable)this, name);
        this.worker.setDaemon(true);
        this.load = new AtomicInteger(0);
        this.timers = new MultiMap();
    }

    public final int getLoad() {
        return this.load.get();
    }

    protected void adjustLoad(int amount) {
        this.load.addAndGet(amount);
    }

    public void addTimer(long timeout, IPollEvents sink, int id) {
        assert (Thread.currentThread() == this.worker);
        long expiration = Clock.nowMS() + timeout;
        TimerInfo info = new TimerInfo(sink, id);
        this.timers.insert(expiration, info);
    }

    public void cancelTimer(IPollEvents sink, int id) {
        assert (Thread.currentThread() == this.worker);
        TimerInfo copy = new TimerInfo(sink, id);
        TimerInfo timerInfo = this.timers.find(copy);
        assert (timerInfo != null);
        timerInfo.cancelled = true;
    }

    protected long executeTimers() {
        assert (Thread.currentThread() == this.worker);
        if (this.timers.isEmpty()) {
            return 0L;
        }
        long current = Clock.nowMS();
        for (Map.Entry<TimerInfo, Long> entry : this.timers.entries()) {
            TimerInfo timerInfo = entry.getKey();
            if (timerInfo.cancelled) {
                this.timers.remove(entry);
                continue;
            }
            Long key = entry.getValue();
            if (key > current) {
                return key - current;
            }
            if (!timerInfo.cancelled) {
                timerInfo.sink.timerEvent(timerInfo.id);
            }
            this.timers.remove(entry);
        }
        return 0L;
    }

    private static final class TimerInfo {
        private final IPollEvents sink;
        private final int id;
        private boolean cancelled;

        public TimerInfo(IPollEvents sink, int id) {
            this.sink = sink;
            this.id = id;
        }

        public int hashCode() {
            return Objects.hash(this.id, this.sink);
        }

        public boolean equals(Object obj) {
            if (obj instanceof TimerInfo) {
                TimerInfo other = (TimerInfo)obj;
                return this.id == other.id && Objects.equals(this.sink, other.sink);
            }
            return false;
        }

        public String toString() {
            return "TimerInfo [id=" + this.id + ", sink=" + this.sink + "]";
        }
    }
}

