/*
 * Decompiled with CFR 0.152.
 */
package zmq.socket.reqrep;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import zmq.Ctx;
import zmq.Msg;
import zmq.Options;
import zmq.SocketBase;
import zmq.ZMQ;
import zmq.pipe.Pipe;
import zmq.socket.FQ;
import zmq.util.Blob;
import zmq.util.Utils;
import zmq.util.ValueReference;
import zmq.util.Wire;

public class Router
extends SocketBase {
    private final FQ fq;
    private boolean prefetched = false;
    private boolean identitySent = false;
    private Msg prefetchedId;
    private Msg prefetchedMsg;
    private boolean moreIn = false;
    private final Set<Pipe> anonymousPipes;
    private final Map<Blob, Outpipe> outpipes;
    private Pipe currentOut = null;
    private boolean moreOut = false;
    private int nextRid = Utils.randomInt();
    private boolean mandatory = false;
    private boolean rawSocket = false;
    private boolean probeRouter;
    private boolean handover = false;

    public Router(Ctx parent, int tid, int sid) {
        super(parent, tid, sid);
        this.options.type = 6;
        this.options.recvIdentity = true;
        this.options.rawSocket = false;
        this.fq = new FQ();
        this.prefetchedId = new Msg();
        this.prefetchedMsg = new Msg();
        this.anonymousPipes = new HashSet<Pipe>();
        this.outpipes = new HashMap<Blob, Outpipe>();
    }

    @Override
    protected void destroy() {
        assert (this.anonymousPipes.isEmpty());
        assert (this.outpipes.isEmpty());
        super.destroy();
    }

    @Override
    public void xattachPipe(Pipe pipe, boolean subscribe2all) {
        boolean identityOk;
        assert (pipe != null);
        if (this.probeRouter) {
            Msg probe = new Msg();
            pipe.write(probe);
            pipe.flush();
        }
        if (identityOk = this.identifyPeer(pipe)) {
            this.fq.attach(pipe);
        } else {
            this.anonymousPipes.add(pipe);
        }
    }

    @Override
    public boolean xsetsockopt(int option, Object optval) {
        if (option == 61) {
            this.connectRid = Options.parseString(option, optval);
            return true;
        }
        if (option == 41) {
            this.rawSocket = Options.parseBoolean(option, optval);
            if (this.rawSocket) {
                this.options.recvIdentity = false;
                this.options.rawSocket = true;
            }
            return true;
        }
        if (option == 33) {
            this.mandatory = Options.parseBoolean(option, optval);
            return true;
        }
        if (option == 51) {
            this.probeRouter = Options.parseBoolean(option, optval);
            return true;
        }
        if (option == 56) {
            this.handover = Options.parseBoolean(option, optval);
            return true;
        }
        this.errno.set(22);
        return false;
    }

    @Override
    public void xpipeTerminated(Pipe pipe) {
        if (!this.anonymousPipes.remove(pipe)) {
            Outpipe old = this.outpipes.remove(pipe.getIdentity());
            assert (old != null);
            this.fq.terminated(pipe);
            if (pipe == this.currentOut) {
                this.currentOut = null;
            }
        }
    }

    @Override
    public void xreadActivated(Pipe pipe) {
        if (!this.anonymousPipes.contains(pipe)) {
            this.fq.activated(pipe);
        } else {
            boolean identityOk = this.identifyPeer(pipe);
            if (identityOk) {
                this.anonymousPipes.remove(pipe);
                this.fq.attach(pipe);
            }
        }
    }

    @Override
    public void xwriteActivated(Pipe pipe) {
        for (Outpipe out : this.outpipes.values()) {
            if (out.pipe != pipe) continue;
            assert (!out.active);
            out.active = true;
            break;
        }
    }

    @Override
    protected boolean xsend(Msg msg) {
        if (!this.moreOut) {
            assert (this.currentOut == null);
            if (msg.hasMore()) {
                this.moreOut = true;
                Blob identity = Blob.createBlob(msg);
                Outpipe op = this.outpipes.get(identity);
                if (op != null) {
                    this.currentOut = op.pipe;
                    if (!this.currentOut.checkWrite()) {
                        op.active = false;
                        this.currentOut = null;
                        if (this.mandatory) {
                            this.moreOut = false;
                            this.errno.set(35);
                            return false;
                        }
                    }
                } else if (this.mandatory) {
                    this.moreOut = false;
                    this.errno.set(65);
                    return false;
                }
            }
            return true;
        }
        if (this.options.rawSocket) {
            msg.resetFlags(1);
        }
        this.moreOut = msg.hasMore();
        if (this.currentOut != null) {
            if (this.rawSocket && msg.size() == 0) {
                this.currentOut.terminate(false);
                this.currentOut = null;
                return true;
            }
            boolean ok = this.currentOut.write(msg);
            if (!ok) {
                this.currentOut = null;
            } else if (!this.moreOut) {
                this.currentOut.flush();
                this.currentOut = null;
            }
        }
        return true;
    }

    @Override
    protected Msg xrecv() {
        Msg msg = null;
        if (this.prefetched) {
            if (!this.identitySent) {
                msg = this.prefetchedId;
                this.prefetchedId = null;
                this.identitySent = true;
            } else {
                msg = this.prefetchedMsg;
                this.prefetchedMsg = null;
                this.prefetched = false;
            }
            this.moreIn = msg.hasMore();
            return msg;
        }
        ValueReference<Pipe> pipe = new ValueReference<Pipe>();
        msg = this.fq.recvPipe(this.errno, pipe);
        while (msg != null && msg.isIdentity()) {
            msg = this.fq.recvPipe(this.errno, pipe);
        }
        if (msg == null) {
            return null;
        }
        assert (pipe.get() != null);
        if (this.moreIn) {
            this.moreIn = msg.hasMore();
        } else {
            this.prefetchedMsg = msg;
            this.prefetched = true;
            Blob identity = pipe.get().getIdentity();
            msg = new Msg(identity.data());
            msg.setFlags(1);
            this.identitySent = true;
        }
        return msg;
    }

    protected boolean rollback() {
        if (this.currentOut != null) {
            this.currentOut.rollback();
            this.currentOut = null;
            this.moreOut = false;
        }
        return true;
    }

    @Override
    protected boolean xhasIn() {
        if (this.moreIn) {
            return true;
        }
        if (this.prefetched) {
            return true;
        }
        ValueReference<Pipe> pipe = new ValueReference<Pipe>();
        this.prefetchedMsg = this.fq.recvPipe(this.errno, pipe);
        while (this.prefetchedMsg != null && this.prefetchedMsg.isIdentity()) {
            this.prefetchedMsg = this.fq.recvPipe(this.errno, pipe);
        }
        if (this.prefetchedMsg == null) {
            return false;
        }
        assert (pipe.get() != null);
        Blob identity = pipe.get().getIdentity();
        this.prefetchedId = new Msg(identity.data());
        this.prefetchedId.setFlags(1);
        this.prefetched = true;
        this.identitySent = false;
        return true;
    }

    @Override
    protected boolean xhasOut() {
        return true;
    }

    @Override
    protected Blob getCredential() {
        return this.fq.getCredential();
    }

    private boolean identifyPeer(Pipe pipe) {
        Outpipe outpipe;
        Blob identity;
        if (this.connectRid != null && !this.connectRid.isEmpty()) {
            identity = Blob.createBlob(this.connectRid.getBytes(ZMQ.CHARSET));
            this.connectRid = null;
            outpipe = this.outpipes.get(identity);
            assert (outpipe == null);
        } else if (this.options.rawSocket) {
            ByteBuffer buffer = ByteBuffer.allocate(5);
            buffer.put((byte)0);
            Wire.putUInt32(buffer, this.nextRid++);
            identity = Blob.createBlob(buffer.array());
        } else {
            Msg msg = pipe.read();
            if (msg == null) {
                return false;
            }
            if (msg.size() == 0) {
                ByteBuffer buf = ByteBuffer.allocate(5);
                buf.put((byte)0);
                Wire.putUInt32(buf, this.nextRid++);
                identity = Blob.createBlob(buf.array());
            } else {
                identity = Blob.createBlob(msg);
                if (this.outpipes.containsKey(identity)) {
                    if (!this.handover) {
                        return false;
                    }
                    ByteBuffer buf = ByteBuffer.allocate(5);
                    buf.put((byte)0);
                    Wire.putUInt32(buf, this.nextRid++);
                    Blob newIdentity = Blob.createBlob(buf.array());
                    Outpipe existingOutpipe = this.outpipes.remove(identity);
                    existingOutpipe.pipe.setIdentity(newIdentity);
                    this.outpipes.put(newIdentity, existingOutpipe);
                    existingOutpipe.pipe.terminate(true);
                }
            }
        }
        pipe.setIdentity(identity);
        outpipe = new Outpipe(pipe, true);
        this.outpipes.put(identity, outpipe);
        return true;
    }

    class Outpipe {
        private Pipe pipe;
        private boolean active;

        public Outpipe(Pipe pipe, boolean active) {
            this.pipe = pipe;
            this.active = active;
        }
    }
}

