/*
 * Decompiled with CFR 0.152.
 */
package org.zeromq;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ZConfig {
    private static final String LEFT = "^( *)([0-9a-zA-Z\\$\\-_@\\.&\\+\\/]+)";
    private static final Pattern PTRN_CONTAINER = Pattern.compile("^( *)([0-9a-zA-Z\\$\\-_@\\.&\\+\\/]+)( *#.*)?$");
    private static final Pattern PTRN_KEYVALUE = Pattern.compile("^( *)([0-9a-zA-Z\\$\\-_@\\.&\\+\\/]+) = ((\"|')(.*)(\\4)|(.*?))(#.*)?$");
    private final String name;
    private final Map<String, ZConfig> children = new HashMap<String, ZConfig>();
    private final List<String> comments = new LinkedList<String>();
    private String value;

    public ZConfig(String name, ZConfig parent) {
        this.name = name;
        if (parent != null) {
            parent.children.put(name, this);
        }
    }

    public ZConfig getChild(String name) {
        return this.children.get(name);
    }

    public Map<String, String> getValues() {
        HashMap<String, String> values = new HashMap<String, String>();
        this.fillValues("", values);
        return values;
    }

    private void fillValues(String prefix, Map<String, String> values) {
        for (Map.Entry<String, ZConfig> entry : this.children.entrySet()) {
            String key = entry.getKey();
            ZConfig child = entry.getValue();
            assert (child != null);
            if (child.value != null) {
                values.put(prefix + key, child.value);
            }
            child.fillValues(prefix + key + '/', values);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getValue(String path) {
        return this.getValue(path, null);
    }

    public String getValue(String path, String defaultValue) {
        String[] pathElements = path.split("/");
        ZConfig current = this;
        for (String pathElem : pathElements) {
            if (pathElem.isEmpty() || (current = current.children.get(pathElem)) != null) continue;
            return defaultValue;
        }
        return current.value;
    }

    public boolean pathExists(String path) {
        String[] pathElements = path.split("/");
        ZConfig current = this;
        for (String pathElem : pathElements) {
            if (pathElem.isEmpty() || (current = current.children.get(pathElem)) != null) continue;
            return false;
        }
        return true;
    }

    public void addComment(String comment) {
        this.comments.add(comment);
    }

    public ZConfig putValue(String path, String value) {
        String[] pathElements = path.split("/");
        ZConfig current = this;
        for (String pathElement : pathElements) {
            if (pathElement.isEmpty()) continue;
            ZConfig container = current.children.get(pathElement);
            if (container == null) {
                container = new ZConfig(pathElement, current);
            }
            current = container;
        }
        current.value = value;
        return current;
    }

    private void visit(ZConfig startNode, IVisitor handler, int level) throws IOException {
        handler.handleNode(startNode, level);
        for (ZConfig node : startNode.children.values()) {
            this.visit(node, handler, level + 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File save(String filename) throws IOException {
        if (filename.equals("-")) {
            try (PrintWriter writer = new PrintWriter(System.out);){
                this.save(writer);
            }
            return null;
        }
        File file = new File(filename);
        if (file.exists()) {
            file.delete();
        } else {
            file.getParentFile().mkdirs();
        }
        try (FileWriter writer = new FileWriter(file);){
            this.save(writer);
        }
        return file;
    }

    public void save(final Writer writer) throws IOException {
        this.visit(this, new IVisitor(){

            @Override
            public void handleNode(ZConfig node, int level) throws IOException {
                if (node.comments.size() > 0) {
                    for (String comment : node.comments) {
                        writer.append("# ").append(comment).append('\n');
                    }
                    writer.append("\n");
                }
                if (level > 0) {
                    String prefix = level > 1 ? String.format("%" + (level - 1) * 4 + "s", " ") : "";
                    writer.append(prefix);
                    if (node.value == null) {
                        writer.append(node.name).append("\n");
                    } else {
                        writer.append(String.format("%s = \"%s\"\n", node.name, node.value));
                    }
                }
            }
        }, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ZConfig load(String filename) throws IOException {
        try (BufferedReader reader = new BufferedReader(new FileReader(filename));){
            ArrayList<String> content = new ArrayList<String>();
            String line = reader.readLine();
            while (line != null) {
                boolean irrelevant;
                boolean bl = irrelevant = line.matches("^ *#.*|^ *[0-9]+.*") || line.trim().isEmpty();
                if (!irrelevant) {
                    content.add(line);
                }
                line = reader.readLine();
            }
            ZConfig zConfig = ZConfig.load(new ZConfig("root", null), content, 0, new AtomicInteger());
            return zConfig;
        }
    }

    private static ZConfig load(ZConfig parent, List<String> content, int currentLevel, AtomicInteger lineNumber) {
        while (lineNumber.get() < content.size()) {
            String currentLine = content.get(lineNumber.get());
            Matcher container = PTRN_CONTAINER.matcher(currentLine);
            if (container.find()) {
                ZConfig child = ZConfig.child(parent, container, currentLevel, currentLine, lineNumber);
                if (child == null) break;
                ZConfig.load(child, content, currentLevel + 1, lineNumber);
                continue;
            }
            Matcher keyvalue = PTRN_KEYVALUE.matcher(currentLine);
            if (keyvalue.find()) {
                ZConfig child = ZConfig.child(parent, keyvalue, currentLevel, currentLine, lineNumber);
                if (child == null) break;
                String value = keyvalue.group(5);
                if (value == null) {
                    value = keyvalue.group(7);
                }
                if (value != null) {
                    value = value.trim();
                }
                child.value = value;
                continue;
            }
            throw new ReadException("Couldn't process line", currentLine, lineNumber);
        }
        return parent;
    }

    private static ZConfig child(ZConfig parent, Matcher matcher, int currentLevel, String currentLine, AtomicInteger lineNumber) {
        int level = matcher.group(1).length() / 4;
        if (level > currentLevel) {
            throw new ReadException("Level mismatch in line", currentLine, lineNumber);
        }
        if (level < currentLevel) {
            return null;
        }
        lineNumber.incrementAndGet();
        return new ZConfig(matcher.group(2), parent);
    }

    public static class ReadException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        public final int currentLineNumber;
        public final String currentLine;

        public ReadException(String message, String currentLine, AtomicInteger currentLineNumber) {
            super(String.format("%s %s: %s", message, currentLineNumber, currentLine));
            this.currentLine = currentLine;
            this.currentLineNumber = currentLineNumber.get();
        }
    }

    private static interface IVisitor {
        public void handleNode(ZConfig var1, int var2) throws IOException;
    }
}

