/*
 * Decompiled with CFR 0.152.
 */
package org.zeromq;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.DatagramChannel;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.zeromq.Utils;
import zmq.util.Objects;

public class ZBeacon {
    public static final long DEFAULT_BROADCAST_INTERVAL = 1000L;
    public static final String DEFAULT_BROADCAST_HOST = "255.255.255.255";
    private static final InetAddress DEFAULT_BROADCAST_HOST_ADDRESS;
    private static final InetAddress DEFAULT_BROADCAST_ADDRESS;
    private final BroadcastClient broadcastClient;
    private final BroadcastServer broadcastServer;
    private final AtomicReference<byte[]> prefix = new AtomicReference();
    private final AtomicReference<byte[]> beacon = new AtomicReference();
    private final AtomicLong broadcastInterval = new AtomicLong(1000L);
    private final AtomicReference<Listener> listener = new AtomicReference();
    private final AtomicReference<Thread.UncaughtExceptionHandler> clientExHandler = new AtomicReference();
    private final AtomicReference<Thread.UncaughtExceptionHandler> serverExHandler = new AtomicReference();

    public ZBeacon(int port, byte[] beacon) {
        this(DEFAULT_BROADCAST_HOST, port, beacon);
    }

    public ZBeacon(String host, int port, byte[] beacon) {
        this(host, port, beacon, true);
    }

    public ZBeacon(String host, int port, byte[] beacon, boolean ignoreLocalAddress) {
        this(host, port, beacon, ignoreLocalAddress, false);
    }

    public ZBeacon(String host, int port, byte[] beacon, boolean ignoreLocalAddress, boolean blocking) {
        this(host, DEFAULT_BROADCAST_ADDRESS.getAddress(), port, beacon, 1000L, ignoreLocalAddress, blocking);
    }

    public ZBeacon(InetAddress broadcastAddress, InetAddress serverAddress, int port, byte[] beacon, long broadcastInterval, boolean ignoreLocalAddress, boolean blocking) {
        Objects.requireNonNull(broadcastAddress, "Host cannot be null");
        Objects.requireNonNull(serverAddress, "Server address cannot be null");
        Objects.requireNonNull(beacon, "Beacon cannot be null");
        this.broadcastInterval.set(broadcastInterval);
        this.beacon.set(Arrays.copyOf(beacon, beacon.length));
        this.broadcastServer = new BroadcastServer(port, ignoreLocalAddress);
        this.broadcastClient = new BroadcastClient(serverAddress, broadcastAddress, port, this.broadcastInterval);
    }

    @Deprecated
    public ZBeacon(String broadcastAddress, byte[] serverAddress, int port, byte[] beacon, long broadcastInterval, boolean ignoreLocalAddress, boolean blocking) {
        Objects.requireNonNull(broadcastAddress, "Host cannot be null");
        Objects.requireNonNull(serverAddress, "Server address cannot be null");
        Objects.requireNonNull(beacon, "Beacon cannot be null");
        this.broadcastInterval.set(broadcastInterval);
        this.beacon.set(Arrays.copyOf(beacon, beacon.length));
        this.broadcastServer = new BroadcastServer(port, ignoreLocalAddress);
        try {
            this.broadcastClient = new BroadcastClient(InetAddress.getByAddress(serverAddress), InetAddress.getByName(broadcastAddress), port, this.broadcastInterval);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("Invalid server address", e);
        }
    }

    @Deprecated
    public void setUncaughtExceptionHandlers(Thread.UncaughtExceptionHandler clientExHandler, Thread.UncaughtExceptionHandler serverExHandler) {
        this.clientExHandler.set(clientExHandler);
        this.serverExHandler.set(serverExHandler);
    }

    public void startClient() {
        if (!this.broadcastClient.isRunning) {
            if (this.broadcastClient.thread == null) {
                this.broadcastClient.thread = new Thread(this.broadcastClient);
                this.broadcastClient.thread.setName("ZBeacon Client Thread");
                this.broadcastClient.thread.setDaemon(true);
                this.broadcastClient.thread.setUncaughtExceptionHandler(this.clientExHandler.get());
            }
            this.broadcastClient.thread.start();
        }
    }

    public void startServer() {
        if (!this.broadcastServer.isRunning && this.listener.get() != null) {
            if (this.broadcastServer.thread == null) {
                this.broadcastServer.thread = new Thread(this.broadcastServer);
                this.broadcastServer.thread.setName("ZBeacon Server Thread");
                this.broadcastServer.thread.setDaemon(true);
                this.broadcastServer.thread.setUncaughtExceptionHandler(this.serverExHandler.get());
            }
            this.broadcastServer.thread.start();
        }
    }

    public void start() {
        this.startClient();
        this.startServer();
    }

    public void stop() throws InterruptedException {
        if (this.broadcastClient.thread != null) {
            this.broadcastClient.thread.interrupt();
            this.broadcastClient.thread.join();
        }
        if (this.broadcastServer.thread != null) {
            this.broadcastServer.thread.interrupt();
            this.broadcastServer.thread.join();
        }
    }

    @Deprecated
    public void setBeacon(byte[] beacon) {
        this.beacon.set(Arrays.copyOf(beacon, beacon.length));
    }

    public byte[] getBeacon() {
        byte[] beaconBuffer = this.beacon.get();
        return Arrays.copyOf(beaconBuffer, beaconBuffer.length);
    }

    @Deprecated
    public void setPrefix(byte[] prefix) {
        this.prefix.set(Arrays.copyOf(prefix, prefix.length));
    }

    public byte[] getPrefix() {
        byte[] prefixBuffer = this.prefix.get();
        return Arrays.copyOf(prefixBuffer, prefixBuffer.length);
    }

    @Deprecated
    public void setListener(Listener listener) {
        this.listener.set(listener);
    }

    public Listener getListener() {
        return this.listener.get();
    }

    public long getBroadcastInterval() {
        return this.broadcastInterval.get();
    }

    public void setBroadcastInterval(long broadcastInterval) {
        this.broadcastInterval.set(broadcastInterval);
    }

    static /* synthetic */ InetAddress access$000() {
        return DEFAULT_BROADCAST_HOST_ADDRESS;
    }

    static /* synthetic */ InetAddress access$100() {
        return DEFAULT_BROADCAST_ADDRESS;
    }

    static {
        try {
            DEFAULT_BROADCAST_HOST_ADDRESS = InetAddress.getByName(DEFAULT_BROADCAST_HOST);
            DEFAULT_BROADCAST_ADDRESS = InetAddress.getByName("0.0.0.0");
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("Invalid default broadcast address", e);
        }
    }

    private class BroadcastServer
    implements Runnable {
        private final DatagramChannel handle;
        private final boolean ignoreLocalAddress;
        private Thread thread;
        private boolean isRunning;

        public BroadcastServer(int port, boolean ignoreLocalAddress) {
            this.ignoreLocalAddress = ignoreLocalAddress;
            try {
                this.handle = DatagramChannel.open();
                this.handle.configureBlocking(true);
                this.handle.socket().setReuseAddress(true);
                this.handle.socket().bind(new InetSocketAddress(port));
            }
            catch (IOException ioException) {
                throw new RuntimeException(ioException);
            }
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK], 7[WHILELOOP]], but top level block is 8[SIMPLE_IF_TAKEN]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private void handleMessage(ByteBuffer buffer, InetAddress from) {
            byte[] prefix = (byte[])ZBeacon.this.prefix.get();
            if (buffer.remaining() < prefix.length) {
                return;
            }
            buffer.flip();
            buffer.mark();
            byte[] prefixTry = new byte[prefix.length];
            buffer.get(prefixTry);
            if (Arrays.equals(prefix, prefixTry)) {
                buffer.reset();
                byte[] content = new byte[buffer.remaining()];
                buffer.get(content);
                ((Listener)ZBeacon.this.listener.get()).onBeacon(from, content);
            }
        }
    }

    private class BroadcastClient
    implements Runnable {
        private final InetSocketAddress broadcastAddress;
        private final InetAddress interfaceAddress;
        private final AtomicLong broadcastInterval;
        private boolean isRunning;
        private Thread thread;

        public BroadcastClient(InetAddress interfaceAddress, InetAddress broadcastAddress, int port, AtomicLong broadcastInterval) {
            this.broadcastInterval = broadcastInterval;
            this.broadcastAddress = new InetSocketAddress(broadcastAddress, port);
            this.interfaceAddress = interfaceAddress;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            try (DatagramChannel broadcastChannel = DatagramChannel.open();){
                broadcastChannel.socket().setBroadcast(true);
                broadcastChannel.socket().setReuseAddress(true);
                broadcastChannel.socket().bind(new InetSocketAddress(this.interfaceAddress, 0));
                broadcastChannel.connect(this.broadcastAddress);
                this.isRunning = true;
                while (!Thread.interrupted() && this.isRunning) {
                    try {
                        broadcastChannel.send(ByteBuffer.wrap((byte[])ZBeacon.this.beacon.get()), this.broadcastAddress);
                        Thread.sleep(this.broadcastInterval.get());
                    }
                    catch (InterruptedException | ClosedByInterruptException interruptedException) {
                        Thread.currentThread().interrupt();
                        return;
                    }
                    catch (Exception exception) {
                        throw new RuntimeException(exception);
                        return;
                    }
                }
            }
            catch (IOException ioException) {
                throw new RuntimeException(ioException);
            }
            finally {
                this.isRunning = false;
                this.thread = null;
            }
        }
    }

    public static interface Listener {
        public void onBeacon(InetAddress var1, byte[] var2);
    }

    public static class Builder {
        private InetAddress clientHost = ZBeacon.access$000();
        private InetAddress serverAddr = ZBeacon.access$100();
        private int port;
        private long broadcastInterval = 1000L;
        private byte[] beacon;
        private boolean ignoreLocalAddress = true;
        private boolean blocking = false;
        private Listener listener = null;
        private byte[] prefix = null;
        private Thread.UncaughtExceptionHandler clientExHandler = null;
        private Thread.UncaughtExceptionHandler serverExHandler = null;

        public Builder port(int port) {
            this.port = port;
            return this;
        }

        public Builder beacon(byte[] beacon) {
            this.beacon = beacon;
            return this;
        }

        @Deprecated
        public Builder client(String host) {
            try {
                this.clientHost = InetAddress.getByName(host);
            }
            catch (UnknownHostException e) {
                throw new IllegalArgumentException("Invalid server address", e);
            }
            return this;
        }

        public Builder client(InetAddress host) {
            this.clientHost = host;
            return this;
        }

        @Deprecated
        public Builder server(byte[] addr) {
            Utils.checkArgument(addr.length == 4 || addr.length == 16, "Server Address has to be 4 or 16 bytes long");
            try {
                this.serverAddr = InetAddress.getByAddress(addr);
            }
            catch (UnknownHostException e) {
                throw new IllegalArgumentException("Invalid server address", e);
            }
            return this;
        }

        public Builder server(InetAddress addr) {
            this.serverAddr = addr;
            return this;
        }

        public Builder ignoreLocalAddress(boolean ignoreLocalAddress) {
            this.ignoreLocalAddress = ignoreLocalAddress;
            return this;
        }

        @Deprecated
        public Builder blocking(boolean blocking) {
            this.blocking = blocking;
            return this;
        }

        public Builder broadcastInterval(long broadcastInterval) {
            this.broadcastInterval = broadcastInterval;
            return this;
        }

        public Builder listener(Listener listener) {
            this.listener = listener;
            return this;
        }

        public Builder prefix(byte[] prefix) {
            this.prefix = Arrays.copyOf(prefix, prefix.length);
            return this;
        }

        public Builder setClientUncaughtExceptionHandlers(Thread.UncaughtExceptionHandler clientExHandler) {
            this.clientExHandler = clientExHandler;
            return this;
        }

        public Builder setServerUncaughtExceptionHandlers(Thread.UncaughtExceptionHandler serverExHandler) {
            this.serverExHandler = serverExHandler;
            return this;
        }

        public ZBeacon build() {
            ZBeacon zbeacon = new ZBeacon(this.clientHost, this.serverAddr, this.port, this.beacon, this.broadcastInterval, this.ignoreLocalAddress, this.blocking);
            if (this.listener != null) {
                zbeacon.setListener(this.listener);
            }
            if (this.prefix != null) {
                zbeacon.setPrefix(this.prefix);
            }
            if (this.serverExHandler != null) {
                zbeacon.serverExHandler.set(this.serverExHandler);
            }
            if (this.clientExHandler != null) {
                zbeacon.clientExHandler.set(this.clientExHandler);
            }
            return zbeacon;
        }
    }
}

