/*
 * Decompiled with CFR 0.152.
 */
package org.zeromq;

import java.io.Closeable;
import java.io.IOException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.Selector;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.zeromq.ZContext;
import org.zeromq.ZMQ;
import zmq.ZMQ;
import zmq.poll.PollItem;
import zmq.util.Objects;
import zmq.util.function.BiFunction;

public class ZPoller
implements Closeable {
    public static final int POLLIN = 1;
    public static final int POLLOUT = 2;
    public static final int POLLERR = 4;
    public static final int IN = 1;
    public static final int OUT = 2;
    public static final int ERR = 4;
    public static final int READABLE = 1;
    public static final int WRITABLE = 2;
    private final Selector selector;
    private final ItemCreator creator;
    private final Map<Object, CompositePollItem> items;
    private final Set<CompositePollItem> all;
    private EventsHandler globalHandler;

    public ZPoller(ZPoller poller) {
        this(poller.creator, null, poller.selector);
    }

    public ZPoller(Selector selector) {
        this(new SimpleCreator(), null, selector);
    }

    public ZPoller(ZContext context) {
        this((ItemCreator)new SimpleCreator(), context);
    }

    public ZPoller(ItemCreator creator, ZPoller poller) {
        this(creator, null, poller.selector);
    }

    public ZPoller(ItemCreator creator, ZContext context) {
        this(creator, context, context.selector());
    }

    public ZPoller(ItemCreator creator, Selector selector) {
        this(creator, null, selector);
    }

    private ZPoller(ItemCreator creator, ZContext context, Selector selector) {
        Objects.requireNonNull(creator, "Item creator is mandatory for ZPoller");
        Objects.requireNonNull(selector, "Selector is mandatory for ZPoller");
        this.creator = creator;
        this.selector = selector;
        this.items = new HashMap<Object, CompositePollItem>();
        this.all = new HashSet<CompositePollItem>();
    }

    protected ItemHolder create(ZMQ.Socket socket, EventsHandler handler, int events) {
        Objects.requireNonNull(socket, "Socket has to be non-null");
        return this.creator.create(socket, handler, events);
    }

    protected ItemHolder create(SelectableChannel channel, EventsHandler handler, int events) {
        Objects.requireNonNull(channel, "Channel has to be non-null");
        return this.creator.create(channel, handler, events);
    }

    public void setGlobalHandler(EventsHandler globalHandler) {
        this.globalHandler = globalHandler;
    }

    public EventsHandler getGlobalHandler() {
        return this.globalHandler;
    }

    public final boolean register(ZMQ.Socket socket, BiFunction<ZMQ.Socket, Integer, Boolean> handler, int events) {
        return this.register(socket, (EventsHandler)new ComposeEventsHandler(handler, null), events);
    }

    public final boolean register(ZMQ.Socket socket, EventsHandler handler, int events) {
        if (socket == null) {
            return false;
        }
        return this.add(socket, this.create(socket, handler, events));
    }

    public final boolean register(ZMQ.Socket socket, EventsHandler handler) {
        return this.register(socket, handler, 7);
    }

    public final boolean register(ZMQ.Socket socket, int events) {
        return this.register(socket, this.globalHandler, events);
    }

    public final boolean register(SelectableChannel channel, BiFunction<SelectableChannel, Integer, Boolean> handler, int events) {
        return this.register(channel, (EventsHandler)new ComposeEventsHandler(null, handler), events);
    }

    public final boolean register(SelectableChannel channel, EventsHandler handler, int events) {
        if (channel == null) {
            return false;
        }
        return this.add(channel, this.create(channel, handler, events));
    }

    public final boolean register(SelectableChannel channel, EventsHandler handler) {
        return this.register(channel, handler, 7);
    }

    public final boolean register(SelectableChannel channel, int events) {
        return this.register(channel, this.globalHandler, events);
    }

    public final boolean register(ItemHolder item) {
        return this.add(null, item);
    }

    public final boolean unregister(Object socketOrChannel) {
        boolean rc;
        if (socketOrChannel == null) {
            return false;
        }
        CompositePollItem items = this.items.remove(socketOrChannel);
        boolean bl = rc = items != null;
        if (rc) {
            this.all.remove(items);
        }
        return rc;
    }

    public int poll(long timeout) {
        return this.poll(timeout, true);
    }

    protected int poll(long timeout, boolean dispatchEvents) {
        HashSet<PollItem> pollItems = new HashSet<PollItem>();
        for (CompositePollItem it : this.all) {
            pollItems.add(it.item());
        }
        int rc = this.poll(this.selector, timeout, pollItems);
        if (!dispatchEvents) {
            return rc;
        }
        if (this.dispatch(this.all, pollItems.size())) {
            return rc;
        }
        return -1;
    }

    private boolean dispatch(Set<CompositePollItem> all, int size) {
        for (CompositePollItem item : all) {
            item.handler(this.globalHandler);
        }
        return this.dispatch((Collection<? extends ItemHolder>)all, size);
    }

    protected int poll(Selector selector, long tout, Collection<PollItem> items) {
        int size = items.size();
        return ZMQ.poll(selector, items.toArray(new PollItem[size]), size, tout);
    }

    protected boolean dispatch(Collection<? extends ItemHolder> all, int size) {
        ItemHolder[] array;
        for (ItemHolder holder : array = all.toArray(new ItemHolder[all.size()])) {
            PollItem item;
            int events;
            EventsHandler handler = holder.handler();
            if (handler == null) {
                handler = this.globalHandler;
            }
            if (handler == null || (events = (item = holder.item()).readyOps()) <= 0) continue;
            ZMQ.Socket socket = holder.socket();
            SelectableChannel channel = holder.item().getRawSocket();
            if (socket != null) {
                assert (channel == null);
                if (!handler.events(socket, events)) {
                    return false;
                }
            }
            if (channel == null) continue;
            assert (socket == null);
            if (handler.events(channel, events)) continue;
            return false;
        }
        return true;
    }

    public boolean dispatch() {
        return this.dispatch(this.all, this.all.size());
    }

    public boolean isReadable(SelectableChannel channel) {
        return this.readable((Object)channel);
    }

    public boolean readable(SelectableChannel channel) {
        return this.readable((Object)channel);
    }

    public boolean isReadable(ZMQ.Socket socket) {
        return this.readable(socket);
    }

    public boolean readable(ZMQ.Socket socket) {
        return this.readable((Object)socket);
    }

    public boolean readable(Object socketOrChannel) {
        PollItem it = this.filter(socketOrChannel, 1);
        if (it == null) {
            return false;
        }
        return it.isReadable();
    }

    public boolean pollin(ZMQ.Socket socket) {
        return this.isReadable(socket);
    }

    public boolean pollin(SelectableChannel channel) {
        return this.isReadable(channel);
    }

    public boolean isWritable(SelectableChannel channel) {
        return this.writable((Object)channel);
    }

    public boolean writable(SelectableChannel channel) {
        return this.writable((Object)channel);
    }

    public boolean isWritable(ZMQ.Socket socket) {
        return this.writable((Object)socket);
    }

    public boolean writable(ZMQ.Socket socket) {
        return this.writable((Object)socket);
    }

    public boolean writable(Object socketOrChannel) {
        PollItem it = this.filter(socketOrChannel, 2);
        if (it == null) {
            return false;
        }
        return it.isWritable();
    }

    public boolean pollout(ZMQ.Socket socket) {
        return this.isWritable(socket);
    }

    public boolean pollout(SelectableChannel channel) {
        return this.isWritable(channel);
    }

    public boolean isError(SelectableChannel channel) {
        return this.error((Object)channel);
    }

    public boolean error(SelectableChannel channel) {
        return this.error((Object)channel);
    }

    public boolean isError(ZMQ.Socket socket) {
        return this.error((Object)socket);
    }

    public boolean error(ZMQ.Socket socket) {
        return this.error((Object)socket);
    }

    public boolean error(Object socketOrChannel) {
        PollItem it = this.filter(socketOrChannel, 4);
        if (it == null) {
            return false;
        }
        return it.isError();
    }

    public boolean pollerr(ZMQ.Socket socket) {
        return this.isError(socket);
    }

    public boolean pollerr(SelectableChannel channel) {
        return this.isError(channel);
    }

    @Override
    public void close() throws IOException {
        this.destroy();
    }

    public void destroy() {
    }

    protected boolean add(Object socketOrChannel, ItemHolder holder) {
        boolean rc;
        if (socketOrChannel == null) {
            ZMQ.Socket socket = holder.socket();
            SelectableChannel ch = holder.item().getRawSocket();
            if (ch == null) {
                assert (socket != null);
                socketOrChannel = socket;
            } else if (socket == null) {
                socketOrChannel = ch;
            }
        }
        assert (socketOrChannel != null);
        CompositePollItem aggregate = this.items.get(socketOrChannel);
        if (aggregate == null) {
            aggregate = new CompositePollItem(socketOrChannel);
            this.items.put(socketOrChannel, aggregate);
        }
        if (rc = aggregate.holders.add(holder)) {
            this.all.add(aggregate);
        }
        return rc;
    }

    @Deprecated
    protected Set<ItemHolder> createContainer(int size) {
        return new HashSet<ItemHolder>(size);
    }

    protected Collection<? extends ItemHolder> items() {
        for (CompositePollItem item : this.all) {
            item.handler(this.globalHandler);
        }
        return this.all;
    }

    protected Iterable<ItemHolder> items(Object socketOrChannel) {
        CompositePollItem aggregate = this.items.get(socketOrChannel);
        if (aggregate == null) {
            return Collections.emptySet();
        }
        return aggregate.holders;
    }

    protected PollItem filter(Object socketOrChannel, int events) {
        if (socketOrChannel == null) {
            return null;
        }
        CompositePollItem item = this.items.get(socketOrChannel);
        if (item == null) {
            return null;
        }
        PollItem pollItem = item.item();
        if (pollItem == null) {
            return null;
        }
        if (pollItem.hasEvent(events)) {
            return pollItem;
        }
        return null;
    }

    public static interface ItemCreator {
        public ItemHolder create(ZMQ.Socket var1, EventsHandler var2, int var3);

        public ItemHolder create(SelectableChannel var1, EventsHandler var2, int var3);
    }

    public static class SimpleCreator
    implements ItemCreator {
        @Override
        public ItemHolder create(ZMQ.Socket socket, EventsHandler handler, int events) {
            return new ZPollItem(socket, handler, events);
        }

        @Override
        public ItemHolder create(SelectableChannel channel, EventsHandler handler, int events) {
            return new ZPollItem(channel, handler, events);
        }
    }

    public static interface EventsHandler {
        public boolean events(ZMQ.Socket var1, int var2);

        public boolean events(SelectableChannel var1, int var2);
    }

    public static interface ItemHolder {
        public PollItem item();

        public ZMQ.Socket socket();

        public EventsHandler handler();
    }

    public static class ComposeEventsHandler
    implements EventsHandler {
        private final BiFunction<ZMQ.Socket, Integer, Boolean> sockets;
        private final BiFunction<SelectableChannel, Integer, Boolean> channels;

        public ComposeEventsHandler(BiFunction<ZMQ.Socket, Integer, Boolean> sockets, BiFunction<SelectableChannel, Integer, Boolean> channels) {
            this.sockets = sockets;
            this.channels = channels;
        }

        @Override
        public boolean events(ZMQ.Socket socket, int events) {
            assert (this.sockets != null) : "A Socket Handler needs to be set";
            return this.sockets.apply(socket, events);
        }

        @Override
        public boolean events(SelectableChannel channel, int events) {
            assert (this.channels != null) : "A SelectableChannel Handler needs to be set";
            return this.channels.apply(channel, events);
        }
    }

    private static class CompositePollItem
    implements ItemHolder,
    EventsHandler {
        private final Collection<ItemHolder> holders = new HashSet<ItemHolder>();
        private final ZMQ.Socket socket;
        private final SelectableChannel channel;
        private PollItem item;
        private EventsHandler globalHandler;

        public CompositePollItem(Object socketOrChannel) {
            this.socket = socketOrChannel instanceof ZMQ.Socket ? (ZMQ.Socket)socketOrChannel : null;
            SelectableChannel selectableChannel = this.channel = socketOrChannel instanceof SelectableChannel ? (SelectableChannel)socketOrChannel : null;
            assert (this.socket != null || this.channel != null);
        }

        @Override
        public PollItem item() {
            if (this.item == null) {
                this.item = this.createItem();
            }
            return this.item;
        }

        private PollItem createItem() {
            if (this.socket == null) {
                return new PollItem(this.channel, this.ops());
            }
            return new PollItem(this.socket.base(), this.ops());
        }

        private int ops() {
            int ops = 0;
            for (ItemHolder holder : this.holders) {
                int interest = holder.item().zinterestOps();
                ops |= interest;
            }
            return ops;
        }

        @Override
        public ZMQ.Socket socket() {
            return this.socket;
        }

        @Override
        public EventsHandler handler() {
            return this;
        }

        @Override
        public boolean events(ZMQ.Socket socket, int events) {
            boolean has = false;
            boolean first = true;
            for (ItemHolder holder : this.holders) {
                EventsHandler handler;
                if (!holder.item().hasEvent(events)) continue;
                if (first) {
                    first = false;
                    has = true;
                }
                if ((handler = holder.handler() == null ? this.globalHandler : holder.handler()) == null) continue;
                has &= handler.events(socket, events);
            }
            return has;
        }

        @Override
        public boolean events(SelectableChannel channel, int events) {
            boolean has = false;
            boolean first = true;
            for (ItemHolder holder : this.holders) {
                EventsHandler handler;
                if (!holder.item().hasEvent(events) || (handler = holder.handler() == null ? this.globalHandler : holder.handler()) == null) continue;
                boolean evts = handler.events(channel, events);
                if (first) {
                    first = false;
                    has = evts;
                    continue;
                }
                has &= evts;
            }
            return has;
        }

        private ItemHolder handler(EventsHandler handler) {
            this.globalHandler = handler;
            return this;
        }
    }

    public static class ZPollItem
    extends ZMQ.PollItem
    implements ItemHolder {
        private final EventsHandler handler;

        public ZPollItem(ZMQ.Socket socket, EventsHandler handler, int ops) {
            super(socket, ops);
            this.handler = handler;
            assert (this.item() != null);
        }

        public ZPollItem(SelectableChannel channel, EventsHandler handler, int ops) {
            super(channel, ops);
            this.handler = handler;
            assert (this.item() != null);
        }

        @Override
        public PollItem item() {
            return this.base();
        }

        @Override
        public ZMQ.Socket socket() {
            return this.getSocket();
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.item() == null ? 0 : this.item().hashCode());
            result = 31 * result + (this.getRawSocket() == null ? 0 : this.getRawSocket().hashCode());
            result = 31 * result + (this.socket() == null ? 0 : this.socket().hashCode());
            result = 31 * result + (this.handler() == null ? 0 : this.handler().hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof ItemHolder)) {
                return false;
            }
            ItemHolder other = (ItemHolder)obj;
            if (other.item() == null) {
                return false;
            }
            if (this.item().getRawSocket() == null ? other.item().getRawSocket() != null : !this.item().getRawSocket().equals(other.item().getRawSocket())) {
                return false;
            }
            if (this.socket() == null ? other.socket() != null : !this.socket().equals(other.socket())) {
                return false;
            }
            return !(this.handler() == null ? other.handler() != null : !this.handler().equals(other.handler()));
        }

        @Override
        public EventsHandler handler() {
            return this.handler;
        }
    }
}

