/*
 * Decompiled with CFR 0.152.
 */
package org.zeromq;

import java.util.Collection;
import org.zeromq.EmbeddedLibraryTools;
import org.zeromq.ZMQ;

public class App {
    public static void main(String[] args) throws Exception {
        Package p = App.class.getPackage();
        String appname = p.getSpecificationTitle();
        String versionMaven = p.getSpecificationVersion();
        String[] version = new String[]{"", ""};
        if (p.getImplementationVersion() != null) {
            version = p.getImplementationVersion().split(" ", 2);
        }
        String zmqVersion = null;
        try {
            int major = ZMQ.version_major();
            int minor = ZMQ.version_minor();
            int patch = ZMQ.version_patch();
            zmqVersion = major + "." + minor + "." + patch;
        }
        catch (Throwable x) {
            zmqVersion = "ERROR! " + x.getMessage();
        }
        String fmt = "%-7.7s %-15.15s %s%n";
        System.out.printf("%-7.7s %-15.15s %s%n", "ZeroMQ", "version:", zmqVersion);
        System.out.printf("%-7.7s %-15.15s %s%n", appname, "version:", versionMaven);
        System.out.printf("%-7.7s %-15.15s %s%n", appname, "build time:", version[1]);
        System.out.printf("%-7.7s %-15.15s %s%n", appname, "build commit:", version[0]);
        System.out.println();
        System.out.println("JNI lib location:       " + (EmbeddedLibraryTools.LOADED_EMBEDDED_LIBRARY ? "embedded" : "java.library.path"));
        System.out.println("current platform:       " + EmbeddedLibraryTools.getCurrentPlatformIdentifier());
        Collection<String> files = EmbeddedLibraryTools.getEmbeddedLibraryList();
        for (String file : files) {
            System.out.println("embedded library:       " + file);
        }
    }
}

