/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.jrebel.gradle;

import groovy.lang.Closure;
import java.io.File;
import java.util.Collection;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.plugins.JavaBasePlugin;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Copy;
import org.gradle.api.tasks.SourceSet;
import org.zeroturnaround.jrebel.gradle.IncrementalRebelGenerateTask;
import org.zeroturnaround.jrebel.gradle.SourceSetDefaults;
import org.zeroturnaround.jrebel.gradle.dsl.RebelDslMain;
import org.zeroturnaround.jrebel.gradle.util.LoggerWrapper;

public class IncrementalRebelPlugin
implements Plugin<Project> {
    private LoggerWrapper log;

    public void apply(final Project project) {
        this.log = new LoggerWrapper(project.getLogger());
        this.log.info("Configuring Rebel plugin for project " + project.getName());
        project.getExtensions().create("rebel", RebelDslMain.class, new Object[0]);
        project.getPlugins().withType(JavaBasePlugin.class).all((Action)new Action<JavaBasePlugin>(){

            public void execute(JavaBasePlugin javaPlugin) {
                ((JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class)).getSourceSets().all((Action)new Action<SourceSet>(){

                    public void execute(SourceSet sourceSet) {
                        IncrementalRebelPlugin.this.log.info("Creating task for sourceSet " + sourceSet.getName());
                        IncrementalRebelPlugin.this.registerTaskForSourceSet(project, sourceSet);
                    }
                });
            }
        });
    }

    private void registerTaskForSourceSet(Project project, final SourceSet sourceSet) {
        final SourceSetDefaults sourceSetDefaults = new SourceSetDefaults((Provider<Collection<File>>)project.provider((Callable)new Callable<Collection<File>>(){

            @Override
            public Collection<File> call() throws Exception {
                return sourceSet.getOutput().getClassesDirs().getFiles();
            }
        }), (Provider<File>)project.provider((Callable)new Callable<File>(){

            @Override
            public File call() throws Exception {
                return sourceSet.getOutput().getResourcesDir();
            }
        }), sourceSet.getName(), sourceSet.getName());
        String taskName = sourceSet.getTaskName("generateRebel", null);
        final IncrementalRebelGenerateTask generateRebelSourceSet = (IncrementalRebelGenerateTask)project.getTasks().create(taskName, IncrementalRebelGenerateTask.class, (Action)new Action<IncrementalRebelGenerateTask>(){

            public void execute(IncrementalRebelGenerateTask task) {
                task.configureSourceSet(sourceSetDefaults);
            }
        });
        generateRebelSourceSet.setDescription("Generate JRebel xml configuration for this SourceSet");
        if (sourceSet.getName().equals("main")) {
            Copy processResourcesTask = (Copy)project.getTasks().getByName(sourceSet.getProcessResourcesTaskName());
            processResourcesTask.dependsOn(new Object[]{generateRebelSourceSet});
            processResourcesTask.from(new Object[]{new Closure<File>((Object)generateRebelSourceSet){

                public File call() {
                    return generateRebelSourceSet.getJRebelBuildDir();
                }
            }});
            Task defaultTask = project.getTasks().create("generateRebel");
            defaultTask.setDescription("Generate JRebel xml configuration for the main SourceSet");
            defaultTask.dependsOn(new Object[]{generateRebelSourceSet});
        }
    }
}

