/**
 * Copyright 2007 ZeroTurnaround.com
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 **/

package org.zeroturnaround.javarebel;

/**
 * A factory for {@link Logger} that resolves a suitable implementation. 
 * Use {@link #getInstance()} method to get the {@link Logger} instance.
 * 
 * @author Jevgeni Kabanov (ekabanov@zeroturnaround.com)
 */
public class LoggerFactory {
  private static Logger INSTANCE;
  
  static {
    try {
      Class loggerClass = Class.forName("com.zeroturnaround.javarebel.SDKLoggerImpl");       
      INSTANCE = (Logger) loggerClass.newInstance();
    }
    catch (ClassNotFoundException e) {
    }
    catch (InstantiationException e) {
      e.printStackTrace();
      throw new RuntimeException(e);
    }
    catch (IllegalAccessException e) {
      e.printStackTrace();
      throw new RuntimeException(e);
    }
    
    //"Do nothing" implementation
    if (INSTANCE == null) {
      INSTANCE = new Logger() {

        public boolean isEnabled() {
          return false;
        }
        public void echo(String message) {
        }
        public void echo() {
        }
        public void error(Throwable e) {
        }
        public void errorEcho(Throwable e) {
        }
        public void log(String message) {
        }
          public StopWatch createStopWatch(String category) {
            // TODO Auto-generated method stub
            return null;
          }
      };
    }
  }
  /**
   * Returns a suitable {@link Logger} implementation.
   * @return a suitable {@link Logger} implementation.
   */
  public static Logger getInstance() {
    return INSTANCE;
  }
}
