/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.bundled.javassist.runtime;

public class Desc {
    public static boolean useContextClassLoader = false;

    private static Class getClassObject(String name) throws ClassNotFoundException {
        if (useContextClassLoader) {
            return Thread.currentThread().getContextClassLoader().loadClass(name);
        }
        return Class.forName(name);
    }

    public static Class getClazz(String name) {
        try {
            return Desc.getClassObject(name);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("$class: internal error, could not find class '" + name + "' (Desc.useContextClassLoader: " + Boolean.toString(useContextClassLoader) + ")", e);
        }
    }

    public static Class[] getParams(String desc) {
        if (desc.charAt(0) != '(') {
            throw new RuntimeException("$sig: internal error");
        }
        return Desc.getType(desc, desc.length(), 1, 0);
    }

    public static Class getType(String desc) {
        Class[] result = Desc.getType(desc, desc.length(), 0, 0);
        if (result == null || result.length != 1) {
            throw new RuntimeException("$type: internal error");
        }
        return result[0];
    }

    private static Class[] getType(String desc, int descLen, int start, int num) {
        Class<Object> c;
        if (start >= descLen) {
            return new Class[num];
        }
        char c2 = desc.charAt(start);
        switch (c2) {
            case 'Z': {
                c = Boolean.TYPE;
                break;
            }
            case 'C': {
                c = Character.TYPE;
                break;
            }
            case 'B': {
                c = Byte.TYPE;
                break;
            }
            case 'S': {
                c = Short.TYPE;
                break;
            }
            case 'I': {
                c = Integer.TYPE;
                break;
            }
            case 'J': {
                c = Long.TYPE;
                break;
            }
            case 'F': {
                c = Float.TYPE;
                break;
            }
            case 'D': {
                c = Double.TYPE;
                break;
            }
            case 'V': {
                c = Void.TYPE;
                break;
            }
            case 'L': 
            case '[': {
                return Desc.getClassType(desc, descLen, start, num);
            }
            default: {
                return new Class[num];
            }
        }
        Class[] result = Desc.getType(desc, descLen, start + 1, num + 1);
        result[num] = c;
        return result;
    }

    private static Class[] getClassType(String desc, int descLen, int start, int num) {
        int end = start;
        while (desc.charAt(end) == '[') {
            ++end;
        }
        if (desc.charAt(end) == 'L' && (end = desc.indexOf(59, end)) < 0) {
            throw new IndexOutOfBoundsException("bad descriptor");
        }
        String cname = desc.charAt(start) == 'L' ? desc.substring(start + 1, end) : desc.substring(start, end + 1);
        Class[] result = Desc.getType(desc, descLen, end + 1, num + 1);
        try {
            result[num] = Desc.getClassObject(cname.replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e.getMessage());
        }
        return result;
    }
}

