/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.javarebel.maven;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.zeroturnaround.javarebel.maven.RebelClasspathResource;
import org.zeroturnaround.javarebel.maven.RebelResource;
import org.zeroturnaround.javarebel.maven.RebelWar;
import org.zeroturnaround.javarebel.maven.RebelWebResource;

class RebelXmlBuilder {
    private String fallbackClasspath;
    private List classpathDir = new ArrayList();
    private List classpathJar = new ArrayList();
    private List classpathJarset = new ArrayList();
    private List classpathDirset = new ArrayList();
    private RebelWar war;
    private List webResources = new ArrayList();

    RebelXmlBuilder() {
    }

    public void setFallbackClasspath(String fallbackClasspath) {
        this.fallbackClasspath = fallbackClasspath;
    }

    public void addClasspathDir(RebelClasspathResource dir) {
        this.classpathDir.add(dir);
    }

    public void addClasspathJar(RebelClasspathResource jar) {
        this.classpathJar.add(jar);
    }

    public void addClasspathJarset(RebelClasspathResource jarset) {
        this.classpathJarset.add(jarset);
    }

    public void addClasspathDirset(RebelClasspathResource dirset) {
        this.classpathDirset.add(dirset);
    }

    public void setWar(RebelWar war) {
        this.war = war;
    }

    public void addWebresource(RebelWebResource webResource) {
        this.webResources.add(webResource);
    }

    public void writeXml(Writer writer) throws IOException {
        RebelResource r;
        writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        writer.write("<application xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns=\"http://www.zeroturnaround.com\" xsi:schemaLocation=\"http://www.zeroturnaround.com http://www.zeroturnaround.com/alderaan/rebel-2_0.xsd\">\n");
        writer.write("\n");
        writer.write("\t<classpath");
        if (this.fallbackClasspath != null) {
            writer.write(" fallback=\"" + this.fallbackClasspath + "\"");
        }
        writer.write(">\n");
        Iterator i = this.classpathDir.iterator();
        while (i.hasNext()) {
            r = (RebelClasspathResource)i.next();
            writer.write("\t\t<dir name=\"" + RebelXmlBuilder.e(((RebelClasspathResource)r).getDirectory()) + "\">\n");
            this.writeExcludeInclude(writer, (RebelClasspathResource)r);
            writer.write("\t\t</dir>\n");
        }
        i = this.classpathJar.iterator();
        while (i.hasNext()) {
            r = (RebelClasspathResource)i.next();
            writer.write("\t\t<jar name=\"" + RebelXmlBuilder.e(((RebelClasspathResource)r).getJar()) + "\">\n");
            this.writeExcludeInclude(writer, (RebelClasspathResource)r);
            writer.write("\t\t</jar>\n");
        }
        i = this.classpathJarset.iterator();
        while (i.hasNext()) {
            r = (RebelClasspathResource)i.next();
            writer.write("\t\t<jarset dir=\"" + RebelXmlBuilder.e(((RebelClasspathResource)r).getJarset()) + "\">\n");
            this.writeExcludeInclude(writer, (RebelClasspathResource)r);
            writer.write("\t\t</jarset>\n");
        }
        i = this.classpathDirset.iterator();
        while (i.hasNext()) {
            r = (RebelClasspathResource)i.next();
            writer.write("\t\t<dirset dir=\"" + RebelXmlBuilder.e(((RebelClasspathResource)r).getDirset()) + "\">\n");
            this.writeExcludeInclude(writer, (RebelClasspathResource)r);
            writer.write("\t\t</dirset>\n");
        }
        writer.write("\t</classpath>\n");
        writer.write("\n");
        if (this.war != null && this.war.getPath() != null) {
            writer.write("\t<war dir=\"" + RebelXmlBuilder.e(this.war.getPath()) + "\"/>\n");
            writer.write("\n");
        }
        if (this.webResources.size() > 0) {
            writer.write("\t<web>\n");
            i = this.webResources.iterator();
            while (i.hasNext()) {
                r = (RebelWebResource)i.next();
                writer.write("\t\t<link target=\"" + RebelXmlBuilder.e(((RebelWebResource)r).getTarget()) + "\">\n");
                writer.write("\t\t\t<dir name=\"" + RebelXmlBuilder.e(((RebelWebResource)r).getDirectory()) + "\">\n");
                this.writeExcludeInclude(writer, (RebelWebResource)r);
                writer.write("\t\t\t</dir>\n");
                writer.write("\t\t</link>\n");
            }
            writer.write("\t</web>\n");
            writer.write("\n");
        }
        writer.write("</application>\n");
        writer.flush();
    }

    private void writeExcludeInclude(Writer writer, RebelClasspathResource r) throws IOException {
        this.writeExcludeInclude(writer, r, 3);
    }

    private void writeExcludeInclude(Writer writer, RebelWebResource r) throws IOException {
        this.writeExcludeInclude(writer, r, 4);
    }

    private void writeExcludeInclude(Writer writer, RebelResource r, int indent) throws IOException {
        Iterator i;
        String indention = StringUtils.repeat((String)"\t", (int)indent);
        if (r.getExcludes() != null) {
            i = r.getExcludes().iterator();
            while (i.hasNext()) {
                String exclude = (String)i.next();
                writer.write(indention + "<exclude name=\"" + RebelXmlBuilder.e(exclude) + "\"/>\n");
            }
        }
        if (r.getIncludes() != null) {
            i = r.getIncludes().iterator();
            while (i.hasNext()) {
                String include = (String)i.next();
                writer.write(indention + "<include name=\"" + RebelXmlBuilder.e(include) + "\"/>\n");
            }
        }
    }

    private static String e(String s) {
        return StringEscapeUtils.escapeXml((String)s);
    }
}

