/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.exec;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Set;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zeroturnaround.exec.InvalidExitValueException;
import org.zeroturnaround.exec.MessageLogger;
import org.zeroturnaround.exec.ProcessAttributes;
import org.zeroturnaround.exec.ProcessOutput;
import org.zeroturnaround.exec.ProcessResult;
import org.zeroturnaround.exec.listener.ProcessListener;
import org.zeroturnaround.exec.stop.ProcessStopper;
import org.zeroturnaround.exec.stream.ExecuteStreamHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class WaitForProcess
implements Callable<ProcessResult> {
    private static final Logger log = LoggerFactory.getLogger(WaitForProcess.class);
    private static final int MAX_OUTPUT_SIZE_IN_ERROR_MESSAGE = 5000;
    private final Process process;
    private final ProcessAttributes attributes;
    private final ProcessStopper stopper;
    private final ExecuteStreamHandler streams;
    private final ByteArrayOutputStream out;
    private final ProcessListener listener;
    private final MessageLogger messageLogger;

    public WaitForProcess(Process process, ProcessAttributes attributes, ProcessStopper stopper, ExecuteStreamHandler streams, ByteArrayOutputStream out, ProcessListener listener, MessageLogger messageLogger) {
        this.process = process;
        this.attributes = attributes;
        this.stopper = stopper;
        this.streams = streams;
        this.out = out;
        this.listener = listener;
        this.messageLogger = messageLogger;
    }

    public Process getProcess() {
        return this.process;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProcessResult call() throws IOException, InterruptedException {
        try {
            int exit;
            block8: {
                boolean finished = false;
                try {
                    exit = this.process.waitFor();
                    finished = true;
                    this.messageLogger.message(log, "{} stopped with exit code {}", this, exit);
                    if (finished) break block8;
                }
                catch (Throwable throwable) {
                    if (!finished) {
                        this.messageLogger.message(log, "Stopping {}...", this);
                        this.stopper.stop(this.process);
                    }
                    if (this.streams != null) {
                        this.streams.stop();
                    }
                    this.closeStreams(this.process);
                    throw throwable;
                }
                this.messageLogger.message(log, "Stopping {}...", this);
                this.stopper.stop(this.process);
            }
            if (this.streams != null) {
                this.streams.stop();
            }
            this.closeStreams(this.process);
            ProcessOutput output = this.out == null ? null : new ProcessOutput(this.out.toByteArray());
            ProcessResult result = new ProcessResult(exit, output);
            this.checkExit(result);
            ProcessResult processResult = result;
            return processResult;
        }
        finally {
            this.listener.afterStop(this.process);
        }
    }

    private void checkExit(ProcessResult result) {
        Set<Integer> allowedExitValues = this.attributes.getAllowedExitValues();
        if (allowedExitValues != null && !allowedExitValues.contains(result.getExitValue())) {
            String out;
            StringBuilder sb = new StringBuilder();
            sb.append("Unexpected exit value: ").append(result.getExitValue());
            sb.append(", allowed exit values: ").append(allowedExitValues);
            sb.append(", executed command ").append(this.attributes.getCommand());
            if (this.attributes.getDirectory() != null) {
                sb.append(" in directory ").append(this.attributes.getDirectory());
            }
            if (!this.attributes.getEnvironment().isEmpty()) {
                sb.append(" with environment ").append(this.attributes.getEnvironment());
            }
            if (result.hasOutput() && (out = result.getOutput().getString()).length() <= 5000) {
                sb.append(", output was:\n").append(out.trim());
            }
            throw new InvalidExitValueException(sb.toString(), result);
        }
    }

    private void closeStreams(Process process) throws IOException {
        IOException caught = null;
        try {
            process.getInputStream().close();
        }
        catch (IOException e) {
            log.error("Failed to close process input stream:", (Throwable)e);
            caught = e;
        }
        try {
            process.getOutputStream().close();
        }
        catch (IOException e) {
            log.error("Failed to close process output stream:", (Throwable)e);
            caught = e;
        }
        try {
            process.getErrorStream().close();
        }
        catch (IOException e) {
            log.error("Failed to close process error stream:", (Throwable)e);
            caught = e;
        }
        if (caught != null) {
            throw caught;
        }
    }

    public String toString() {
        return this.process.toString();
    }
}

