/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.process;

import com.sun.jna.Pointer;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.Field;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zeroturnaround.process.win.Kernel32;
import org.zeroturnaround.process.win.W32API;

public final class PidUtil {
    private static final Logger log = LoggerFactory.getLogger(PidUtil.class);

    public static int getMyPid() {
        Integer result = MyPidHolder.MY_PID;
        if (result == null) {
            throw new UnsupportedOperationException("Could not detect my process ID.");
        }
        return result;
    }

    private static int getPidFromProcessName(String processName) {
        Pattern pattern = Pattern.compile("^([0-9]+)@.+$", 2);
        Matcher matcher = pattern.matcher(processName);
        if (matcher.matches()) {
            return Integer.parseInt(matcher.group(1));
        }
        throw new IllegalArgumentException("Invalid process name " + processName);
    }

    public static int getPid(Process process) {
        if (process == null) {
            throw new IllegalArgumentException("Process must be provided.");
        }
        int result = PidUtil.doGetPid(process);
        log.debug("Found PID for {}: {}", (Object)process, (Object)result);
        return result;
    }

    private static int doGetPid(Process process) {
        String type = process.getClass().getName();
        try {
            if (type.equals("java.lang.UNIXProcess")) {
                return PidUtil.getPidFromUnixProcess(process);
            }
            if (type.equals("java.lang.Win32Process") || type.equals("java.lang.ProcessImpl")) {
                return PidUtil.getPidfromWin32Process(process);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not detect PID form " + process, e);
        }
        throw new IllegalArgumentException("Unknown process class " + type);
    }

    private static int getPidFromUnixProcess(Process process) throws NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Field f = process.getClass().getDeclaredField("pid");
        f.setAccessible(true);
        return f.getInt(process);
    }

    private static int getPidfromWin32Process(Process process) throws NoSuchFieldException, IllegalAccessException {
        return PidUtil.getPidfromHandle(PidUtil.getHandle(process));
    }

    private static long getHandle(Process process) throws NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Field f = process.getClass().getDeclaredField("handle");
        f.setAccessible(true);
        return f.getLong(process);
    }

    private static int getPidfromHandle(long value) {
        Kernel32 kernel = Kernel32.INSTANCE;
        W32API.HANDLE handle = new W32API.HANDLE();
        handle.setPointer(Pointer.createConstant((long)value));
        return kernel.GetProcessId(handle);
    }

    private static class MyPidHolder {
        private static final Integer MY_PID = MyPidHolder.findMyPid();

        private MyPidHolder() {
        }

        private static Integer findMyPid() {
            Integer result = null;
            try {
                RuntimeMXBean rtb = ManagementFactory.getRuntimeMXBean();
                String processName = rtb.getName();
                result = PidUtil.getPidFromProcessName(processName);
                log.debug("My process name: {}", (Object)processName);
                log.debug("My PID: {}", (Object)result);
            }
            catch (Exception e) {
                log.error("Could not detect my PID:", (Throwable)e);
            }
            return result;
        }
    }
}

