/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.process;

import java.io.IOException;
import org.zeroturnaround.process.AbstractProcess;

public abstract class PollingProcess
extends AbstractProcess {
    private volatile long intervalForCheckingFinished = 1000L;

    public long getIntervalForCheckingFinished() {
        return this.intervalForCheckingFinished;
    }

    public void setIntervalForCheckingFinished(long intervalForCheckingFinished) {
        this.intervalForCheckingFinished = intervalForCheckingFinished;
    }

    @Override
    public void waitFor() throws InterruptedException {
        while (true) {
            try {
                boolean alive = this.isAlive();
                this.log.trace("{}\u00a0is alive: {}", (Object)this.getDescription(), (Object)alive);
                if (!alive) {
                    return;
                }
            }
            catch (IOException e) {
                this.log.debug("Failed to check if process {}\u00a0is alive:", (Object)this.getDescription(), (Object)e);
            }
            Thread.sleep(this.intervalForCheckingFinished);
        }
    }
}

