/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.zip.transform;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.zeroturnaround.zip.FileSource;
import org.zeroturnaround.zip.commons.FileUtils;
import org.zeroturnaround.zip.commons.IOUtils;
import org.zeroturnaround.zip.transform.ZipEntrySourceZipEntryTransformer;
import org.zeroturnaround.zip.transform.ZipEntryTransformer;

public abstract class FileZipEntryTransformer
implements ZipEntryTransformer {
    protected abstract void transform(ZipEntry var1, File var2, File var3) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transform(InputStream in, ZipEntry zipEntry, ZipOutputStream out) throws IOException {
        File inFile = null;
        File outFile = null;
        try {
            inFile = File.createTempFile("zip", null);
            outFile = File.createTempFile("zip", null);
            FileZipEntryTransformer.copy(in, inFile);
            this.transform(zipEntry, inFile, outFile);
            FileSource source = new FileSource(zipEntry.getName(), outFile);
            ZipEntrySourceZipEntryTransformer.addEntry(source, out);
        }
        catch (Throwable throwable) {
            FileUtils.deleteQuietly(inFile);
            FileUtils.deleteQuietly(outFile);
            throw throwable;
        }
        FileUtils.deleteQuietly(inFile);
        FileUtils.deleteQuietly(outFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copy(InputStream in, File file) throws IOException {
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
        try {
            IOUtils.copy(in, out);
        }
        finally {
            IOUtils.closeQuietly(out);
        }
    }
}

